// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunCreateReader is a Reader for the LunCreate structure.
type LunCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewLunCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLunCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunCreateCreated creates a LunCreateCreated with default headers values
func NewLunCreateCreated() *LunCreateCreated {
	return &LunCreateCreated{}
}

/*
LunCreateCreated describes a response with status code 201, with default header values.

Created
*/
type LunCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.LunResponse
}

// IsSuccess returns true when this lun create created response has a 2xx status code
func (o *LunCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun create created response has a 3xx status code
func (o *LunCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun create created response has a 4xx status code
func (o *LunCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun create created response has a 5xx status code
func (o *LunCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this lun create created response a status code equal to that given
func (o *LunCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the lun create created response
func (o *LunCreateCreated) Code() int {
	return 201
}

func (o *LunCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lunCreateCreated %s", 201, payload)
}

func (o *LunCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lunCreateCreated %s", 201, payload)
}

func (o *LunCreateCreated) GetPayload() *models.LunResponse {
	return o.Payload
}

func (o *LunCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.LunResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunCreateAccepted creates a LunCreateAccepted with default headers values
func NewLunCreateAccepted() *LunCreateAccepted {
	return &LunCreateAccepted{}
}

/*
LunCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LunCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.LunJobLinkResponse
}

// IsSuccess returns true when this lun create accepted response has a 2xx status code
func (o *LunCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun create accepted response has a 3xx status code
func (o *LunCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun create accepted response has a 4xx status code
func (o *LunCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun create accepted response has a 5xx status code
func (o *LunCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this lun create accepted response a status code equal to that given
func (o *LunCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the lun create accepted response
func (o *LunCreateAccepted) Code() int {
	return 202
}

func (o *LunCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lunCreateAccepted %s", 202, payload)
}

func (o *LunCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lunCreateAccepted %s", 202, payload)
}

func (o *LunCreateAccepted) GetPayload() *models.LunJobLinkResponse {
	return o.Payload
}

func (o *LunCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.LunJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunCreateDefault creates a LunCreateDefault with default headers values
func NewLunCreateDefault(code int) *LunCreateDefault {
	return &LunCreateDefault{
		_statusCode: code,
	}
}

/*
	LunCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917927 | The specified volume was not found. |
| 918235 | A volume with the specified UUID was not found. |
| 918236 | The specified `location.volume.uuid` and `location.volume.name` do not refer to the same volume. |
| 1260121 | Cloning a LUN to a volume different than the source volume is not supported. |
| 1260136 | The specified destination for a clone operation already exists as a LUN, namespace, or file. |
| 2621462 | The specified SVM does not exist. |
| 2621706 | The specified `svm.uuid` and `svm.name` do not refer to the same SVM. |
| 2621707 | No SVM was specified. Either `svm.name` or `svm.uuid` must be supplied. |
| 5242927 | The specified qtree was not found. |
| 5242950 | The specified `location.qtree.id` and `location.qtree.name` do not refer to the same qtree. |
| 5374121 | A LUN name can only contain characters A-Z, a-z, 0-9, "-", ".", "_", "{" and "}". |
| 5374123 | A negative size was provided for the LUN. |
| 5374124 | The specified size is too small for the LUN. |
| 5374125 | The specified size is too large for the LUN. |
| 5374127 | The specified LUN name is invalid. |
| 5374129 | LUNs cannot be created on a load sharing mirror volume. |
| 5374130 | An invalid size value was provided. |
| 5374237 | LUNs cannot be created on an SVM root volume. |
| 5374238 | LUNs cannot be created in snapshots. |
| 5374241 | A size value with invalid units was provided. |
| 5374242 | A LUN or NVMe namespace already exists at the specified path. |
| 5374352 | An invalid name was provided for the LUN. |
| 5374614 | The specified storage availability zone does not exist. |
| 5374707 | Creating a LUN in the specific volume is not allowed because the volume is reserved for an application. |
| 5374858 | The volume specified by `name` is not the same as that specified by `location.volume`. |
| 5374859 | No volume was specified for the LUN. |
| 5374860 | The qtree specified by `name` is not the same as that specified by `location.qtree`. |
| 5374861 | The LUN base name specified by `name` is not the same as that specified by `location.logical_unit`. |
| 5374862 | No LUN path base name was provided for the LUN. |
| 5374863 | An error occurred after successfully creating the LUN. Some properties were not set. |
| 5374874 | The specified `clone.source.uuid` and `clone.source.name` do not refer to the same LUN. |
| 5374875 | The specified `clone.source` was not found. |
| 5374876 | The specified `clone.source` was not found. |
| 5374883 | The property cannot be specified when creating a LUN clone. The `target` property of the error object identifies the property. |
| 5374884 | A property that is required when creating a new LUN that is not a LUN clone or LUN copy was not supplied. The `target` property of the error object identifies the property. |
| 5374886 | An error occurred after successfully creating the LUN preventing the retrieval of its properties. |
| 5374899 | The `clone.source.uuid` property is not supported when specifying a source LUN from a snapshot. |
| 5374928 | An incomplete attribute name/value pair was supplied. |
| 5374929 | The combined sizes of an attribute name and value are too large. |
| 5374932 | A name for an attribute was duplicated. |
| 5374942 | The property cannot be specified at the same time when creating a LUN as a clone. The `target` property of the error object identifies the other property given with clone. |
| 5374943 | The property cannot be specified at the same time when creating a LUN as a copy. The `target` property of the error object identifies the other property given with copy. |
| 5374944 | The property cannot be specified when converting an NVMe namespace into a LUN. The `target` property of the error object identifies the property. |
| 5375054 | The source LUN is required when requesting an SVM copy operation. |
| 5375059 | An unsuitable QoS policy was specified. |
| 5375061 | The specified `location.storage_availability_zone.uuid` and `location.storage_availability_zone.name` do not refer to the same storage availability zone. |
| 5376461 | The specified LUN name is invalid. |
| 5376462 | The specified LUN name is too long. |
| 5376463 | The snapshot portion of the specified LUN name is too long. |
| 5376469 | The property cannot be set during the LUN create operation on this platform. |
| 5376515 | The specified storage availability zone is not configured for provisioning on the specified SVM. |
| 5440509 | No suitable storage can be found for the specified requirements. |
| 5440688 | A LUN cannot be created with the same name as an existing LUN. |
| 5702832 | A LUN or namespace with the same name is already being created. LUN and namespace names must be unique within an SVM. |
| 7018877 | Maximum combined total (50) of file and LUN copy and move operations reached. When one or more of the operations has completed, try the command again. |
| 13565952 | The LUN clone request failed. |
| 26345672 | An SVM peer relationship was not found with the provided 'copy.source.peer.uuid'. |
| 26345673 | An SVM peer relationship between the SVM provided in 'copy.source.peer.name' and the SVM provided in either 'svm.name' or 'svm.uuid' was not found. |
| 26345674 | The SVM peer relationship provided in 'copy.source.peer.uuid' does not match a peer relationship between the local SVM provided in either 'svm.uuid' or 'svm.name' and the peer SVM provided in 'copy.source.peer.name'. |
| 26345675 | The destination SVM provided via 'svm.name' or 'svm.uuid' does not match the local SVM for the provided SVM peer relationship UUID in 'copy.source.peer.uuid'. |
| 72089755 | NVMe namespace with a block size of 4096 bytes cannot be converted to a LUN. |
| 72089756 | Namespace is currently mapped to subsystem. |
| 72089757 | NVMe namespace in a snapshot cannot be converted to a LUN. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun create default response has a 2xx status code
func (o *LunCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun create default response has a 3xx status code
func (o *LunCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun create default response has a 4xx status code
func (o *LunCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun create default response has a 5xx status code
func (o *LunCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun create default response a status code equal to that given
func (o *LunCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun create default response
func (o *LunCreateDefault) Code() int {
	return o._statusCode
}

func (o *LunCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lun_create default %s", o._statusCode, payload)
}

func (o *LunCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/luns][%d] lun_create default %s", o._statusCode, payload)
}

func (o *LunCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
