// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunDeleteCollectionReader is a Reader for the LunDeleteCollection structure.
type LunDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLunDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunDeleteCollectionOK creates a LunDeleteCollectionOK with default headers values
func NewLunDeleteCollectionOK() *LunDeleteCollectionOK {
	return &LunDeleteCollectionOK{}
}

/*
LunDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LunDeleteCollectionOK struct {
}

// IsSuccess returns true when this lun delete collection o k response has a 2xx status code
func (o *LunDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun delete collection o k response has a 3xx status code
func (o *LunDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun delete collection o k response has a 4xx status code
func (o *LunDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun delete collection o k response has a 5xx status code
func (o *LunDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun delete collection o k response a status code equal to that given
func (o *LunDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun delete collection o k response
func (o *LunDeleteCollectionOK) Code() int {
	return 200
}

func (o *LunDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/luns][%d] lunDeleteCollectionOK", 200)
}

func (o *LunDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/luns][%d] lunDeleteCollectionOK", 200)
}

func (o *LunDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunDeleteCollectionAccepted creates a LunDeleteCollectionAccepted with default headers values
func NewLunDeleteCollectionAccepted() *LunDeleteCollectionAccepted {
	return &LunDeleteCollectionAccepted{}
}

/*
LunDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LunDeleteCollectionAccepted struct {
	Payload *models.LunJobLinkResponse
}

// IsSuccess returns true when this lun delete collection accepted response has a 2xx status code
func (o *LunDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun delete collection accepted response has a 3xx status code
func (o *LunDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun delete collection accepted response has a 4xx status code
func (o *LunDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun delete collection accepted response has a 5xx status code
func (o *LunDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this lun delete collection accepted response a status code equal to that given
func (o *LunDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the lun delete collection accepted response
func (o *LunDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *LunDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns][%d] lunDeleteCollectionAccepted %s", 202, payload)
}

func (o *LunDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns][%d] lunDeleteCollectionAccepted %s", 202, payload)
}

func (o *LunDeleteCollectionAccepted) GetPayload() *models.LunJobLinkResponse {
	return o.Payload
}

func (o *LunDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LunJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunDeleteCollectionDefault creates a LunDeleteCollectionDefault with default headers values
func NewLunDeleteCollectionDefault(code int) *LunDeleteCollectionDefault {
	return &LunDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LunDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254197 | The LUN is mapped and cannot be deleted without specifying the `allow_delete_while_mapped` query parameter. |
| 5374705 | Deleting the LUN is not allowed because it is part of an application. |
| 5374865 | The LUN's aggregate is offline. The aggregate must be online to modify or remove the LUN. |
| 5374866 | The LUN's volume is offline. The volume must be online to modify or remove the LUN. |
| 5374875 | The specified LUN was not found. |
| 5374876 | The specified LUN was not found.<personalities supports=asar2> |
| 5376520 | Deleting a LUN that is the parent of a clone is not allowed. To allow deletion of the parent, split or delete the child clone.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun delete collection default response has a 2xx status code
func (o *LunDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun delete collection default response has a 3xx status code
func (o *LunDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun delete collection default response has a 4xx status code
func (o *LunDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun delete collection default response has a 5xx status code
func (o *LunDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun delete collection default response a status code equal to that given
func (o *LunDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun delete collection default response
func (o *LunDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LunDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns][%d] lun_delete_collection default %s", o._statusCode, payload)
}

func (o *LunDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns][%d] lun_delete_collection default %s", o._statusCode, payload)
}

func (o *LunDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LunDeleteCollectionBody lun delete collection body
swagger:model LunDeleteCollectionBody
*/
type LunDeleteCollectionBody struct {

	// lun response inline records
	LunResponseInlineRecords []*models.Lun `json:"records,omitempty"`
}

// Validate validates this lun delete collection body
func (o *LunDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLunResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunDeleteCollectionBody) validateLunResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LunResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LunResponseInlineRecords); i++ {
		if swag.IsZero(o.LunResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LunResponseInlineRecords[i] != nil {
			if err := o.LunResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this lun delete collection body based on the context it is used
func (o *LunDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLunResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunDeleteCollectionBody) contextValidateLunResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunResponseInlineRecords); i++ {

		if o.LunResponseInlineRecords[i] != nil {
			if err := o.LunResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LunDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
