// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunDeleteReader is a Reader for the LunDelete structure.
type LunDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLunDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunDeleteOK creates a LunDeleteOK with default headers values
func NewLunDeleteOK() *LunDeleteOK {
	return &LunDeleteOK{}
}

/*
LunDeleteOK describes a response with status code 200, with default header values.

OK
*/
type LunDeleteOK struct {
}

// IsSuccess returns true when this lun delete o k response has a 2xx status code
func (o *LunDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun delete o k response has a 3xx status code
func (o *LunDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun delete o k response has a 4xx status code
func (o *LunDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun delete o k response has a 5xx status code
func (o *LunDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun delete o k response a status code equal to that given
func (o *LunDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun delete o k response
func (o *LunDeleteOK) Code() int {
	return 200
}

func (o *LunDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lunDeleteOK", 200)
}

func (o *LunDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lunDeleteOK", 200)
}

func (o *LunDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunDeleteAccepted creates a LunDeleteAccepted with default headers values
func NewLunDeleteAccepted() *LunDeleteAccepted {
	return &LunDeleteAccepted{}
}

/*
LunDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LunDeleteAccepted struct {
	Payload *models.LunJobLinkResponse
}

// IsSuccess returns true when this lun delete accepted response has a 2xx status code
func (o *LunDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun delete accepted response has a 3xx status code
func (o *LunDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun delete accepted response has a 4xx status code
func (o *LunDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun delete accepted response has a 5xx status code
func (o *LunDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this lun delete accepted response a status code equal to that given
func (o *LunDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the lun delete accepted response
func (o *LunDeleteAccepted) Code() int {
	return 202
}

func (o *LunDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lunDeleteAccepted %s", 202, payload)
}

func (o *LunDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lunDeleteAccepted %s", 202, payload)
}

func (o *LunDeleteAccepted) GetPayload() *models.LunJobLinkResponse {
	return o.Payload
}

func (o *LunDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LunJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunDeleteDefault creates a LunDeleteDefault with default headers values
func NewLunDeleteDefault(code int) *LunDeleteDefault {
	return &LunDeleteDefault{
		_statusCode: code,
	}
}

/*
	LunDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254197 | The LUN is mapped and cannot be deleted without specifying the `allow_delete_while_mapped` query parameter. |
| 5374705 | Deleting the LUN is not allowed because it is part of an application. |
| 5374865 | The LUN's aggregate is offline. The aggregate must be online to modify or remove the LUN. |
| 5374866 | The LUN's volume is offline. The volume must be online to modify or remove the LUN. |
| 5374875 | The specified LUN was not found. |
| 5374876 | The specified LUN was not found.<personalities supports=asar2> |
| 5376520 | Deleting a LUN that is the parent of a clone is not allowed. To allow deletion of the parent, split or delete the child clone.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun delete default response has a 2xx status code
func (o *LunDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun delete default response has a 3xx status code
func (o *LunDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun delete default response has a 4xx status code
func (o *LunDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun delete default response has a 5xx status code
func (o *LunDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun delete default response a status code equal to that given
func (o *LunDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun delete default response
func (o *LunDeleteDefault) Code() int {
	return o._statusCode
}

func (o *LunDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lun_delete default %s", o._statusCode, payload)
}

func (o *LunDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{uuid}][%d] lun_delete default %s", o._statusCode, payload)
}

func (o *LunDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
