// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunFormDataDeleteParams creates a new LunFormDataDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunFormDataDeleteParams() *LunFormDataDeleteParams {
	return &LunFormDataDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunFormDataDeleteParamsWithTimeout creates a new LunFormDataDeleteParams object
// with the ability to set a timeout on a request.
func NewLunFormDataDeleteParamsWithTimeout(timeout time.Duration) *LunFormDataDeleteParams {
	return &LunFormDataDeleteParams{
		timeout: timeout,
	}
}

// NewLunFormDataDeleteParamsWithContext creates a new LunFormDataDeleteParams object
// with the ability to set a context for a request.
func NewLunFormDataDeleteParamsWithContext(ctx context.Context) *LunFormDataDeleteParams {
	return &LunFormDataDeleteParams{
		Context: ctx,
	}
}

// NewLunFormDataDeleteParamsWithHTTPClient creates a new LunFormDataDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunFormDataDeleteParamsWithHTTPClient(client *http.Client) *LunFormDataDeleteParams {
	return &LunFormDataDeleteParams{
		HTTPClient: client,
	}
}

/*
LunFormDataDeleteParams contains all the parameters to send to the API endpoint

	for the lun form data delete operation.

	Typically these are written to a http.Request.
*/
type LunFormDataDeleteParams struct {

	/* AllowDeleteWhileMapped.

	     Allows deletion of a mapped LUN.<br/>
	A mapped LUN might be in use. Deleting a mapped LUN also deletes the LUN map and makes the data no longer available. This might cause a disruption in the availability of data.<br/>
	**This parameter should be used with caution.**

	*/
	AllowDeleteWhileMapped *bool

	/* BypassRecoveryQueue.

	     Bypasses the volume recovery queue. This makes the volume hosting the LUN non-recoverable.<br/>
	**This parameter should be used with caution.**

	*/
	BypassRecoveryQueue *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   The unique identifier of the LUN to retrieve.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun form data delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunFormDataDeleteParams) WithDefaults() *LunFormDataDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun form data delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunFormDataDeleteParams) SetDefaults() {
	var (
		allowDeleteWhileMappedDefault = bool(false)

		bypassRecoveryQueueDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := LunFormDataDeleteParams{
		AllowDeleteWhileMapped: &allowDeleteWhileMappedDefault,
		BypassRecoveryQueue:    &bypassRecoveryQueueDefault,
		ReturnTimeout:          &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun form data delete params
func (o *LunFormDataDeleteParams) WithTimeout(timeout time.Duration) *LunFormDataDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun form data delete params
func (o *LunFormDataDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun form data delete params
func (o *LunFormDataDeleteParams) WithContext(ctx context.Context) *LunFormDataDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun form data delete params
func (o *LunFormDataDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun form data delete params
func (o *LunFormDataDeleteParams) WithHTTPClient(client *http.Client) *LunFormDataDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun form data delete params
func (o *LunFormDataDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the lun form data delete params
func (o *LunFormDataDeleteParams) WithAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) *LunFormDataDeleteParams {
	o.SetAllowDeleteWhileMapped(allowDeleteWhileMapped)
	return o
}

// SetAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the lun form data delete params
func (o *LunFormDataDeleteParams) SetAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) {
	o.AllowDeleteWhileMapped = allowDeleteWhileMapped
}

// WithBypassRecoveryQueue adds the bypassRecoveryQueue to the lun form data delete params
func (o *LunFormDataDeleteParams) WithBypassRecoveryQueue(bypassRecoveryQueue *bool) *LunFormDataDeleteParams {
	o.SetBypassRecoveryQueue(bypassRecoveryQueue)
	return o
}

// SetBypassRecoveryQueue adds the bypassRecoveryQueue to the lun form data delete params
func (o *LunFormDataDeleteParams) SetBypassRecoveryQueue(bypassRecoveryQueue *bool) {
	o.BypassRecoveryQueue = bypassRecoveryQueue
}

// WithReturnTimeout adds the returnTimeout to the lun form data delete params
func (o *LunFormDataDeleteParams) WithReturnTimeout(returnTimeout *int64) *LunFormDataDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun form data delete params
func (o *LunFormDataDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the lun form data delete params
func (o *LunFormDataDeleteParams) WithUUID(uuid string) *LunFormDataDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the lun form data delete params
func (o *LunFormDataDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LunFormDataDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AllowDeleteWhileMapped != nil {

		// query param allow_delete_while_mapped
		var qrAllowDeleteWhileMapped bool

		if o.AllowDeleteWhileMapped != nil {
			qrAllowDeleteWhileMapped = *o.AllowDeleteWhileMapped
		}
		qAllowDeleteWhileMapped := swag.FormatBool(qrAllowDeleteWhileMapped)
		if qAllowDeleteWhileMapped != "" {

			if err := r.SetQueryParam("allow_delete_while_mapped", qAllowDeleteWhileMapped); err != nil {
				return err
			}
		}
	}

	if o.BypassRecoveryQueue != nil {

		// query param bypass_recovery_queue
		var qrBypassRecoveryQueue bool

		if o.BypassRecoveryQueue != nil {
			qrBypassRecoveryQueue = *o.BypassRecoveryQueue
		}
		qBypassRecoveryQueue := swag.FormatBool(qrBypassRecoveryQueue)
		if qBypassRecoveryQueue != "" {

			if err := r.SetQueryParam("bypass_recovery_queue", qBypassRecoveryQueue); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
