// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunFormDataGetReader is a Reader for the LunFormDataGet structure.
type LunFormDataGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunFormDataGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunFormDataGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunFormDataGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunFormDataGetOK creates a LunFormDataGetOK with default headers values
func NewLunFormDataGetOK() *LunFormDataGetOK {
	return &LunFormDataGetOK{}
}

/*
LunFormDataGetOK describes a response with status code 200, with default header values.

OK
*/
type LunFormDataGetOK struct {
	Payload *models.Lun
}

// IsSuccess returns true when this lun form data get o k response has a 2xx status code
func (o *LunFormDataGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun form data get o k response has a 3xx status code
func (o *LunFormDataGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun form data get o k response has a 4xx status code
func (o *LunFormDataGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun form data get o k response has a 5xx status code
func (o *LunFormDataGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun form data get o k response a status code equal to that given
func (o *LunFormDataGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun form data get o k response
func (o *LunFormDataGetOK) Code() int {
	return 200
}

func (o *LunFormDataGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/luns/{uuid}][%d] lunFormDataGetOK %s", 200, payload)
}

func (o *LunFormDataGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/luns/{uuid}][%d] lunFormDataGetOK %s", 200, payload)
}

func (o *LunFormDataGetOK) GetPayload() *models.Lun {
	return o.Payload
}

func (o *LunFormDataGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Lun)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunFormDataGetDefault creates a LunFormDataGetDefault with default headers values
func NewLunFormDataGetDefault(code int) *LunFormDataGetDefault {
	return &LunFormDataGetDefault{
		_statusCode: code,
	}
}

/*
	LunFormDataGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374875 | The specified LUN was not found. |
| 5374876 | The specified LUN was not found. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunFormDataGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun form data get default response has a 2xx status code
func (o *LunFormDataGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun form data get default response has a 3xx status code
func (o *LunFormDataGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun form data get default response has a 4xx status code
func (o *LunFormDataGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun form data get default response has a 5xx status code
func (o *LunFormDataGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun form data get default response a status code equal to that given
func (o *LunFormDataGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun form data get default response
func (o *LunFormDataGetDefault) Code() int {
	return o._statusCode
}

func (o *LunFormDataGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/luns/{uuid}][%d] lun_form_data_get default %s", o._statusCode, payload)
}

func (o *LunFormDataGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/luns/{uuid}][%d] lun_form_data_get default %s", o._statusCode, payload)
}

func (o *LunFormDataGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunFormDataGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
