// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunFormDataModifyParams creates a new LunFormDataModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunFormDataModifyParams() *LunFormDataModifyParams {
	return &LunFormDataModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunFormDataModifyParamsWithTimeout creates a new LunFormDataModifyParams object
// with the ability to set a timeout on a request.
func NewLunFormDataModifyParamsWithTimeout(timeout time.Duration) *LunFormDataModifyParams {
	return &LunFormDataModifyParams{
		timeout: timeout,
	}
}

// NewLunFormDataModifyParamsWithContext creates a new LunFormDataModifyParams object
// with the ability to set a context for a request.
func NewLunFormDataModifyParamsWithContext(ctx context.Context) *LunFormDataModifyParams {
	return &LunFormDataModifyParams{
		Context: ctx,
	}
}

// NewLunFormDataModifyParamsWithHTTPClient creates a new LunFormDataModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunFormDataModifyParamsWithHTTPClient(client *http.Client) *LunFormDataModifyParams {
	return &LunFormDataModifyParams{
		HTTPClient: client,
	}
}

/*
LunFormDataModifyParams contains all the parameters to send to the API endpoint

	for the lun form data modify operation.

	Typically these are written to a http.Request.
*/
type LunFormDataModifyParams struct {

	/* Data.

	     Data for a LUN data write. When used, the request header must include `Content-Type: multipart/form-data` and query parameter `data.offset` is required and used to specify the location within the LUN at which to write the data; no other query parameters are allowed. Writes are limited to one megabyte (1MB) per request.<br/>
	Either `info` or `data` must be supplied.

	*/
	Data *string

	/* DataOffset.

	     The offset, in bytes, at which to begin writing LUN data.<br/>
	LUN data write requests are distinguished by the header entry `Content-Type: multipart/form-data`. When this header entry is provided, query parameter `data.offset` is required and used to specify the location within the LUN at which to write the data; no other query parameters are allowed. The request body must be `multipart/form-data` content with exactly one form entry containing the data to write. The content type entry of the form data is ignored and always treated as `application/octet-stream`. Writes are limited to one megabyte (1MB) per request.


	     Format: int64
	*/
	DataOffset *int64

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   The unique identifier of the LUN to retrieve.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun form data modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunFormDataModifyParams) WithDefaults() *LunFormDataModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun form data modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunFormDataModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := LunFormDataModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun form data modify params
func (o *LunFormDataModifyParams) WithTimeout(timeout time.Duration) *LunFormDataModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun form data modify params
func (o *LunFormDataModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun form data modify params
func (o *LunFormDataModifyParams) WithContext(ctx context.Context) *LunFormDataModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun form data modify params
func (o *LunFormDataModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun form data modify params
func (o *LunFormDataModifyParams) WithHTTPClient(client *http.Client) *LunFormDataModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun form data modify params
func (o *LunFormDataModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithData adds the data to the lun form data modify params
func (o *LunFormDataModifyParams) WithData(data *string) *LunFormDataModifyParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the lun form data modify params
func (o *LunFormDataModifyParams) SetData(data *string) {
	o.Data = data
}

// WithDataOffset adds the dataOffset to the lun form data modify params
func (o *LunFormDataModifyParams) WithDataOffset(dataOffset *int64) *LunFormDataModifyParams {
	o.SetDataOffset(dataOffset)
	return o
}

// SetDataOffset adds the dataOffset to the lun form data modify params
func (o *LunFormDataModifyParams) SetDataOffset(dataOffset *int64) {
	o.DataOffset = dataOffset
}

// WithReturnTimeout adds the returnTimeout to the lun form data modify params
func (o *LunFormDataModifyParams) WithReturnTimeout(returnTimeout *int64) *LunFormDataModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun form data modify params
func (o *LunFormDataModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the lun form data modify params
func (o *LunFormDataModifyParams) WithUUID(uuid string) *LunFormDataModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the lun form data modify params
func (o *LunFormDataModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LunFormDataModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Data != nil {

		// form param data
		var frData string
		if o.Data != nil {
			frData = *o.Data
		}
		fData := frData
		if fData != "" {
			if err := r.SetFormParam("data", fData); err != nil {
				return err
			}
		}
	}

	if o.DataOffset != nil {

		// query param data.offset
		var qrDataOffset int64

		if o.DataOffset != nil {
			qrDataOffset = *o.DataOffset
		}
		qDataOffset := swag.FormatInt64(qrDataOffset)
		if qDataOffset != "" {

			if err := r.SetQueryParam("data.offset", qDataOffset); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
