// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunFormDataModifyReader is a Reader for the LunFormDataModify structure.
type LunFormDataModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunFormDataModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunFormDataModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLunFormDataModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunFormDataModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunFormDataModifyOK creates a LunFormDataModifyOK with default headers values
func NewLunFormDataModifyOK() *LunFormDataModifyOK {
	return &LunFormDataModifyOK{}
}

/*
LunFormDataModifyOK describes a response with status code 200, with default header values.

OK
*/
type LunFormDataModifyOK struct {
}

// IsSuccess returns true when this lun form data modify o k response has a 2xx status code
func (o *LunFormDataModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun form data modify o k response has a 3xx status code
func (o *LunFormDataModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun form data modify o k response has a 4xx status code
func (o *LunFormDataModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun form data modify o k response has a 5xx status code
func (o *LunFormDataModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun form data modify o k response a status code equal to that given
func (o *LunFormDataModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun form data modify o k response
func (o *LunFormDataModifyOK) Code() int {
	return 200
}

func (o *LunFormDataModifyOK) Error() string {
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lunFormDataModifyOK", 200)
}

func (o *LunFormDataModifyOK) String() string {
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lunFormDataModifyOK", 200)
}

func (o *LunFormDataModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunFormDataModifyAccepted creates a LunFormDataModifyAccepted with default headers values
func NewLunFormDataModifyAccepted() *LunFormDataModifyAccepted {
	return &LunFormDataModifyAccepted{}
}

/*
LunFormDataModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LunFormDataModifyAccepted struct {
	Payload *models.LunJobLinkResponse
}

// IsSuccess returns true when this lun form data modify accepted response has a 2xx status code
func (o *LunFormDataModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun form data modify accepted response has a 3xx status code
func (o *LunFormDataModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun form data modify accepted response has a 4xx status code
func (o *LunFormDataModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun form data modify accepted response has a 5xx status code
func (o *LunFormDataModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this lun form data modify accepted response a status code equal to that given
func (o *LunFormDataModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the lun form data modify accepted response
func (o *LunFormDataModifyAccepted) Code() int {
	return 202
}

func (o *LunFormDataModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lunFormDataModifyAccepted %s", 202, payload)
}

func (o *LunFormDataModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lunFormDataModifyAccepted %s", 202, payload)
}

func (o *LunFormDataModifyAccepted) GetPayload() *models.LunJobLinkResponse {
	return o.Payload
}

func (o *LunFormDataModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LunJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunFormDataModifyDefault creates a LunFormDataModifyDefault with default headers values
func NewLunFormDataModifyDefault(code int) *LunFormDataModifyDefault {
	return &LunFormDataModifyDefault{
		_statusCode: code,
	}
}

/*
	LunFormDataModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917927 | The specified volume was not found. |
| 918235 | A volume with the specified UUID was not found. |
| 918236 | The specified `location.volume.uuid` and `location.volume.name` do not refer to the same volume. |
| 1254196 | A LUN already exists at the specified path. |
| 1254226 | Cannot patch a LUN's size to its current size. |
| 5242927 | The specified qtree was not found. |
| 5242950 | The specified `location.qtree.id` and `location.qtree.name` do not refer to the same qtree. |
| 5374124 | The specified LUN size is too small. |
| 5374125 | The specified LUN size is too large. |
| 5374127 | The specified LUN name is invalid. |
| 5374130 | An invalid size value was provided. |
| 5374241 | A size value with invalid units was provided. |
| 5374480 | Modifying the LUN is not allowed because it is in a foreign LUN import relationship. |
| 5374858 | The volume specified by `name` is not the same as that specified by `location.volume`. |
| 5374860 | The qtree specified by `name` is not the same as that specified by `location.qtree`. |
| 5374861 | The LUN base name specified by `name` is not the same as that specified by `location.logical_unit`. |
| 5374864 | An error occurred after successfully overwriting data for the LUN as a clone. Some properties were not modified. |
| 5374865 | The LUN's aggregate is offline. The aggregate must be online to modify or remove the LUN. |
| 5374866 | The LUN's volume is offline. The volume must be online to modify or remove the LUN. |
| 5374874 | The specified `clone.source.uuid` and `clone.source.name` do not refer to the same LUN. |
| 5374875 | The specified LUN was not found. This can apply to `clone.source` or the target LUN. The `target` property of the error object identifies the property. |
| 5374876 | The specified LUN was not found. This can apply to `clone.source` or the target LUN. The `target` property of the error object identifies the property. |
| 5374885 | An error occurred after successfully modifying some of the properties of the LUN. Some properties were not modified. |
| 5374889 | An invalid value was specified for `movement.progress.state`. Active LUN movement operations can be PATCHed to only _paused_ or _replicating_. |
| 5374892 | An attempt was made to reduce the size of a LUN. |
| 5374904 | The destination volume is not online. |
| 5375059 | An unsuitable QoS policy was specified. |
| 5376461 | The specified LUN name is invalid. |
| 5376462 | The specified LUN name is too long. |
| 5376463 | The snapshot portion of the specified LUN name is too long. |
| 5376466 | An attempt was made to rename a LUN to a snapshot name. |
| 5376467 | An attempt was made to rename a primary LUN to a secondary name. |
| 5376468 | An attempt was made to rename a LUN to a reserved name. |
| 5376470 | The property cannot be set during the LUN modify operation on this platform. |
| 7018877 | Maximum combined total (50) of file and LUN copy and move operations reached. When one or more of the operations has completed, try the command again. |
| 7018919 | A copy or move job exists with the same destination LUN. |
| 8454243 | The specified QoS policy does not exist while modifying a LUN. |
| 13565952 | The LUN clone request failed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunFormDataModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun form data modify default response has a 2xx status code
func (o *LunFormDataModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun form data modify default response has a 3xx status code
func (o *LunFormDataModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun form data modify default response has a 4xx status code
func (o *LunFormDataModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun form data modify default response has a 5xx status code
func (o *LunFormDataModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun form data modify default response a status code equal to that given
func (o *LunFormDataModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun form data modify default response
func (o *LunFormDataModifyDefault) Code() int {
	return o._statusCode
}

func (o *LunFormDataModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lun_form_data_modify default %s", o._statusCode, payload)
}

func (o *LunFormDataModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH //storage/luns/{uuid}][%d] lun_form_data_modify default %s", o._statusCode, payload)
}

func (o *LunFormDataModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunFormDataModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
