// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunGetParams creates a new LunGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunGetParams() *LunGetParams {
	return &LunGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunGetParamsWithTimeout creates a new LunGetParams object
// with the ability to set a timeout on a request.
func NewLunGetParamsWithTimeout(timeout time.Duration) *LunGetParams {
	return &LunGetParams{
		timeout: timeout,
	}
}

// NewLunGetParamsWithContext creates a new LunGetParams object
// with the ability to set a context for a request.
func NewLunGetParamsWithContext(ctx context.Context) *LunGetParams {
	return &LunGetParams{
		Context: ctx,
	}
}

// NewLunGetParamsWithHTTPClient creates a new LunGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunGetParamsWithHTTPClient(client *http.Client) *LunGetParams {
	return &LunGetParams{
		HTTPClient: client,
	}
}

/*
LunGetParams contains all the parameters to send to the API endpoint

	for the lun get operation.

	Typically these are written to a http.Request.
*/
type LunGetParams struct {

	/* DataOffset.

	     The offset, in bytes, at which to begin reading LUN data.<br/>
	LUN data read requests are distinguished by the header entry `Accept: multipart/form-data`. When this header entry is provided, query parameters `data.offset` and `data.size` are required and used to specify the portion of the LUN's data to read; no other query parameters are allowed. Reads are limited to one megabyte (1MB) per request. Data is returned as `multipart/form-data` content with exactly one form entry containing the data. The form entry has content type `application/octet-stream`.


	     Format: int64
	*/
	DataOffset *int64

	/* DataSize.

	     The size, in bytes, of LUN data to read.<br/>
	LUN data read requests are distinguished by the header entry `Accept: multipart/form-data`. When this header entry is provided, query parameters `data.offset` and `data.size` are required and used to specify the portion of the LUN's data to read; no other query parameters are allowed. Reads are limited to one megabyte (1MB) per request. Data is returned as `multipart/form-data` content with exactly one form entry containing the data. The form entry has content type `application/octet-stream`.


	     Format: int64
	*/
	DataSize *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   The unique identifier of the LUN to retrieve.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunGetParams) WithDefaults() *LunGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the lun get params
func (o *LunGetParams) WithTimeout(timeout time.Duration) *LunGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun get params
func (o *LunGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun get params
func (o *LunGetParams) WithContext(ctx context.Context) *LunGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun get params
func (o *LunGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun get params
func (o *LunGetParams) WithHTTPClient(client *http.Client) *LunGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun get params
func (o *LunGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataOffset adds the dataOffset to the lun get params
func (o *LunGetParams) WithDataOffset(dataOffset *int64) *LunGetParams {
	o.SetDataOffset(dataOffset)
	return o
}

// SetDataOffset adds the dataOffset to the lun get params
func (o *LunGetParams) SetDataOffset(dataOffset *int64) {
	o.DataOffset = dataOffset
}

// WithDataSize adds the dataSize to the lun get params
func (o *LunGetParams) WithDataSize(dataSize *int64) *LunGetParams {
	o.SetDataSize(dataSize)
	return o
}

// SetDataSize adds the dataSize to the lun get params
func (o *LunGetParams) SetDataSize(dataSize *int64) {
	o.DataSize = dataSize
}

// WithFields adds the fields to the lun get params
func (o *LunGetParams) WithFields(fields []string) *LunGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the lun get params
func (o *LunGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the lun get params
func (o *LunGetParams) WithUUID(uuid string) *LunGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the lun get params
func (o *LunGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LunGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DataOffset != nil {

		// query param data.offset
		var qrDataOffset int64

		if o.DataOffset != nil {
			qrDataOffset = *o.DataOffset
		}
		qDataOffset := swag.FormatInt64(qrDataOffset)
		if qDataOffset != "" {

			if err := r.SetQueryParam("data.offset", qDataOffset); err != nil {
				return err
			}
		}
	}

	if o.DataSize != nil {

		// query param data.size
		var qrDataSize int64

		if o.DataSize != nil {
			qrDataSize = *o.DataSize
		}
		qDataSize := swag.FormatInt64(qrDataSize)
		if qDataSize != "" {

			if err := r.SetQueryParam("data.size", qDataSize); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLunGet binds the parameter fields
func (o *LunGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
