// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunMapCollectionGetReader is a Reader for the LunMapCollectionGet structure.
type LunMapCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunMapCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunMapCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunMapCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunMapCollectionGetOK creates a LunMapCollectionGetOK with default headers values
func NewLunMapCollectionGetOK() *LunMapCollectionGetOK {
	return &LunMapCollectionGetOK{}
}

/*
LunMapCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type LunMapCollectionGetOK struct {
	Payload *models.LunMapResponse
}

// IsSuccess returns true when this lun map collection get o k response has a 2xx status code
func (o *LunMapCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun map collection get o k response has a 3xx status code
func (o *LunMapCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun map collection get o k response has a 4xx status code
func (o *LunMapCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun map collection get o k response has a 5xx status code
func (o *LunMapCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun map collection get o k response a status code equal to that given
func (o *LunMapCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun map collection get o k response
func (o *LunMapCollectionGetOK) Code() int {
	return 200
}

func (o *LunMapCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/lun-maps][%d] lunMapCollectionGetOK %s", 200, payload)
}

func (o *LunMapCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/lun-maps][%d] lunMapCollectionGetOK %s", 200, payload)
}

func (o *LunMapCollectionGetOK) GetPayload() *models.LunMapResponse {
	return o.Payload
}

func (o *LunMapCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LunMapResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunMapCollectionGetDefault creates a LunMapCollectionGetDefault with default headers values
func NewLunMapCollectionGetDefault(code int) *LunMapCollectionGetDefault {
	return &LunMapCollectionGetDefault{
		_statusCode: code,
	}
}

/*
LunMapCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type LunMapCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun map collection get default response has a 2xx status code
func (o *LunMapCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun map collection get default response has a 3xx status code
func (o *LunMapCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun map collection get default response has a 4xx status code
func (o *LunMapCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun map collection get default response has a 5xx status code
func (o *LunMapCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun map collection get default response a status code equal to that given
func (o *LunMapCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun map collection get default response
func (o *LunMapCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *LunMapCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/lun-maps][%d] lun_map_collection_get default %s", o._statusCode, payload)
}

func (o *LunMapCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/lun-maps][%d] lun_map_collection_get default %s", o._statusCode, payload)
}

func (o *LunMapCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunMapCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
