// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunMapCreateReader is a Reader for the LunMapCreate structure.
type LunMapCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunMapCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewLunMapCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunMapCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunMapCreateCreated creates a LunMapCreateCreated with default headers values
func NewLunMapCreateCreated() *LunMapCreateCreated {
	return &LunMapCreateCreated{}
}

/*
LunMapCreateCreated describes a response with status code 201, with default header values.

Created
*/
type LunMapCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.LunMapResponse
}

// IsSuccess returns true when this lun map create created response has a 2xx status code
func (o *LunMapCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun map create created response has a 3xx status code
func (o *LunMapCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun map create created response has a 4xx status code
func (o *LunMapCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun map create created response has a 5xx status code
func (o *LunMapCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this lun map create created response a status code equal to that given
func (o *LunMapCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the lun map create created response
func (o *LunMapCreateCreated) Code() int {
	return 201
}

func (o *LunMapCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/lun-maps][%d] lunMapCreateCreated %s", 201, payload)
}

func (o *LunMapCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/lun-maps][%d] lunMapCreateCreated %s", 201, payload)
}

func (o *LunMapCreateCreated) GetPayload() *models.LunMapResponse {
	return o.Payload
}

func (o *LunMapCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.LunMapResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunMapCreateDefault creates a LunMapCreateDefault with default headers values
func NewLunMapCreateDefault(code int) *LunMapCreateDefault {
	return &LunMapCreateDefault{
		_statusCode: code,
	}
}

/*
	LunMapCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254201 | The specified LUN does not exist. |
| 1254207 | The LUN is already mapped to the same initiator group. |
| 2621462 | The specified SVM does not exist or is not accessible to the caller. |
| 2621706 | Both the SVM UUID and SVM name were supplied, but don't refer to the same SVM. |
| 2621707 | No SVM was specified. Either `svm.name` or `svm.uuid` must be supplied. |
| 5374053 | The LUN is the destination of an ongoing restore operation and is inaccessible for I/O and management. Wait for the restore to complete and try the command again. |
| 5374127 | The specified LUN name is invalid. |
| 5374238 | The operation is not allowed on a LUN in a snapshot. |
| 5374316 | A LUN move operation is in progress on the source LUN. |
| 5374329 | A LUN of class `vvol` cannot be mapped. |
| 5374573 | A node has no interface configured with the iSCSI or Fibre Channel protocols for the specified SVM. |
| 5374574 | Multiple nodes have no interface configured with the iSCSI or Fibre Channel protocols for the specified SVM. |
| 5374581 | A node has no interface configured with the iSCSI protocol for the specified SVM. |
| 5374582 | Multiple nodes have no interface configured with the iSCSI protocol for the specified SVM. |
| 5374583 | A node has no interface configured with the Fibre Channel protocol for the specified SVM. |
| 5374584 | Multiple nodes have no interface configured with the Fibre Channel protocol for the specified SVM. |
| 5374652 | An error was reported by the peer cluster while creating a replicated LUN map. The specific error will be included as a nested error. |
| 5374901 | Either `lun.uuid` or `lun.name` must be provided to create a LUN map. |
| 5374902 | Either `igroup.uuid` or `igroup.name` must be provided to create a LUN map. |
| 5374920 | The cluster node specified in additional_reporting_node does not exist. |
| 5374921 | The cluster node name and UUID specified in additional_reporting_node do not refer to the same cluster node. |
| 5376356 | The LUN is part of a SnapMirror active sync relationship that has a different SVM peering relationship than the igroup. |
| 5376461 | The specified LUN name is invalid. |
| 5376462 | The specified LUN name is too long. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunMapCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun map create default response has a 2xx status code
func (o *LunMapCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun map create default response has a 3xx status code
func (o *LunMapCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun map create default response has a 4xx status code
func (o *LunMapCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun map create default response has a 5xx status code
func (o *LunMapCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun map create default response a status code equal to that given
func (o *LunMapCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun map create default response
func (o *LunMapCreateDefault) Code() int {
	return o._statusCode
}

func (o *LunMapCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/lun-maps][%d] lun_map_create default %s", o._statusCode, payload)
}

func (o *LunMapCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/lun-maps][%d] lun_map_create default %s", o._statusCode, payload)
}

func (o *LunMapCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunMapCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
