// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunMapDeleteCollectionParams creates a new LunMapDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunMapDeleteCollectionParams() *LunMapDeleteCollectionParams {
	return &LunMapDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunMapDeleteCollectionParamsWithTimeout creates a new LunMapDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewLunMapDeleteCollectionParamsWithTimeout(timeout time.Duration) *LunMapDeleteCollectionParams {
	return &LunMapDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewLunMapDeleteCollectionParamsWithContext creates a new LunMapDeleteCollectionParams object
// with the ability to set a context for a request.
func NewLunMapDeleteCollectionParamsWithContext(ctx context.Context) *LunMapDeleteCollectionParams {
	return &LunMapDeleteCollectionParams{
		Context: ctx,
	}
}

// NewLunMapDeleteCollectionParamsWithHTTPClient creates a new LunMapDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunMapDeleteCollectionParamsWithHTTPClient(client *http.Client) *LunMapDeleteCollectionParams {
	return &LunMapDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
LunMapDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the lun map delete collection operation.

	Typically these are written to a http.Request.
*/
type LunMapDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* IgroupInitiators.

	   Filter by igroup.initiators
	*/
	IgroupInitiators *string

	/* IgroupName.

	   Filter by igroup.name
	*/
	IgroupName *string

	/* IgroupOsType.

	   Filter by igroup.os_type
	*/
	IgroupOsType *string

	/* IgroupProtocol.

	   Filter by igroup.protocol
	*/
	IgroupProtocol *string

	/* IgroupReplicated.

	   Filter by igroup.replicated
	*/
	IgroupReplicated *bool

	/* IgroupUUID.

	   Filter by igroup.uuid
	*/
	IgroupUUID *string

	/* Info.

	   Info specification
	*/
	Info LunMapDeleteCollectionBody

	/* LogicalUnitNumber.

	   Filter by logical_unit_number
	*/
	LogicalUnitNumber *int64

	/* LunName.

	   Filter by lun.name
	*/
	LunName *string

	/* LunNodeName.

	   Filter by lun.node.name
	*/
	LunNodeName *string

	/* LunNodeUUID.

	   Filter by lun.node.uuid
	*/
	LunNodeUUID *string

	/* LunSmbcReplicated.

	   Filter by lun.smbc.replicated
	*/
	LunSmbcReplicated *bool

	/* LunUUID.

	   Filter by lun.uuid
	*/
	LunUUID *string

	/* ReportingNodesName.

	   Filter by reporting_nodes.name
	*/
	ReportingNodesName *string

	/* ReportingNodesUUID.

	   Filter by reporting_nodes.uuid
	*/
	ReportingNodesUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun map delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapDeleteCollectionParams) WithDefaults() *LunMapDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun map delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := LunMapDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithTimeout(timeout time.Duration) *LunMapDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithContext(ctx context.Context) *LunMapDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithHTTPClient(client *http.Client) *LunMapDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *LunMapDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIgroupInitiators adds the igroupInitiators to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupInitiators(igroupInitiators *string) *LunMapDeleteCollectionParams {
	o.SetIgroupInitiators(igroupInitiators)
	return o
}

// SetIgroupInitiators adds the igroupInitiators to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupInitiators(igroupInitiators *string) {
	o.IgroupInitiators = igroupInitiators
}

// WithIgroupName adds the igroupName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupName(igroupName *string) *LunMapDeleteCollectionParams {
	o.SetIgroupName(igroupName)
	return o
}

// SetIgroupName adds the igroupName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupName(igroupName *string) {
	o.IgroupName = igroupName
}

// WithIgroupOsType adds the igroupOsType to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupOsType(igroupOsType *string) *LunMapDeleteCollectionParams {
	o.SetIgroupOsType(igroupOsType)
	return o
}

// SetIgroupOsType adds the igroupOsType to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupOsType(igroupOsType *string) {
	o.IgroupOsType = igroupOsType
}

// WithIgroupProtocol adds the igroupProtocol to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupProtocol(igroupProtocol *string) *LunMapDeleteCollectionParams {
	o.SetIgroupProtocol(igroupProtocol)
	return o
}

// SetIgroupProtocol adds the igroupProtocol to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupProtocol(igroupProtocol *string) {
	o.IgroupProtocol = igroupProtocol
}

// WithIgroupReplicated adds the igroupReplicated to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupReplicated(igroupReplicated *bool) *LunMapDeleteCollectionParams {
	o.SetIgroupReplicated(igroupReplicated)
	return o
}

// SetIgroupReplicated adds the igroupReplicated to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupReplicated(igroupReplicated *bool) {
	o.IgroupReplicated = igroupReplicated
}

// WithIgroupUUID adds the igroupUUID to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithIgroupUUID(igroupUUID *string) *LunMapDeleteCollectionParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetIgroupUUID(igroupUUID *string) {
	o.IgroupUUID = igroupUUID
}

// WithInfo adds the info to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithInfo(info LunMapDeleteCollectionBody) *LunMapDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetInfo(info LunMapDeleteCollectionBody) {
	o.Info = info
}

// WithLogicalUnitNumber adds the logicalUnitNumber to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLogicalUnitNumber(logicalUnitNumber *int64) *LunMapDeleteCollectionParams {
	o.SetLogicalUnitNumber(logicalUnitNumber)
	return o
}

// SetLogicalUnitNumber adds the logicalUnitNumber to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLogicalUnitNumber(logicalUnitNumber *int64) {
	o.LogicalUnitNumber = logicalUnitNumber
}

// WithLunName adds the lunName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLunName(lunName *string) *LunMapDeleteCollectionParams {
	o.SetLunName(lunName)
	return o
}

// SetLunName adds the lunName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLunName(lunName *string) {
	o.LunName = lunName
}

// WithLunNodeName adds the lunNodeName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLunNodeName(lunNodeName *string) *LunMapDeleteCollectionParams {
	o.SetLunNodeName(lunNodeName)
	return o
}

// SetLunNodeName adds the lunNodeName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLunNodeName(lunNodeName *string) {
	o.LunNodeName = lunNodeName
}

// WithLunNodeUUID adds the lunNodeUUID to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLunNodeUUID(lunNodeUUID *string) *LunMapDeleteCollectionParams {
	o.SetLunNodeUUID(lunNodeUUID)
	return o
}

// SetLunNodeUUID adds the lunNodeUuid to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLunNodeUUID(lunNodeUUID *string) {
	o.LunNodeUUID = lunNodeUUID
}

// WithLunSmbcReplicated adds the lunSmbcReplicated to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLunSmbcReplicated(lunSmbcReplicated *bool) *LunMapDeleteCollectionParams {
	o.SetLunSmbcReplicated(lunSmbcReplicated)
	return o
}

// SetLunSmbcReplicated adds the lunSmbcReplicated to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLunSmbcReplicated(lunSmbcReplicated *bool) {
	o.LunSmbcReplicated = lunSmbcReplicated
}

// WithLunUUID adds the lunUUID to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithLunUUID(lunUUID *string) *LunMapDeleteCollectionParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetLunUUID(lunUUID *string) {
	o.LunUUID = lunUUID
}

// WithReportingNodesName adds the reportingNodesName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithReportingNodesName(reportingNodesName *string) *LunMapDeleteCollectionParams {
	o.SetReportingNodesName(reportingNodesName)
	return o
}

// SetReportingNodesName adds the reportingNodesName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetReportingNodesName(reportingNodesName *string) {
	o.ReportingNodesName = reportingNodesName
}

// WithReportingNodesUUID adds the reportingNodesUUID to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithReportingNodesUUID(reportingNodesUUID *string) *LunMapDeleteCollectionParams {
	o.SetReportingNodesUUID(reportingNodesUUID)
	return o
}

// SetReportingNodesUUID adds the reportingNodesUuid to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetReportingNodesUUID(reportingNodesUUID *string) {
	o.ReportingNodesUUID = reportingNodesUUID
}

// WithReturnRecords adds the returnRecords to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *LunMapDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *LunMapDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *LunMapDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithSvmName(svmName *string) *LunMapDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) WithSvmUUID(svmUUID *string) *LunMapDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the lun map delete collection params
func (o *LunMapDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LunMapDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.IgroupInitiators != nil {

		// query param igroup.initiators
		var qrIgroupInitiators string

		if o.IgroupInitiators != nil {
			qrIgroupInitiators = *o.IgroupInitiators
		}
		qIgroupInitiators := qrIgroupInitiators
		if qIgroupInitiators != "" {

			if err := r.SetQueryParam("igroup.initiators", qIgroupInitiators); err != nil {
				return err
			}
		}
	}

	if o.IgroupName != nil {

		// query param igroup.name
		var qrIgroupName string

		if o.IgroupName != nil {
			qrIgroupName = *o.IgroupName
		}
		qIgroupName := qrIgroupName
		if qIgroupName != "" {

			if err := r.SetQueryParam("igroup.name", qIgroupName); err != nil {
				return err
			}
		}
	}

	if o.IgroupOsType != nil {

		// query param igroup.os_type
		var qrIgroupOsType string

		if o.IgroupOsType != nil {
			qrIgroupOsType = *o.IgroupOsType
		}
		qIgroupOsType := qrIgroupOsType
		if qIgroupOsType != "" {

			if err := r.SetQueryParam("igroup.os_type", qIgroupOsType); err != nil {
				return err
			}
		}
	}

	if o.IgroupProtocol != nil {

		// query param igroup.protocol
		var qrIgroupProtocol string

		if o.IgroupProtocol != nil {
			qrIgroupProtocol = *o.IgroupProtocol
		}
		qIgroupProtocol := qrIgroupProtocol
		if qIgroupProtocol != "" {

			if err := r.SetQueryParam("igroup.protocol", qIgroupProtocol); err != nil {
				return err
			}
		}
	}

	if o.IgroupReplicated != nil {

		// query param igroup.replicated
		var qrIgroupReplicated bool

		if o.IgroupReplicated != nil {
			qrIgroupReplicated = *o.IgroupReplicated
		}
		qIgroupReplicated := swag.FormatBool(qrIgroupReplicated)
		if qIgroupReplicated != "" {

			if err := r.SetQueryParam("igroup.replicated", qIgroupReplicated); err != nil {
				return err
			}
		}
	}

	if o.IgroupUUID != nil {

		// query param igroup.uuid
		var qrIgroupUUID string

		if o.IgroupUUID != nil {
			qrIgroupUUID = *o.IgroupUUID
		}
		qIgroupUUID := qrIgroupUUID
		if qIgroupUUID != "" {

			if err := r.SetQueryParam("igroup.uuid", qIgroupUUID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LogicalUnitNumber != nil {

		// query param logical_unit_number
		var qrLogicalUnitNumber int64

		if o.LogicalUnitNumber != nil {
			qrLogicalUnitNumber = *o.LogicalUnitNumber
		}
		qLogicalUnitNumber := swag.FormatInt64(qrLogicalUnitNumber)
		if qLogicalUnitNumber != "" {

			if err := r.SetQueryParam("logical_unit_number", qLogicalUnitNumber); err != nil {
				return err
			}
		}
	}

	if o.LunName != nil {

		// query param lun.name
		var qrLunName string

		if o.LunName != nil {
			qrLunName = *o.LunName
		}
		qLunName := qrLunName
		if qLunName != "" {

			if err := r.SetQueryParam("lun.name", qLunName); err != nil {
				return err
			}
		}
	}

	if o.LunNodeName != nil {

		// query param lun.node.name
		var qrLunNodeName string

		if o.LunNodeName != nil {
			qrLunNodeName = *o.LunNodeName
		}
		qLunNodeName := qrLunNodeName
		if qLunNodeName != "" {

			if err := r.SetQueryParam("lun.node.name", qLunNodeName); err != nil {
				return err
			}
		}
	}

	if o.LunNodeUUID != nil {

		// query param lun.node.uuid
		var qrLunNodeUUID string

		if o.LunNodeUUID != nil {
			qrLunNodeUUID = *o.LunNodeUUID
		}
		qLunNodeUUID := qrLunNodeUUID
		if qLunNodeUUID != "" {

			if err := r.SetQueryParam("lun.node.uuid", qLunNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LunSmbcReplicated != nil {

		// query param lun.smbc.replicated
		var qrLunSmbcReplicated bool

		if o.LunSmbcReplicated != nil {
			qrLunSmbcReplicated = *o.LunSmbcReplicated
		}
		qLunSmbcReplicated := swag.FormatBool(qrLunSmbcReplicated)
		if qLunSmbcReplicated != "" {

			if err := r.SetQueryParam("lun.smbc.replicated", qLunSmbcReplicated); err != nil {
				return err
			}
		}
	}

	if o.LunUUID != nil {

		// query param lun.uuid
		var qrLunUUID string

		if o.LunUUID != nil {
			qrLunUUID = *o.LunUUID
		}
		qLunUUID := qrLunUUID
		if qLunUUID != "" {

			if err := r.SetQueryParam("lun.uuid", qLunUUID); err != nil {
				return err
			}
		}
	}

	if o.ReportingNodesName != nil {

		// query param reporting_nodes.name
		var qrReportingNodesName string

		if o.ReportingNodesName != nil {
			qrReportingNodesName = *o.ReportingNodesName
		}
		qReportingNodesName := qrReportingNodesName
		if qReportingNodesName != "" {

			if err := r.SetQueryParam("reporting_nodes.name", qReportingNodesName); err != nil {
				return err
			}
		}
	}

	if o.ReportingNodesUUID != nil {

		// query param reporting_nodes.uuid
		var qrReportingNodesUUID string

		if o.ReportingNodesUUID != nil {
			qrReportingNodesUUID = *o.ReportingNodesUUID
		}
		qReportingNodesUUID := qrReportingNodesUUID
		if qReportingNodesUUID != "" {

			if err := r.SetQueryParam("reporting_nodes.uuid", qReportingNodesUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
