// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunMapGetParams creates a new LunMapGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunMapGetParams() *LunMapGetParams {
	return &LunMapGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunMapGetParamsWithTimeout creates a new LunMapGetParams object
// with the ability to set a timeout on a request.
func NewLunMapGetParamsWithTimeout(timeout time.Duration) *LunMapGetParams {
	return &LunMapGetParams{
		timeout: timeout,
	}
}

// NewLunMapGetParamsWithContext creates a new LunMapGetParams object
// with the ability to set a context for a request.
func NewLunMapGetParamsWithContext(ctx context.Context) *LunMapGetParams {
	return &LunMapGetParams{
		Context: ctx,
	}
}

// NewLunMapGetParamsWithHTTPClient creates a new LunMapGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunMapGetParamsWithHTTPClient(client *http.Client) *LunMapGetParams {
	return &LunMapGetParams{
		HTTPClient: client,
	}
}

/*
LunMapGetParams contains all the parameters to send to the API endpoint

	for the lun map get operation.

	Typically these are written to a http.Request.
*/
type LunMapGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IgroupUUID.

	   The unique identifier of the igroup.

	*/
	IgroupUUID string

	/* LunUUID.

	   The unique identifier of the LUN.

	*/
	LunUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun map get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapGetParams) WithDefaults() *LunMapGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun map get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the lun map get params
func (o *LunMapGetParams) WithTimeout(timeout time.Duration) *LunMapGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun map get params
func (o *LunMapGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun map get params
func (o *LunMapGetParams) WithContext(ctx context.Context) *LunMapGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun map get params
func (o *LunMapGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun map get params
func (o *LunMapGetParams) WithHTTPClient(client *http.Client) *LunMapGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun map get params
func (o *LunMapGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the lun map get params
func (o *LunMapGetParams) WithFields(fields []string) *LunMapGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the lun map get params
func (o *LunMapGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIgroupUUID adds the igroupUUID to the lun map get params
func (o *LunMapGetParams) WithIgroupUUID(igroupUUID string) *LunMapGetParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the lun map get params
func (o *LunMapGetParams) SetIgroupUUID(igroupUUID string) {
	o.IgroupUUID = igroupUUID
}

// WithLunUUID adds the lunUUID to the lun map get params
func (o *LunMapGetParams) WithLunUUID(lunUUID string) *LunMapGetParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the lun map get params
func (o *LunMapGetParams) SetLunUUID(lunUUID string) {
	o.LunUUID = lunUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LunMapGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param igroup.uuid
	if err := r.SetPathParam("igroup.uuid", o.IgroupUUID); err != nil {
		return err
	}

	// path param lun.uuid
	if err := r.SetPathParam("lun.uuid", o.LunUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLunMapGet binds the parameter fields
func (o *LunMapGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
