// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewLunMapReportingNodeCreateParams creates a new LunMapReportingNodeCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunMapReportingNodeCreateParams() *LunMapReportingNodeCreateParams {
	return &LunMapReportingNodeCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunMapReportingNodeCreateParamsWithTimeout creates a new LunMapReportingNodeCreateParams object
// with the ability to set a timeout on a request.
func NewLunMapReportingNodeCreateParamsWithTimeout(timeout time.Duration) *LunMapReportingNodeCreateParams {
	return &LunMapReportingNodeCreateParams{
		timeout: timeout,
	}
}

// NewLunMapReportingNodeCreateParamsWithContext creates a new LunMapReportingNodeCreateParams object
// with the ability to set a context for a request.
func NewLunMapReportingNodeCreateParamsWithContext(ctx context.Context) *LunMapReportingNodeCreateParams {
	return &LunMapReportingNodeCreateParams{
		Context: ctx,
	}
}

// NewLunMapReportingNodeCreateParamsWithHTTPClient creates a new LunMapReportingNodeCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunMapReportingNodeCreateParamsWithHTTPClient(client *http.Client) *LunMapReportingNodeCreateParams {
	return &LunMapReportingNodeCreateParams{
		HTTPClient: client,
	}
}

/*
LunMapReportingNodeCreateParams contains all the parameters to send to the API endpoint

	for the lun map reporting node create operation.

	Typically these are written to a http.Request.
*/
type LunMapReportingNodeCreateParams struct {

	/* IgroupUUID.

	   The unique identifier of the igroup.

	*/
	IgroupUUID string

	/* Info.

	   The property values for the new LUN map reporting node.

	*/
	Info *models.LunMapReportingNode

	/* LunUUID.

	   The unique identifier of the LUN.

	*/
	LunUUID string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun map reporting node create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapReportingNodeCreateParams) WithDefaults() *LunMapReportingNodeCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun map reporting node create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapReportingNodeCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := LunMapReportingNodeCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithTimeout(timeout time.Duration) *LunMapReportingNodeCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithContext(ctx context.Context) *LunMapReportingNodeCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithHTTPClient(client *http.Client) *LunMapReportingNodeCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIgroupUUID adds the igroupUUID to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithIgroupUUID(igroupUUID string) *LunMapReportingNodeCreateParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetIgroupUUID(igroupUUID string) {
	o.IgroupUUID = igroupUUID
}

// WithInfo adds the info to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithInfo(info *models.LunMapReportingNode) *LunMapReportingNodeCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetInfo(info *models.LunMapReportingNode) {
	o.Info = info
}

// WithLunUUID adds the lunUUID to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithLunUUID(lunUUID string) *LunMapReportingNodeCreateParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetLunUUID(lunUUID string) {
	o.LunUUID = lunUUID
}

// WithReturnRecords adds the returnRecords to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) WithReturnRecords(returnRecords *bool) *LunMapReportingNodeCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the lun map reporting node create params
func (o *LunMapReportingNodeCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *LunMapReportingNodeCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param igroup.uuid
	if err := r.SetPathParam("igroup.uuid", o.IgroupUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param lun.uuid
	if err := r.SetPathParam("lun.uuid", o.LunUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
