// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunMapReportingNodeDeleteCollectionParams creates a new LunMapReportingNodeDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunMapReportingNodeDeleteCollectionParams() *LunMapReportingNodeDeleteCollectionParams {
	return &LunMapReportingNodeDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunMapReportingNodeDeleteCollectionParamsWithTimeout creates a new LunMapReportingNodeDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewLunMapReportingNodeDeleteCollectionParamsWithTimeout(timeout time.Duration) *LunMapReportingNodeDeleteCollectionParams {
	return &LunMapReportingNodeDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewLunMapReportingNodeDeleteCollectionParamsWithContext creates a new LunMapReportingNodeDeleteCollectionParams object
// with the ability to set a context for a request.
func NewLunMapReportingNodeDeleteCollectionParamsWithContext(ctx context.Context) *LunMapReportingNodeDeleteCollectionParams {
	return &LunMapReportingNodeDeleteCollectionParams{
		Context: ctx,
	}
}

// NewLunMapReportingNodeDeleteCollectionParamsWithHTTPClient creates a new LunMapReportingNodeDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunMapReportingNodeDeleteCollectionParamsWithHTTPClient(client *http.Client) *LunMapReportingNodeDeleteCollectionParams {
	return &LunMapReportingNodeDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
LunMapReportingNodeDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the lun map reporting node delete collection operation.

	Typically these are written to a http.Request.
*/
type LunMapReportingNodeDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* IgroupUUID.

	   The unique identifier of the igroup.

	*/
	IgroupUUID string

	/* Info.

	   Info specification
	*/
	Info LunMapReportingNodeDeleteCollectionBody

	/* LunUUID.

	   The unique identifier of the LUN.

	*/
	LunUUID string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun map reporting node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapReportingNodeDeleteCollectionParams) WithDefaults() *LunMapReportingNodeDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun map reporting node delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunMapReportingNodeDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := LunMapReportingNodeDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithTimeout(timeout time.Duration) *LunMapReportingNodeDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithContext(ctx context.Context) *LunMapReportingNodeDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithHTTPClient(client *http.Client) *LunMapReportingNodeDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *LunMapReportingNodeDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIgroupUUID adds the igroupUUID to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithIgroupUUID(igroupUUID string) *LunMapReportingNodeDeleteCollectionParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetIgroupUUID(igroupUUID string) {
	o.IgroupUUID = igroupUUID
}

// WithInfo adds the info to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithInfo(info LunMapReportingNodeDeleteCollectionBody) *LunMapReportingNodeDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetInfo(info LunMapReportingNodeDeleteCollectionBody) {
	o.Info = info
}

// WithLunUUID adds the lunUUID to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithLunUUID(lunUUID string) *LunMapReportingNodeDeleteCollectionParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetLunUUID(lunUUID string) {
	o.LunUUID = lunUUID
}

// WithName adds the name to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithName(name *string) *LunMapReportingNodeDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *LunMapReportingNodeDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *LunMapReportingNodeDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *LunMapReportingNodeDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUUID adds the uuid to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) WithUUID(uuid *string) *LunMapReportingNodeDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the lun map reporting node delete collection params
func (o *LunMapReportingNodeDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LunMapReportingNodeDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	// path param igroup.uuid
	if err := r.SetPathParam("igroup.uuid", o.IgroupUUID); err != nil {
		return err
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	// path param lun.uuid
	if err := r.SetPathParam("lun.uuid", o.LunUUID); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
