// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunMapReportingNodeDeleteCollectionReader is a Reader for the LunMapReportingNodeDeleteCollection structure.
type LunMapReportingNodeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunMapReportingNodeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunMapReportingNodeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunMapReportingNodeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunMapReportingNodeDeleteCollectionOK creates a LunMapReportingNodeDeleteCollectionOK with default headers values
func NewLunMapReportingNodeDeleteCollectionOK() *LunMapReportingNodeDeleteCollectionOK {
	return &LunMapReportingNodeDeleteCollectionOK{}
}

/*
LunMapReportingNodeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LunMapReportingNodeDeleteCollectionOK struct {
}

// IsSuccess returns true when this lun map reporting node delete collection o k response has a 2xx status code
func (o *LunMapReportingNodeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun map reporting node delete collection o k response has a 3xx status code
func (o *LunMapReportingNodeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun map reporting node delete collection o k response has a 4xx status code
func (o *LunMapReportingNodeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun map reporting node delete collection o k response has a 5xx status code
func (o *LunMapReportingNodeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun map reporting node delete collection o k response a status code equal to that given
func (o *LunMapReportingNodeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun map reporting node delete collection o k response
func (o *LunMapReportingNodeDeleteCollectionOK) Code() int {
	return 200
}

func (o *LunMapReportingNodeDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes][%d] lunMapReportingNodeDeleteCollectionOK", 200)
}

func (o *LunMapReportingNodeDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes][%d] lunMapReportingNodeDeleteCollectionOK", 200)
}

func (o *LunMapReportingNodeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunMapReportingNodeDeleteCollectionDefault creates a LunMapReportingNodeDeleteCollectionDefault with default headers values
func NewLunMapReportingNodeDeleteCollectionDefault(code int) *LunMapReportingNodeDeleteCollectionDefault {
	return &LunMapReportingNodeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LunMapReportingNodeDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374608 | An attempt was made to delete the last reporting node for a LUN. The REST API requires that a LUN map must maintain at least one reporting node. |
| 5374875 | The specified LUN does not exist or is not accessible to the caller. |
| 5374878 | The specified initiator group does not exist, is not accessible to the caller, or is not in the same SVM as the specified LUN. |
| 5374922 | The specified LUN map does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunMapReportingNodeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun map reporting node delete collection default response has a 2xx status code
func (o *LunMapReportingNodeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun map reporting node delete collection default response has a 3xx status code
func (o *LunMapReportingNodeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun map reporting node delete collection default response has a 4xx status code
func (o *LunMapReportingNodeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun map reporting node delete collection default response has a 5xx status code
func (o *LunMapReportingNodeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun map reporting node delete collection default response a status code equal to that given
func (o *LunMapReportingNodeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun map reporting node delete collection default response
func (o *LunMapReportingNodeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LunMapReportingNodeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes][%d] lun_map_reporting_node_delete_collection default %s", o._statusCode, payload)
}

func (o *LunMapReportingNodeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes][%d] lun_map_reporting_node_delete_collection default %s", o._statusCode, payload)
}

func (o *LunMapReportingNodeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunMapReportingNodeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LunMapReportingNodeDeleteCollectionBody lun map reporting node delete collection body
swagger:model LunMapReportingNodeDeleteCollectionBody
*/
type LunMapReportingNodeDeleteCollectionBody struct {

	// lun map reporting node response inline records
	LunMapReportingNodeResponseInlineRecords []*models.LunMapReportingNode `json:"records,omitempty"`
}

// Validate validates this lun map reporting node delete collection body
func (o *LunMapReportingNodeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLunMapReportingNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunMapReportingNodeDeleteCollectionBody) validateLunMapReportingNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMapReportingNodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LunMapReportingNodeResponseInlineRecords); i++ {
		if swag.IsZero(o.LunMapReportingNodeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LunMapReportingNodeResponseInlineRecords[i] != nil {
			if err := o.LunMapReportingNodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this lun map reporting node delete collection body based on the context it is used
func (o *LunMapReportingNodeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLunMapReportingNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunMapReportingNodeDeleteCollectionBody) contextValidateLunMapReportingNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunMapReportingNodeResponseInlineRecords); i++ {

		if o.LunMapReportingNodeResponseInlineRecords[i] != nil {
			if err := o.LunMapReportingNodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunMapReportingNodeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunMapReportingNodeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LunMapReportingNodeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
