// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunMapReportingNodeDeleteReader is a Reader for the LunMapReportingNodeDelete structure.
type LunMapReportingNodeDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunMapReportingNodeDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunMapReportingNodeDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunMapReportingNodeDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunMapReportingNodeDeleteOK creates a LunMapReportingNodeDeleteOK with default headers values
func NewLunMapReportingNodeDeleteOK() *LunMapReportingNodeDeleteOK {
	return &LunMapReportingNodeDeleteOK{}
}

/*
LunMapReportingNodeDeleteOK describes a response with status code 200, with default header values.

OK
*/
type LunMapReportingNodeDeleteOK struct {
}

// IsSuccess returns true when this lun map reporting node delete o k response has a 2xx status code
func (o *LunMapReportingNodeDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun map reporting node delete o k response has a 3xx status code
func (o *LunMapReportingNodeDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun map reporting node delete o k response has a 4xx status code
func (o *LunMapReportingNodeDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun map reporting node delete o k response has a 5xx status code
func (o *LunMapReportingNodeDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun map reporting node delete o k response a status code equal to that given
func (o *LunMapReportingNodeDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun map reporting node delete o k response
func (o *LunMapReportingNodeDeleteOK) Code() int {
	return 200
}

func (o *LunMapReportingNodeDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}][%d] lunMapReportingNodeDeleteOK", 200)
}

func (o *LunMapReportingNodeDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}][%d] lunMapReportingNodeDeleteOK", 200)
}

func (o *LunMapReportingNodeDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunMapReportingNodeDeleteDefault creates a LunMapReportingNodeDeleteDefault with default headers values
func NewLunMapReportingNodeDeleteDefault(code int) *LunMapReportingNodeDeleteDefault {
	return &LunMapReportingNodeDeleteDefault{
		_statusCode: code,
	}
}

/*
	LunMapReportingNodeDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374608 | An attempt was made to delete the last reporting node for a LUN. The REST API requires that a LUN map must maintain at least one reporting node. |
| 5374875 | The specified LUN does not exist or is not accessible to the caller. |
| 5374878 | The specified initiator group does not exist, is not accessible to the caller, or is not in the same SVM as the specified LUN. |
| 5374922 | The specified LUN map does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunMapReportingNodeDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun map reporting node delete default response has a 2xx status code
func (o *LunMapReportingNodeDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun map reporting node delete default response has a 3xx status code
func (o *LunMapReportingNodeDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun map reporting node delete default response has a 4xx status code
func (o *LunMapReportingNodeDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun map reporting node delete default response has a 5xx status code
func (o *LunMapReportingNodeDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun map reporting node delete default response a status code equal to that given
func (o *LunMapReportingNodeDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun map reporting node delete default response
func (o *LunMapReportingNodeDeleteDefault) Code() int {
	return o._statusCode
}

func (o *LunMapReportingNodeDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}][%d] lun_map_reporting_node_delete default %s", o._statusCode, payload)
}

func (o *LunMapReportingNodeDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}][%d] lun_map_reporting_node_delete default %s", o._statusCode, payload)
}

func (o *LunMapReportingNodeDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunMapReportingNodeDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
