// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceFcpMetricGetReader is a Reader for the PerformanceFcpMetricGet structure.
type PerformanceFcpMetricGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceFcpMetricGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceFcpMetricGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceFcpMetricGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceFcpMetricGetOK creates a PerformanceFcpMetricGetOK with default headers values
func NewPerformanceFcpMetricGetOK() *PerformanceFcpMetricGetOK {
	return &PerformanceFcpMetricGetOK{}
}

/*
PerformanceFcpMetricGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceFcpMetricGetOK struct {
	Payload *models.PerformanceFcpMetric
}

// IsSuccess returns true when this performance fcp metric get o k response has a 2xx status code
func (o *PerformanceFcpMetricGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance fcp metric get o k response has a 3xx status code
func (o *PerformanceFcpMetricGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance fcp metric get o k response has a 4xx status code
func (o *PerformanceFcpMetricGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance fcp metric get o k response has a 5xx status code
func (o *PerformanceFcpMetricGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance fcp metric get o k response a status code equal to that given
func (o *PerformanceFcpMetricGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance fcp metric get o k response
func (o *PerformanceFcpMetricGetOK) Code() int {
	return 200
}

func (o *PerformanceFcpMetricGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/fcp/services/{svm.uuid}/metrics/{timestamp}][%d] performanceFcpMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcpMetricGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/fcp/services/{svm.uuid}/metrics/{timestamp}][%d] performanceFcpMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcpMetricGetOK) GetPayload() *models.PerformanceFcpMetric {
	return o.Payload
}

func (o *PerformanceFcpMetricGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceFcpMetric)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceFcpMetricGetDefault creates a PerformanceFcpMetricGetDefault with default headers values
func NewPerformanceFcpMetricGetDefault(code int) *PerformanceFcpMetricGetDefault {
	return &PerformanceFcpMetricGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceFcpMetricGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585947 | No metrics are available for the requested object. |
| 8586225 | An unexpected error occurred retrieving metrics for the requested object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceFcpMetricGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance fcp metric get default response has a 2xx status code
func (o *PerformanceFcpMetricGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance fcp metric get default response has a 3xx status code
func (o *PerformanceFcpMetricGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance fcp metric get default response has a 4xx status code
func (o *PerformanceFcpMetricGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance fcp metric get default response has a 5xx status code
func (o *PerformanceFcpMetricGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance fcp metric get default response a status code equal to that given
func (o *PerformanceFcpMetricGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance fcp metric get default response
func (o *PerformanceFcpMetricGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceFcpMetricGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/fcp/services/{svm.uuid}/metrics/{timestamp}][%d] performance_fcp_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcpMetricGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/fcp/services/{svm.uuid}/metrics/{timestamp}][%d] performance_fcp_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcpMetricGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceFcpMetricGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
