// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceIscsiMetricGetReader is a Reader for the PerformanceIscsiMetricGet structure.
type PerformanceIscsiMetricGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceIscsiMetricGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceIscsiMetricGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceIscsiMetricGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceIscsiMetricGetOK creates a PerformanceIscsiMetricGetOK with default headers values
func NewPerformanceIscsiMetricGetOK() *PerformanceIscsiMetricGetOK {
	return &PerformanceIscsiMetricGetOK{}
}

/*
PerformanceIscsiMetricGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceIscsiMetricGetOK struct {
	Payload *models.PerformanceIscsiMetric
}

// IsSuccess returns true when this performance iscsi metric get o k response has a 2xx status code
func (o *PerformanceIscsiMetricGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance iscsi metric get o k response has a 3xx status code
func (o *PerformanceIscsiMetricGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance iscsi metric get o k response has a 4xx status code
func (o *PerformanceIscsiMetricGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance iscsi metric get o k response has a 5xx status code
func (o *PerformanceIscsiMetricGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance iscsi metric get o k response a status code equal to that given
func (o *PerformanceIscsiMetricGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance iscsi metric get o k response
func (o *PerformanceIscsiMetricGetOK) Code() int {
	return 200
}

func (o *PerformanceIscsiMetricGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/services/{svm.uuid}/metrics/{timestamp}][%d] performanceIscsiMetricGetOK %s", 200, payload)
}

func (o *PerformanceIscsiMetricGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/services/{svm.uuid}/metrics/{timestamp}][%d] performanceIscsiMetricGetOK %s", 200, payload)
}

func (o *PerformanceIscsiMetricGetOK) GetPayload() *models.PerformanceIscsiMetric {
	return o.Payload
}

func (o *PerformanceIscsiMetricGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceIscsiMetric)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceIscsiMetricGetDefault creates a PerformanceIscsiMetricGetDefault with default headers values
func NewPerformanceIscsiMetricGetDefault(code int) *PerformanceIscsiMetricGetDefault {
	return &PerformanceIscsiMetricGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceIscsiMetricGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585947 | No metrics are available for the requested object. |
| 8586225 | An unexpected error occurred retrieving metrics for the requested object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceIscsiMetricGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance iscsi metric get default response has a 2xx status code
func (o *PerformanceIscsiMetricGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance iscsi metric get default response has a 3xx status code
func (o *PerformanceIscsiMetricGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance iscsi metric get default response has a 4xx status code
func (o *PerformanceIscsiMetricGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance iscsi metric get default response has a 5xx status code
func (o *PerformanceIscsiMetricGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance iscsi metric get default response a status code equal to that given
func (o *PerformanceIscsiMetricGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance iscsi metric get default response
func (o *PerformanceIscsiMetricGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceIscsiMetricGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/services/{svm.uuid}/metrics/{timestamp}][%d] performance_iscsi_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceIscsiMetricGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/services/{svm.uuid}/metrics/{timestamp}][%d] performance_iscsi_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceIscsiMetricGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceIscsiMetricGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
