// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceLunMetricCollectionGetReader is a Reader for the PerformanceLunMetricCollectionGet structure.
type PerformanceLunMetricCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceLunMetricCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceLunMetricCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceLunMetricCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceLunMetricCollectionGetOK creates a PerformanceLunMetricCollectionGetOK with default headers values
func NewPerformanceLunMetricCollectionGetOK() *PerformanceLunMetricCollectionGetOK {
	return &PerformanceLunMetricCollectionGetOK{}
}

/*
PerformanceLunMetricCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceLunMetricCollectionGetOK struct {
	Payload *models.PerformanceLunMetricResponse
}

// IsSuccess returns true when this performance lun metric collection get o k response has a 2xx status code
func (o *PerformanceLunMetricCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance lun metric collection get o k response has a 3xx status code
func (o *PerformanceLunMetricCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance lun metric collection get o k response has a 4xx status code
func (o *PerformanceLunMetricCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance lun metric collection get o k response has a 5xx status code
func (o *PerformanceLunMetricCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance lun metric collection get o k response a status code equal to that given
func (o *PerformanceLunMetricCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance lun metric collection get o k response
func (o *PerformanceLunMetricCollectionGetOK) Code() int {
	return 200
}

func (o *PerformanceLunMetricCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns/{lun.uuid}/metrics][%d] performanceLunMetricCollectionGetOK %s", 200, payload)
}

func (o *PerformanceLunMetricCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns/{lun.uuid}/metrics][%d] performanceLunMetricCollectionGetOK %s", 200, payload)
}

func (o *PerformanceLunMetricCollectionGetOK) GetPayload() *models.PerformanceLunMetricResponse {
	return o.Payload
}

func (o *PerformanceLunMetricCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceLunMetricResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceLunMetricCollectionGetDefault creates a PerformanceLunMetricCollectionGetDefault with default headers values
func NewPerformanceLunMetricCollectionGetDefault(code int) *PerformanceLunMetricCollectionGetDefault {
	return &PerformanceLunMetricCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceLunMetricCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585947 | No metrics are available for the requested object. |
| 8586225 | An unexpected error occurred retrieving metrics for the requested object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceLunMetricCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance lun metric collection get default response has a 2xx status code
func (o *PerformanceLunMetricCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance lun metric collection get default response has a 3xx status code
func (o *PerformanceLunMetricCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance lun metric collection get default response has a 4xx status code
func (o *PerformanceLunMetricCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance lun metric collection get default response has a 5xx status code
func (o *PerformanceLunMetricCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance lun metric collection get default response a status code equal to that given
func (o *PerformanceLunMetricCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance lun metric collection get default response
func (o *PerformanceLunMetricCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceLunMetricCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns/{lun.uuid}/metrics][%d] performance_lun_metric_collection_get default %s", o._statusCode, payload)
}

func (o *PerformanceLunMetricCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns/{lun.uuid}/metrics][%d] performance_lun_metric_collection_get default %s", o._statusCode, payload)
}

func (o *PerformanceLunMetricCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceLunMetricCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
