// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPerformanceLunMetricGetParams creates a new PerformanceLunMetricGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformanceLunMetricGetParams() *PerformanceLunMetricGetParams {
	return &PerformanceLunMetricGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformanceLunMetricGetParamsWithTimeout creates a new PerformanceLunMetricGetParams object
// with the ability to set a timeout on a request.
func NewPerformanceLunMetricGetParamsWithTimeout(timeout time.Duration) *PerformanceLunMetricGetParams {
	return &PerformanceLunMetricGetParams{
		timeout: timeout,
	}
}

// NewPerformanceLunMetricGetParamsWithContext creates a new PerformanceLunMetricGetParams object
// with the ability to set a context for a request.
func NewPerformanceLunMetricGetParamsWithContext(ctx context.Context) *PerformanceLunMetricGetParams {
	return &PerformanceLunMetricGetParams{
		Context: ctx,
	}
}

// NewPerformanceLunMetricGetParamsWithHTTPClient creates a new PerformanceLunMetricGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformanceLunMetricGetParamsWithHTTPClient(client *http.Client) *PerformanceLunMetricGetParams {
	return &PerformanceLunMetricGetParams{
		HTTPClient: client,
	}
}

/*
PerformanceLunMetricGetParams contains all the parameters to send to the API endpoint

	for the performance lun metric get operation.

	Typically these are written to a http.Request.
*/
type PerformanceLunMetricGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LunUUID.

	   The unique identifier of the LUN.

	*/
	LunUUID string

	/* Timestamp.

	   The timestamp of the space and performance data.


	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the performance lun metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceLunMetricGetParams) WithDefaults() *PerformanceLunMetricGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the performance lun metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceLunMetricGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithTimeout(timeout time.Duration) *PerformanceLunMetricGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithContext(ctx context.Context) *PerformanceLunMetricGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithHTTPClient(client *http.Client) *PerformanceLunMetricGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithFields(fields []string) *PerformanceLunMetricGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLunUUID adds the lunUUID to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithLunUUID(lunUUID string) *PerformanceLunMetricGetParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetLunUUID(lunUUID string) {
	o.LunUUID = lunUUID
}

// WithTimestamp adds the timestamp to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) WithTimestamp(timestamp strfmt.DateTime) *PerformanceLunMetricGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the performance lun metric get params
func (o *PerformanceLunMetricGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *PerformanceLunMetricGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param lun.uuid
	if err := r.SetPathParam("lun.uuid", o.LunUUID); err != nil {
		return err
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPerformanceLunMetricGet binds the parameter fields
func (o *PerformanceLunMetricGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
