// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPortsetCollectionGetParams creates a new PortsetCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPortsetCollectionGetParams() *PortsetCollectionGetParams {
	return &PortsetCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPortsetCollectionGetParamsWithTimeout creates a new PortsetCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPortsetCollectionGetParamsWithTimeout(timeout time.Duration) *PortsetCollectionGetParams {
	return &PortsetCollectionGetParams{
		timeout: timeout,
	}
}

// NewPortsetCollectionGetParamsWithContext creates a new PortsetCollectionGetParams object
// with the ability to set a context for a request.
func NewPortsetCollectionGetParamsWithContext(ctx context.Context) *PortsetCollectionGetParams {
	return &PortsetCollectionGetParams{
		Context: ctx,
	}
}

// NewPortsetCollectionGetParamsWithHTTPClient creates a new PortsetCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPortsetCollectionGetParamsWithHTTPClient(client *http.Client) *PortsetCollectionGetParams {
	return &PortsetCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PortsetCollectionGetParams contains all the parameters to send to the API endpoint

	for the portset collection get operation.

	Typically these are written to a http.Request.
*/
type PortsetCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IgroupsName.

	   Filter by igroups.name
	*/
	IgroupsName *string

	/* IgroupsUUID.

	   Filter by igroups.uuid
	*/
	IgroupsUUID *string

	/* InterfacesFcName.

	   Filter by interfaces.fc.name
	*/
	InterfacesFcName *string

	/* InterfacesFcUUID.

	   Filter by interfaces.fc.uuid
	*/
	InterfacesFcUUID *string

	/* InterfacesFcWwpn.

	   Filter by interfaces.fc.wwpn
	*/
	InterfacesFcWwpn *string

	/* InterfacesIPIPAddress.

	   Filter by interfaces.ip.ip.address
	*/
	InterfacesIPIPAddress *string

	/* InterfacesIPName.

	   Filter by interfaces.ip.name
	*/
	InterfacesIPName *string

	/* InterfacesIPUUID.

	   Filter by interfaces.ip.uuid
	*/
	InterfacesIPUUID *string

	/* InterfacesUUID.

	   Filter by interfaces.uuid
	*/
	InterfacesUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the portset collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortsetCollectionGetParams) WithDefaults() *PortsetCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the portset collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortsetCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PortsetCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the portset collection get params
func (o *PortsetCollectionGetParams) WithTimeout(timeout time.Duration) *PortsetCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the portset collection get params
func (o *PortsetCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the portset collection get params
func (o *PortsetCollectionGetParams) WithContext(ctx context.Context) *PortsetCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the portset collection get params
func (o *PortsetCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the portset collection get params
func (o *PortsetCollectionGetParams) WithHTTPClient(client *http.Client) *PortsetCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the portset collection get params
func (o *PortsetCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the portset collection get params
func (o *PortsetCollectionGetParams) WithFields(fields []string) *PortsetCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the portset collection get params
func (o *PortsetCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIgroupsName adds the igroupsName to the portset collection get params
func (o *PortsetCollectionGetParams) WithIgroupsName(igroupsName *string) *PortsetCollectionGetParams {
	o.SetIgroupsName(igroupsName)
	return o
}

// SetIgroupsName adds the igroupsName to the portset collection get params
func (o *PortsetCollectionGetParams) SetIgroupsName(igroupsName *string) {
	o.IgroupsName = igroupsName
}

// WithIgroupsUUID adds the igroupsUUID to the portset collection get params
func (o *PortsetCollectionGetParams) WithIgroupsUUID(igroupsUUID *string) *PortsetCollectionGetParams {
	o.SetIgroupsUUID(igroupsUUID)
	return o
}

// SetIgroupsUUID adds the igroupsUuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetIgroupsUUID(igroupsUUID *string) {
	o.IgroupsUUID = igroupsUUID
}

// WithInterfacesFcName adds the interfacesFcName to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesFcName(interfacesFcName *string) *PortsetCollectionGetParams {
	o.SetInterfacesFcName(interfacesFcName)
	return o
}

// SetInterfacesFcName adds the interfacesFcName to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesFcName(interfacesFcName *string) {
	o.InterfacesFcName = interfacesFcName
}

// WithInterfacesFcUUID adds the interfacesFcUUID to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesFcUUID(interfacesFcUUID *string) *PortsetCollectionGetParams {
	o.SetInterfacesFcUUID(interfacesFcUUID)
	return o
}

// SetInterfacesFcUUID adds the interfacesFcUuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesFcUUID(interfacesFcUUID *string) {
	o.InterfacesFcUUID = interfacesFcUUID
}

// WithInterfacesFcWwpn adds the interfacesFcWwpn to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesFcWwpn(interfacesFcWwpn *string) *PortsetCollectionGetParams {
	o.SetInterfacesFcWwpn(interfacesFcWwpn)
	return o
}

// SetInterfacesFcWwpn adds the interfacesFcWwpn to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesFcWwpn(interfacesFcWwpn *string) {
	o.InterfacesFcWwpn = interfacesFcWwpn
}

// WithInterfacesIPIPAddress adds the interfacesIPIPAddress to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesIPIPAddress(interfacesIPIPAddress *string) *PortsetCollectionGetParams {
	o.SetInterfacesIPIPAddress(interfacesIPIPAddress)
	return o
}

// SetInterfacesIPIPAddress adds the interfacesIpIpAddress to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesIPIPAddress(interfacesIPIPAddress *string) {
	o.InterfacesIPIPAddress = interfacesIPIPAddress
}

// WithInterfacesIPName adds the interfacesIPName to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesIPName(interfacesIPName *string) *PortsetCollectionGetParams {
	o.SetInterfacesIPName(interfacesIPName)
	return o
}

// SetInterfacesIPName adds the interfacesIpName to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesIPName(interfacesIPName *string) {
	o.InterfacesIPName = interfacesIPName
}

// WithInterfacesIPUUID adds the interfacesIPUUID to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesIPUUID(interfacesIPUUID *string) *PortsetCollectionGetParams {
	o.SetInterfacesIPUUID(interfacesIPUUID)
	return o
}

// SetInterfacesIPUUID adds the interfacesIpUuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesIPUUID(interfacesIPUUID *string) {
	o.InterfacesIPUUID = interfacesIPUUID
}

// WithInterfacesUUID adds the interfacesUUID to the portset collection get params
func (o *PortsetCollectionGetParams) WithInterfacesUUID(interfacesUUID *string) *PortsetCollectionGetParams {
	o.SetInterfacesUUID(interfacesUUID)
	return o
}

// SetInterfacesUUID adds the interfacesUuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetInterfacesUUID(interfacesUUID *string) {
	o.InterfacesUUID = interfacesUUID
}

// WithMaxRecords adds the maxRecords to the portset collection get params
func (o *PortsetCollectionGetParams) WithMaxRecords(maxRecords *int64) *PortsetCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the portset collection get params
func (o *PortsetCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the portset collection get params
func (o *PortsetCollectionGetParams) WithName(name *string) *PortsetCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the portset collection get params
func (o *PortsetCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the portset collection get params
func (o *PortsetCollectionGetParams) WithOrderBy(orderBy []string) *PortsetCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the portset collection get params
func (o *PortsetCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProtocol adds the protocol to the portset collection get params
func (o *PortsetCollectionGetParams) WithProtocol(protocol *string) *PortsetCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the portset collection get params
func (o *PortsetCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the portset collection get params
func (o *PortsetCollectionGetParams) WithReturnRecords(returnRecords *bool) *PortsetCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the portset collection get params
func (o *PortsetCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the portset collection get params
func (o *PortsetCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PortsetCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the portset collection get params
func (o *PortsetCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the portset collection get params
func (o *PortsetCollectionGetParams) WithSvmName(svmName *string) *PortsetCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the portset collection get params
func (o *PortsetCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the portset collection get params
func (o *PortsetCollectionGetParams) WithSvmUUID(svmUUID *string) *PortsetCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the portset collection get params
func (o *PortsetCollectionGetParams) WithUUID(uuid *string) *PortsetCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the portset collection get params
func (o *PortsetCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *PortsetCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IgroupsName != nil {

		// query param igroups.name
		var qrIgroupsName string

		if o.IgroupsName != nil {
			qrIgroupsName = *o.IgroupsName
		}
		qIgroupsName := qrIgroupsName
		if qIgroupsName != "" {

			if err := r.SetQueryParam("igroups.name", qIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.IgroupsUUID != nil {

		// query param igroups.uuid
		var qrIgroupsUUID string

		if o.IgroupsUUID != nil {
			qrIgroupsUUID = *o.IgroupsUUID
		}
		qIgroupsUUID := qrIgroupsUUID
		if qIgroupsUUID != "" {

			if err := r.SetQueryParam("igroups.uuid", qIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.InterfacesFcName != nil {

		// query param interfaces.fc.name
		var qrInterfacesFcName string

		if o.InterfacesFcName != nil {
			qrInterfacesFcName = *o.InterfacesFcName
		}
		qInterfacesFcName := qrInterfacesFcName
		if qInterfacesFcName != "" {

			if err := r.SetQueryParam("interfaces.fc.name", qInterfacesFcName); err != nil {
				return err
			}
		}
	}

	if o.InterfacesFcUUID != nil {

		// query param interfaces.fc.uuid
		var qrInterfacesFcUUID string

		if o.InterfacesFcUUID != nil {
			qrInterfacesFcUUID = *o.InterfacesFcUUID
		}
		qInterfacesFcUUID := qrInterfacesFcUUID
		if qInterfacesFcUUID != "" {

			if err := r.SetQueryParam("interfaces.fc.uuid", qInterfacesFcUUID); err != nil {
				return err
			}
		}
	}

	if o.InterfacesFcWwpn != nil {

		// query param interfaces.fc.wwpn
		var qrInterfacesFcWwpn string

		if o.InterfacesFcWwpn != nil {
			qrInterfacesFcWwpn = *o.InterfacesFcWwpn
		}
		qInterfacesFcWwpn := qrInterfacesFcWwpn
		if qInterfacesFcWwpn != "" {

			if err := r.SetQueryParam("interfaces.fc.wwpn", qInterfacesFcWwpn); err != nil {
				return err
			}
		}
	}

	if o.InterfacesIPIPAddress != nil {

		// query param interfaces.ip.ip.address
		var qrInterfacesIPIPAddress string

		if o.InterfacesIPIPAddress != nil {
			qrInterfacesIPIPAddress = *o.InterfacesIPIPAddress
		}
		qInterfacesIPIPAddress := qrInterfacesIPIPAddress
		if qInterfacesIPIPAddress != "" {

			if err := r.SetQueryParam("interfaces.ip.ip.address", qInterfacesIPIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfacesIPName != nil {

		// query param interfaces.ip.name
		var qrInterfacesIPName string

		if o.InterfacesIPName != nil {
			qrInterfacesIPName = *o.InterfacesIPName
		}
		qInterfacesIPName := qrInterfacesIPName
		if qInterfacesIPName != "" {

			if err := r.SetQueryParam("interfaces.ip.name", qInterfacesIPName); err != nil {
				return err
			}
		}
	}

	if o.InterfacesIPUUID != nil {

		// query param interfaces.ip.uuid
		var qrInterfacesIPUUID string

		if o.InterfacesIPUUID != nil {
			qrInterfacesIPUUID = *o.InterfacesIPUUID
		}
		qInterfacesIPUUID := qrInterfacesIPUUID
		if qInterfacesIPUUID != "" {

			if err := r.SetQueryParam("interfaces.ip.uuid", qInterfacesIPUUID); err != nil {
				return err
			}
		}
	}

	if o.InterfacesUUID != nil {

		// query param interfaces.uuid
		var qrInterfacesUUID string

		if o.InterfacesUUID != nil {
			qrInterfacesUUID = *o.InterfacesUUID
		}
		qInterfacesUUID := qrInterfacesUUID
		if qInterfacesUUID != "" {

			if err := r.SetQueryParam("interfaces.uuid", qInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPortsetCollectionGet binds the parameter fields
func (o *PortsetCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPortsetCollectionGet binds the parameter order_by
func (o *PortsetCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
