// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PortsetDeleteCollectionReader is a Reader for the PortsetDeleteCollection structure.
type PortsetDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PortsetDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPortsetDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPortsetDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPortsetDeleteCollectionOK creates a PortsetDeleteCollectionOK with default headers values
func NewPortsetDeleteCollectionOK() *PortsetDeleteCollectionOK {
	return &PortsetDeleteCollectionOK{}
}

/*
PortsetDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type PortsetDeleteCollectionOK struct {
}

// IsSuccess returns true when this portset delete collection o k response has a 2xx status code
func (o *PortsetDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this portset delete collection o k response has a 3xx status code
func (o *PortsetDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this portset delete collection o k response has a 4xx status code
func (o *PortsetDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this portset delete collection o k response has a 5xx status code
func (o *PortsetDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this portset delete collection o k response a status code equal to that given
func (o *PortsetDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the portset delete collection o k response
func (o *PortsetDeleteCollectionOK) Code() int {
	return 200
}

func (o *PortsetDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets][%d] portsetDeleteCollectionOK", 200)
}

func (o *PortsetDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets][%d] portsetDeleteCollectionOK", 200)
}

func (o *PortsetDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPortsetDeleteCollectionDefault creates a PortsetDeleteCollectionDefault with default headers values
func NewPortsetDeleteCollectionDefault(code int) *PortsetDeleteCollectionDefault {
	return &PortsetDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	PortsetDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374063 | An attempt was made to delete a portset that is bound to an initiator group without using query parameter `allow_delete_while_bound`. |
| 5374908 | The portset does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PortsetDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this portset delete collection default response has a 2xx status code
func (o *PortsetDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this portset delete collection default response has a 3xx status code
func (o *PortsetDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this portset delete collection default response has a 4xx status code
func (o *PortsetDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this portset delete collection default response has a 5xx status code
func (o *PortsetDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this portset delete collection default response a status code equal to that given
func (o *PortsetDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the portset delete collection default response
func (o *PortsetDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *PortsetDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets][%d] portset_delete_collection default %s", o._statusCode, payload)
}

func (o *PortsetDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets][%d] portset_delete_collection default %s", o._statusCode, payload)
}

func (o *PortsetDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PortsetDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PortsetDeleteCollectionBody portset delete collection body
swagger:model PortsetDeleteCollectionBody
*/
type PortsetDeleteCollectionBody struct {

	// portset response inline records
	PortsetResponseInlineRecords []*models.Portset `json:"records,omitempty"`
}

// Validate validates this portset delete collection body
func (o *PortsetDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePortsetResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortsetDeleteCollectionBody) validatePortsetResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.PortsetResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.PortsetResponseInlineRecords); i++ {
		if swag.IsZero(o.PortsetResponseInlineRecords[i]) { // not required
			continue
		}

		if o.PortsetResponseInlineRecords[i] != nil {
			if err := o.PortsetResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this portset delete collection body based on the context it is used
func (o *PortsetDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePortsetResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortsetDeleteCollectionBody) contextValidatePortsetResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PortsetResponseInlineRecords); i++ {

		if o.PortsetResponseInlineRecords[i] != nil {
			if err := o.PortsetResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortsetDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortsetDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res PortsetDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
