// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPortsetDeleteParams creates a new PortsetDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPortsetDeleteParams() *PortsetDeleteParams {
	return &PortsetDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPortsetDeleteParamsWithTimeout creates a new PortsetDeleteParams object
// with the ability to set a timeout on a request.
func NewPortsetDeleteParamsWithTimeout(timeout time.Duration) *PortsetDeleteParams {
	return &PortsetDeleteParams{
		timeout: timeout,
	}
}

// NewPortsetDeleteParamsWithContext creates a new PortsetDeleteParams object
// with the ability to set a context for a request.
func NewPortsetDeleteParamsWithContext(ctx context.Context) *PortsetDeleteParams {
	return &PortsetDeleteParams{
		Context: ctx,
	}
}

// NewPortsetDeleteParamsWithHTTPClient creates a new PortsetDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewPortsetDeleteParamsWithHTTPClient(client *http.Client) *PortsetDeleteParams {
	return &PortsetDeleteParams{
		HTTPClient: client,
	}
}

/*
PortsetDeleteParams contains all the parameters to send to the API endpoint

	for the portset delete operation.

	Typically these are written to a http.Request.
*/
type PortsetDeleteParams struct {

	/* AllowDeleteWhileBound.

	     Allows deletion of a portset that is bound to an igroup.<br/>
	Deleting a portset can expand the set of LIFs through which a LUN is available.

	*/
	AllowDeleteWhileBound *bool

	/* UUID.

	   The unique identifier of the portset.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the portset delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortsetDeleteParams) WithDefaults() *PortsetDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the portset delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortsetDeleteParams) SetDefaults() {
	var (
		allowDeleteWhileBoundDefault = bool(false)
	)

	val := PortsetDeleteParams{
		AllowDeleteWhileBound: &allowDeleteWhileBoundDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the portset delete params
func (o *PortsetDeleteParams) WithTimeout(timeout time.Duration) *PortsetDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the portset delete params
func (o *PortsetDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the portset delete params
func (o *PortsetDeleteParams) WithContext(ctx context.Context) *PortsetDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the portset delete params
func (o *PortsetDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the portset delete params
func (o *PortsetDeleteParams) WithHTTPClient(client *http.Client) *PortsetDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the portset delete params
func (o *PortsetDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAllowDeleteWhileBound adds the allowDeleteWhileBound to the portset delete params
func (o *PortsetDeleteParams) WithAllowDeleteWhileBound(allowDeleteWhileBound *bool) *PortsetDeleteParams {
	o.SetAllowDeleteWhileBound(allowDeleteWhileBound)
	return o
}

// SetAllowDeleteWhileBound adds the allowDeleteWhileBound to the portset delete params
func (o *PortsetDeleteParams) SetAllowDeleteWhileBound(allowDeleteWhileBound *bool) {
	o.AllowDeleteWhileBound = allowDeleteWhileBound
}

// WithUUID adds the uuid to the portset delete params
func (o *PortsetDeleteParams) WithUUID(uuid string) *PortsetDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the portset delete params
func (o *PortsetDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *PortsetDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AllowDeleteWhileBound != nil {

		// query param allow_delete_while_bound
		var qrAllowDeleteWhileBound bool

		if o.AllowDeleteWhileBound != nil {
			qrAllowDeleteWhileBound = *o.AllowDeleteWhileBound
		}
		qAllowDeleteWhileBound := swag.FormatBool(qrAllowDeleteWhileBound)
		if qAllowDeleteWhileBound != "" {

			if err := r.SetQueryParam("allow_delete_while_bound", qAllowDeleteWhileBound); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
