// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PortsetDeleteReader is a Reader for the PortsetDelete structure.
type PortsetDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PortsetDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPortsetDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPortsetDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPortsetDeleteOK creates a PortsetDeleteOK with default headers values
func NewPortsetDeleteOK() *PortsetDeleteOK {
	return &PortsetDeleteOK{}
}

/*
PortsetDeleteOK describes a response with status code 200, with default header values.

OK
*/
type PortsetDeleteOK struct {
}

// IsSuccess returns true when this portset delete o k response has a 2xx status code
func (o *PortsetDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this portset delete o k response has a 3xx status code
func (o *PortsetDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this portset delete o k response has a 4xx status code
func (o *PortsetDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this portset delete o k response has a 5xx status code
func (o *PortsetDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this portset delete o k response a status code equal to that given
func (o *PortsetDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the portset delete o k response
func (o *PortsetDeleteOK) Code() int {
	return 200
}

func (o *PortsetDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{uuid}][%d] portsetDeleteOK", 200)
}

func (o *PortsetDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{uuid}][%d] portsetDeleteOK", 200)
}

func (o *PortsetDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPortsetDeleteDefault creates a PortsetDeleteDefault with default headers values
func NewPortsetDeleteDefault(code int) *PortsetDeleteDefault {
	return &PortsetDeleteDefault{
		_statusCode: code,
	}
}

/*
	PortsetDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374063 | An attempt was made to delete a portset that is bound to an initiator group without using query parameter `allow_delete_while_bound`. |
| 5374908 | The portset does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PortsetDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this portset delete default response has a 2xx status code
func (o *PortsetDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this portset delete default response has a 3xx status code
func (o *PortsetDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this portset delete default response has a 4xx status code
func (o *PortsetDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this portset delete default response has a 5xx status code
func (o *PortsetDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this portset delete default response a status code equal to that given
func (o *PortsetDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the portset delete default response
func (o *PortsetDeleteDefault) Code() int {
	return o._statusCode
}

func (o *PortsetDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{uuid}][%d] portset_delete default %s", o._statusCode, payload)
}

func (o *PortsetDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{uuid}][%d] portset_delete default %s", o._statusCode, payload)
}

func (o *PortsetDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PortsetDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
