// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PortsetInterfaceDeleteCollectionReader is a Reader for the PortsetInterfaceDeleteCollection structure.
type PortsetInterfaceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PortsetInterfaceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPortsetInterfaceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPortsetInterfaceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPortsetInterfaceDeleteCollectionOK creates a PortsetInterfaceDeleteCollectionOK with default headers values
func NewPortsetInterfaceDeleteCollectionOK() *PortsetInterfaceDeleteCollectionOK {
	return &PortsetInterfaceDeleteCollectionOK{}
}

/*
PortsetInterfaceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type PortsetInterfaceDeleteCollectionOK struct {
}

// IsSuccess returns true when this portset interface delete collection o k response has a 2xx status code
func (o *PortsetInterfaceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this portset interface delete collection o k response has a 3xx status code
func (o *PortsetInterfaceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this portset interface delete collection o k response has a 4xx status code
func (o *PortsetInterfaceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this portset interface delete collection o k response has a 5xx status code
func (o *PortsetInterfaceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this portset interface delete collection o k response a status code equal to that given
func (o *PortsetInterfaceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the portset interface delete collection o k response
func (o *PortsetInterfaceDeleteCollectionOK) Code() int {
	return 200
}

func (o *PortsetInterfaceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{portset.uuid}/interfaces][%d] portsetInterfaceDeleteCollectionOK", 200)
}

func (o *PortsetInterfaceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{portset.uuid}/interfaces][%d] portsetInterfaceDeleteCollectionOK", 200)
}

func (o *PortsetInterfaceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPortsetInterfaceDeleteCollectionDefault creates a PortsetInterfaceDeleteCollectionDefault with default headers values
func NewPortsetInterfaceDeleteCollectionDefault(code int) *PortsetInterfaceDeleteCollectionDefault {
	return &PortsetInterfaceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	PortsetInterfaceDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374906 | A specified network interface was not found. |
| 5374908 | The portset specified in the URI does not exist. |
| 5374916 | The specified network interface is not in the portset. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PortsetInterfaceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this portset interface delete collection default response has a 2xx status code
func (o *PortsetInterfaceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this portset interface delete collection default response has a 3xx status code
func (o *PortsetInterfaceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this portset interface delete collection default response has a 4xx status code
func (o *PortsetInterfaceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this portset interface delete collection default response has a 5xx status code
func (o *PortsetInterfaceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this portset interface delete collection default response a status code equal to that given
func (o *PortsetInterfaceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the portset interface delete collection default response
func (o *PortsetInterfaceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *PortsetInterfaceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{portset.uuid}/interfaces][%d] portset_interface_delete_collection default %s", o._statusCode, payload)
}

func (o *PortsetInterfaceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/portsets/{portset.uuid}/interfaces][%d] portset_interface_delete_collection default %s", o._statusCode, payload)
}

func (o *PortsetInterfaceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PortsetInterfaceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PortsetInterfaceDeleteCollectionBody portset interface delete collection body
swagger:model PortsetInterfaceDeleteCollectionBody
*/
type PortsetInterfaceDeleteCollectionBody struct {

	// portset interface response inline records
	PortsetInterfaceResponseInlineRecords []*models.PortsetInterface `json:"records,omitempty"`
}

// Validate validates this portset interface delete collection body
func (o *PortsetInterfaceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePortsetInterfaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortsetInterfaceDeleteCollectionBody) validatePortsetInterfaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.PortsetInterfaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.PortsetInterfaceResponseInlineRecords); i++ {
		if swag.IsZero(o.PortsetInterfaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.PortsetInterfaceResponseInlineRecords[i] != nil {
			if err := o.PortsetInterfaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this portset interface delete collection body based on the context it is used
func (o *PortsetInterfaceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePortsetInterfaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PortsetInterfaceDeleteCollectionBody) contextValidatePortsetInterfaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PortsetInterfaceResponseInlineRecords); i++ {

		if o.PortsetInterfaceResponseInlineRecords[i] != nil {
			if err := o.PortsetInterfaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PortsetInterfaceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PortsetInterfaceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res PortsetInterfaceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
