// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PortsetInterfaceGetReader is a Reader for the PortsetInterfaceGet structure.
type PortsetInterfaceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PortsetInterfaceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPortsetInterfaceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPortsetInterfaceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPortsetInterfaceGetOK creates a PortsetInterfaceGetOK with default headers values
func NewPortsetInterfaceGetOK() *PortsetInterfaceGetOK {
	return &PortsetInterfaceGetOK{}
}

/*
PortsetInterfaceGetOK describes a response with status code 200, with default header values.

OK
*/
type PortsetInterfaceGetOK struct {
	Payload *models.PortsetInterface
}

// IsSuccess returns true when this portset interface get o k response has a 2xx status code
func (o *PortsetInterfaceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this portset interface get o k response has a 3xx status code
func (o *PortsetInterfaceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this portset interface get o k response has a 4xx status code
func (o *PortsetInterfaceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this portset interface get o k response has a 5xx status code
func (o *PortsetInterfaceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this portset interface get o k response a status code equal to that given
func (o *PortsetInterfaceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the portset interface get o k response
func (o *PortsetInterfaceGetOK) Code() int {
	return 200
}

func (o *PortsetInterfaceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/portsets/{portset.uuid}/interfaces/{uuid}][%d] portsetInterfaceGetOK %s", 200, payload)
}

func (o *PortsetInterfaceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/portsets/{portset.uuid}/interfaces/{uuid}][%d] portsetInterfaceGetOK %s", 200, payload)
}

func (o *PortsetInterfaceGetOK) GetPayload() *models.PortsetInterface {
	return o.Payload
}

func (o *PortsetInterfaceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PortsetInterface)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPortsetInterfaceGetDefault creates a PortsetInterfaceGetDefault with default headers values
func NewPortsetInterfaceGetDefault(code int) *PortsetInterfaceGetDefault {
	return &PortsetInterfaceGetDefault{
		_statusCode: code,
	}
}

/*
	PortsetInterfaceGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The interface is not a member of the portset. |
| 5374908 | The portset specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PortsetInterfaceGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this portset interface get default response has a 2xx status code
func (o *PortsetInterfaceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this portset interface get default response has a 3xx status code
func (o *PortsetInterfaceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this portset interface get default response has a 4xx status code
func (o *PortsetInterfaceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this portset interface get default response has a 5xx status code
func (o *PortsetInterfaceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this portset interface get default response a status code equal to that given
func (o *PortsetInterfaceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the portset interface get default response
func (o *PortsetInterfaceGetDefault) Code() int {
	return o._statusCode
}

func (o *PortsetInterfaceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/portsets/{portset.uuid}/interfaces/{uuid}][%d] portset_interface_get default %s", o._statusCode, payload)
}

func (o *PortsetInterfaceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/portsets/{portset.uuid}/interfaces/{uuid}][%d] portset_interface_get default %s", o._statusCode, payload)
}

func (o *PortsetInterfaceGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PortsetInterfaceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
