// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new s a n API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for s a n API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	FcLoginCollectionGet(params *FcLoginCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcLoginCollectionGetOK, error)

	FcLoginGet(params *FcLoginGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcLoginGetOK, error)

	FcpServiceCollectionGet(params *FcpServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceCollectionGetOK, error)

	FcpServiceCreate(params *FcpServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceCreateCreated, error)

	FcpServiceDelete(params *FcpServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceDeleteOK, error)

	FcpServiceDeleteCollection(params *FcpServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceDeleteCollectionOK, error)

	FcpServiceGet(params *FcpServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceGetOK, error)

	FcpServiceModify(params *FcpServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceModifyOK, error)

	FcpServiceModifyCollection(params *FcpServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceModifyCollectionOK, error)

	IgroupCollectionGet(params *IgroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupCollectionGetOK, error)

	IgroupCreate(params *IgroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupCreateCreated, error)

	IgroupDelete(params *IgroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupDeleteOK, error)

	IgroupDeleteCollection(params *IgroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupDeleteCollectionOK, error)

	IgroupGet(params *IgroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupGetOK, error)

	IgroupInitiatorCollectionGet(params *IgroupInitiatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorCollectionGetOK, error)

	IgroupInitiatorCreate(params *IgroupInitiatorCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorCreateCreated, error)

	IgroupInitiatorDelete(params *IgroupInitiatorDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorDeleteOK, error)

	IgroupInitiatorDeleteCollection(params *IgroupInitiatorDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorDeleteCollectionOK, error)

	IgroupInitiatorGet(params *IgroupInitiatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorGetOK, error)

	IgroupInitiatorModify(params *IgroupInitiatorModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorModifyOK, error)

	IgroupInitiatorModifyCollection(params *IgroupInitiatorModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorModifyCollectionOK, error)

	IgroupModify(params *IgroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupModifyOK, error)

	IgroupModifyCollection(params *IgroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupModifyCollectionOK, error)

	IgroupNestedCollectionGet(params *IgroupNestedCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedCollectionGetOK, error)

	IgroupNestedCreate(params *IgroupNestedCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedCreateCreated, error)

	IgroupNestedDelete(params *IgroupNestedDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedDeleteOK, error)

	IgroupNestedDeleteCollection(params *IgroupNestedDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedDeleteCollectionOK, error)

	IgroupNestedGet(params *IgroupNestedGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedGetOK, error)

	InitiatorCollectionGet(params *InitiatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InitiatorCollectionGetOK, error)

	InitiatorGet(params *InitiatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InitiatorGetOK, error)

	IscsiCredentialsCollectionGet(params *IscsiCredentialsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsCollectionGetOK, error)

	IscsiCredentialsCreate(params *IscsiCredentialsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsCreateCreated, error)

	IscsiCredentialsDelete(params *IscsiCredentialsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsDeleteOK, error)

	IscsiCredentialsDeleteCollection(params *IscsiCredentialsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsDeleteCollectionOK, error)

	IscsiCredentialsGet(params *IscsiCredentialsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsGetOK, error)

	IscsiCredentialsModify(params *IscsiCredentialsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsModifyOK, error)

	IscsiCredentialsModifyCollection(params *IscsiCredentialsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsModifyCollectionOK, error)

	IscsiServiceCollectionGet(params *IscsiServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceCollectionGetOK, error)

	IscsiServiceCreate(params *IscsiServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceCreateCreated, error)

	IscsiServiceDelete(params *IscsiServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceDeleteOK, error)

	IscsiServiceDeleteCollection(params *IscsiServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceDeleteCollectionOK, error)

	IscsiServiceGet(params *IscsiServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceGetOK, error)

	IscsiServiceModify(params *IscsiServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceModifyOK, error)

	IscsiServiceModifyCollection(params *IscsiServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceModifyCollectionOK, error)

	IscsiSessionCollectionGet(params *IscsiSessionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiSessionCollectionGetOK, error)

	IscsiSessionGet(params *IscsiSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiSessionGetOK, error)

	LunAttributeCollectionGet(params *LunAttributeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeCollectionGetOK, error)

	LunAttributeCreate(params *LunAttributeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeCreateCreated, *LunAttributeCreateAccepted, error)

	LunAttributeDelete(params *LunAttributeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeDeleteOK, error)

	LunAttributeDeleteCollection(params *LunAttributeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeDeleteCollectionOK, error)

	LunAttributeGet(params *LunAttributeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeGetOK, error)

	LunAttributeModify(params *LunAttributeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeModifyOK, error)

	LunAttributeModifyCollection(params *LunAttributeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeModifyCollectionOK, error)

	LunCollectionGet(params *LunCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunCollectionGetOK, error)

	LunCreate(params *LunCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunCreateCreated, *LunCreateAccepted, error)

	LunDelete(params *LunDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunDeleteOK, *LunDeleteAccepted, error)

	LunDeleteCollection(params *LunDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunDeleteCollectionOK, *LunDeleteCollectionAccepted, error)

	LunFormDataDelete(params *LunFormDataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataDeleteOK, *LunFormDataDeleteAccepted, error)

	LunFormDataGet(params *LunFormDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataGetOK, error)

	LunFormDataModify(params *LunFormDataModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataModifyOK, *LunFormDataModifyAccepted, error)

	LunGet(params *LunGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunGetOK, error)

	LunMapCollectionGet(params *LunMapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapCollectionGetOK, error)

	LunMapCreate(params *LunMapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapCreateCreated, error)

	LunMapDelete(params *LunMapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapDeleteOK, error)

	LunMapDeleteCollection(params *LunMapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapDeleteCollectionOK, error)

	LunMapGet(params *LunMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapGetOK, error)

	LunMapReportingNodeCollectionGet(params *LunMapReportingNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeCollectionGetOK, error)

	LunMapReportingNodeCreate(params *LunMapReportingNodeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeCreateCreated, error)

	LunMapReportingNodeDelete(params *LunMapReportingNodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeDeleteOK, error)

	LunMapReportingNodeDeleteCollection(params *LunMapReportingNodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeDeleteCollectionOK, error)

	LunMapReportingNodeGet(params *LunMapReportingNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeGetOK, error)

	LunModify(params *LunModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunModifyOK, *LunModifyAccepted, error)

	LunModifyCollection(params *LunModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunModifyCollectionOK, *LunModifyCollectionAccepted, error)

	PerformanceFcpMetricCollectionGet(params *PerformanceFcpMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcpMetricCollectionGetOK, error)

	PerformanceFcpMetricGet(params *PerformanceFcpMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcpMetricGetOK, error)

	PerformanceIscsiMetricCollectionGet(params *PerformanceIscsiMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceIscsiMetricCollectionGetOK, error)

	PerformanceIscsiMetricGet(params *PerformanceIscsiMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceIscsiMetricGetOK, error)

	PerformanceLunMetricCollectionGet(params *PerformanceLunMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceLunMetricCollectionGetOK, error)

	PerformanceLunMetricGet(params *PerformanceLunMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceLunMetricGetOK, error)

	PortsetCollectionGet(params *PortsetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetCollectionGetOK, error)

	PortsetCreate(params *PortsetCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetCreateCreated, error)

	PortsetDelete(params *PortsetDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetDeleteOK, error)

	PortsetDeleteCollection(params *PortsetDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetDeleteCollectionOK, error)

	PortsetGet(params *PortsetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetGetOK, error)

	PortsetInterfaceCollectionGet(params *PortsetInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceCollectionGetOK, error)

	PortsetInterfaceCreate(params *PortsetInterfaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceCreateCreated, error)

	PortsetInterfaceDelete(params *PortsetInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceDeleteOK, error)

	PortsetInterfaceDeleteCollection(params *PortsetInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceDeleteCollectionOK, error)

	PortsetInterfaceGet(params *PortsetInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceGetOK, error)

	StorageUnitCollectionGet(params *StorageUnitCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitCollectionGetOK, error)

	StorageUnitCreate(params *StorageUnitCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitCreateCreated, *StorageUnitCreateAccepted, error)

	StorageUnitGet(params *StorageUnitGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitGetOK, error)

	StorageUnitModify(params *StorageUnitModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitModifyOK, *StorageUnitModifyAccepted, error)

	StorageUnitModifyCollection(params *StorageUnitModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitModifyCollectionOK, *StorageUnitModifyCollectionAccepted, error)

	StorageUnitSnapshotCollectionGet(params *StorageUnitSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotCollectionGetOK, error)

	StorageUnitSnapshotCreate(params *StorageUnitSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotCreateCreated, *StorageUnitSnapshotCreateAccepted, error)

	StorageUnitSnapshotDelete(params *StorageUnitSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotDeleteOK, *StorageUnitSnapshotDeleteAccepted, error)

	StorageUnitSnapshotDeleteCollection(params *StorageUnitSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotDeleteCollectionOK, *StorageUnitSnapshotDeleteCollectionAccepted, error)

	StorageUnitSnapshotGet(params *StorageUnitSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotGetOK, error)

	StorageUnitSnapshotModify(params *StorageUnitSnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotModifyOK, *StorageUnitSnapshotModifyAccepted, error)

	StorageUnitSnapshotModifyCollection(params *StorageUnitSnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotModifyCollectionOK, *StorageUnitSnapshotModifyCollectionAccepted, error)

	VvolBindingCollectionGet(params *VvolBindingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingCollectionGetOK, error)

	VvolBindingCreate(params *VvolBindingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingCreateCreated, error)

	VvolBindingDelete(params *VvolBindingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingDeleteOK, error)

	VvolBindingDeleteCollection(params *VvolBindingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingDeleteCollectionOK, error)

	VvolBindingGet(params *VvolBindingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingGetOK, error)

	WwpnAliasCollectionGet(params *WwpnAliasCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasCollectionGetOK, error)

	WwpnAliasCreate(params *WwpnAliasCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasCreateCreated, error)

	WwpnAliasDelete(params *WwpnAliasDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasDeleteOK, error)

	WwpnAliasDeleteCollection(params *WwpnAliasDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasDeleteCollectionOK, error)

	WwpnAliasGet(params *WwpnAliasGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	FcLoginCollectionGet Retrieves FC logins.

### Related ONTAP commands
* `vserver fcp initiator show`
### Learn more
* SAN: [`DOC /network/fc/logins`](#docs-SAN-network_fc_logins)
* NVMe: [`DOC /network/fc/logins`](#docs-NVMe-network_fc_logins)
*/
func (a *Client) FcLoginCollectionGet(params *FcLoginCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcLoginCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcLoginCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_login_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/logins",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcLoginCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcLoginCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcLoginCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcLoginGet Retrieves an FC login.

### Related ONTAP commands
* `vserver fcp initiator show`
### Learn more
* SAN: [`DOC /network/fc/logins`](#docs-SAN-network_fc_logins)
* NVMe: [`DOC /network/fc/logins`](#docs-NVMe-network_fc_logins)
*/
func (a *Client) FcLoginGet(params *FcLoginGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcLoginGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcLoginGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_login_get",
		Method:             "GET",
		PathPattern:        "/network/fc/logins/{interface.uuid}/{initiator.wwpn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcLoginGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcLoginGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcLoginGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcpServiceCollectionGet Retrieves FC Protocol services.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver fcp show`
### Learn more
* [`DOC /protocols/san/fcp/services`](#docs-SAN-protocols_san_fcp_services)
*/
func (a *Client) FcpServiceCollectionGet(params *FcpServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/fcp/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcpServiceCreate Creates an FC Protocol service.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the FC Protocol service.
### Related ONTAP commands
* `vserver fcp create`
### Learn more
* [`DOC /protocols/san/fcp/services`](#docs-SAN-protocols_san_fcp_services)
*/
func (a *Client) FcpServiceCreate(params *FcpServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/fcp/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcpServiceDelete Deletes an FC Protocol service. An FC Protocol service must be disabled before it can be deleted.

### Related ONTAP commands
* `vserver fcp delete`
### Learn more
* [`DOC /protocols/san/fcp/services`](#docs-SAN-protocols_san_fcp_services)
*/
func (a *Client) FcpServiceDelete(params *FcpServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/fcp/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FcpServiceDeleteCollection fcp service delete collection API
*/
func (a *Client) FcpServiceDeleteCollection(params *FcpServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/fcp/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcpServiceGet Retrieves an FC Protocol service.

### Related ONTAP commands
* `vserver fcp show`
### Learn more
* [`DOC /protocols/san/fcp/services`](#docs-SAN-protocols_san_fcp_services)
*/
func (a *Client) FcpServiceGet(params *FcpServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/fcp/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcpServiceModify Updates an FC Protocol service.

### Related ONTAP commands
* `vserver fcp modify`
* `vserver fcp start`
* `vserver fcp stop`
### Learn more
* [`DOC /protocols/san/fcp/services`](#docs-SAN-protocols_san_fcp_services)
*/
func (a *Client) FcpServiceModify(params *FcpServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/fcp/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FcpServiceModifyCollection fcp service modify collection API
*/
func (a *Client) FcpServiceModifyCollection(params *FcpServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcpServiceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcpServiceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fcp_service_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/fcp/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcpServiceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcpServiceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcpServiceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupCollectionGet Retrieves initiator groups.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connectivity_tracking.*`
* `igroups.*`
* `lun_maps.*`
* `parent_igroups.*`
* `target.*`
### Related ONTAP commands
* `lun igroup show`
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupCollectionGet(params *IgroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupCreate Creates an initiator group.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the initiator group.
* `name` - Name of the initiator group.
* `os_type` - Operating system of the initiator group's initiators.
### Recommended optional properties
* `initiators.name` - Name(s) of initiator group's initiators. This property can be used to create the initiator group and populate it with initiators in a single request.
### Default property values
If not specified in POST, the following default property values are assigned.
* `protocol` - _mixed_ - Data protocol of the initiator group's initiators.
### Related ONTAP commands
* `lun igroup create`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupCreate(params *IgroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupDelete Deletes an initiator group.

### Related ONTAP commands
* `lun igroup delete`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupDelete(params *IgroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IgroupDeleteCollection igroup delete collection API
*/
func (a *Client) IgroupDeleteCollection(params *IgroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupGet Retrieves an initiator group.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connectivity_tracking.*`
* `igroups.*`
* `lun_maps.*`
* `parent_igroups.*`
### Related ONTAP commands
* `lun igroup show`
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupGet(params *IgroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupInitiatorCollectionGet Retrieves initiators of an initiator group.<br/>

This API only reports initiators owned directly by the initiator group. Initiators of nested initiator groups are not included in this collection.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connectivity_tracking.*`
### Related ONTAP commands
* `lun igroup show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupInitiatorCollectionGet(params *IgroupInitiatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupInitiatorCreate Adds one or more initiators to an initiator group.<br/>

This API does not support adding initiators to an initiator group that already contains nested initiator groups.
### Required properties
* `name` or `records.name` - Initiator name(s) to add to the initiator group.
### Related ONTAP commands
* `lun igroup add`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupInitiatorCreate(params *IgroupInitiatorCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupInitiatorDelete Deletes an initiator from an initiator group.<br/>

This API only supports removal of initiators owned directly by the initiator group. Initiators of nested initiator groups must be removed on the initiator group that directly owns the initiator.
### Related ONTAP commands
* `lun igroup remove`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupInitiatorDelete(params *IgroupInitiatorDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IgroupInitiatorDeleteCollection igroup initiator delete collection API
*/
func (a *Client) IgroupInitiatorDeleteCollection(params *IgroupInitiatorDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupInitiatorGet Retrieves an initiator of an initiator group.<br/>

This API only reports initiators owned directly by the initiator group. Initiators of nested initiator groups are not part of this collection.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connectivity_tracking.*`
### Related ONTAP commands
* `lun igroup show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupInitiatorGet(params *IgroupInitiatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupInitiatorModify Updates an initiator of an initiator group.<br/>

This API only supports modification of initiators owned directly by the initiator group. Initiators of nested initiator groups must be modified on the initiator group that directly owns the initiator.
### Related ONTAP commands
* `lun igroup initiator modify`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupInitiatorModify(params *IgroupInitiatorModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IgroupInitiatorModifyCollection igroup initiator modify collection API
*/
func (a *Client) IgroupInitiatorModifyCollection(params *IgroupInitiatorModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupInitiatorModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupInitiatorModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_initiator_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/initiators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupInitiatorModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupInitiatorModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupInitiatorModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupModify Updates an initiator group.

### Related ONTAP commands
* `lun igroup modify`
* `lun igroup rename`
* `lun igroup bind`
* `lun igroup unbind`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupModify(params *IgroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/igroups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IgroupModifyCollection igroup modify collection API
*/
func (a *Client) IgroupModifyCollection(params *IgroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupNestedCollectionGet Retrieves nested initiator groups of an initiator group.<br/>

This API only reports the nested initiator groups that are direct children of the initiator group. Further nested initiator groups are reported by their direct parent initiator group.
### Related ONTAP commands
* `lun igroup show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupNestedCollectionGet(params *IgroupNestedCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupNestedCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_nested_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupNestedCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupNestedCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupNestedCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupNestedCreate Adds one or more nested initiator groups to an initiator group. A single nested initiator group can be added by directly specifying the name or UUID. Multiple nested initiator groups can be added by specifying the names or UUIDs in the records array. Nested initiator groups cannot be added to an initiator group that already directly contains initiators.

### Required properties
* `name` and/or `uuid` or `records` - Nested initiator groups to add to the initiator group.
### Related ONTAP commands
* `lun igroup add`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupNestedCreate(params *IgroupNestedCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupNestedCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_nested_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupNestedCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupNestedCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupNestedCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupNestedDelete Removes a nested initiator group from an initiator group. This API does not delete the nested initiator group itself. It removes the relationship between a parent and child initiator group.<br/>

This API only supports removal of initiator groups owned directly by the initiator group. Further nested initiator groups must be removed from the direct parent initiator group.
### Related ONTAP commands
* `lun igroup remove`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupNestedDelete(params *IgroupNestedDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupNestedDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_nested_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/igroups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupNestedDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupNestedDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupNestedDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IgroupNestedDeleteCollection igroup nested delete collection API
*/
func (a *Client) IgroupNestedDeleteCollection(params *IgroupNestedDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupNestedDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_nested_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/igroups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupNestedDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupNestedDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupNestedDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IgroupNestedGet Retrieves a nested initiator group of an initiator group.<br/>

This API only reports the nested initiator groups that are direct children of the initiator group. Further nested initiator groups are reported by their direct parent initiator group.
### Related ONTAP commands
* `lun igroup show`
### Learn more
* [`DOC /protocols/san/igroups`](#docs-SAN-protocols_san_igroups)
*/
func (a *Client) IgroupNestedGet(params *IgroupNestedGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IgroupNestedGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIgroupNestedGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "igroup_nested_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/igroups/{igroup.uuid}/igroups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IgroupNestedGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IgroupNestedGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IgroupNestedGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	InitiatorCollectionGet Retrieves initiators.

### Related ONTAP commands
* `lun igroup initiator show`
### Learn more
* [`DOC /protocols/san/initiators`](#docs-SAN-protocols_san_initiators)
*/
func (a *Client) InitiatorCollectionGet(params *InitiatorCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InitiatorCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInitiatorCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "initiator_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/initiators",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &InitiatorCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InitiatorCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InitiatorCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	InitiatorGet Retrieves an initiator.

### Related ONTAP commands
* `lun igroup initiator show`
### Learn more
* [`DOC /protocols/san/initiators`](#docs-SAN-protocols_san_initiators)
*/
func (a *Client) InitiatorGet(params *InitiatorGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InitiatorGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInitiatorGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "initiator_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/initiators/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &InitiatorGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InitiatorGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InitiatorGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiCredentialsCollectionGet Retrieves iSCSI credentials.

### Related ONTAP commands
* `vserver iscsi security show`
### Learn more
* [`DOC /protocols/san/iscsi/credentials`](#docs-SAN-protocols_san_iscsi_credentials)
*/
func (a *Client) IscsiCredentialsCollectionGet(params *IscsiCredentialsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiCredentialsCreate Creates iSCSI credentials.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the iSCSI credentials.
* `initiator` - Initiator for which the iSCSI credentials are to be created.
* `authentication_type` - Type of authentication to use for the credentials.
### Recommended optional properties
* `chap.inbound.user` - In-bound CHAP authentication user name.
* `chap.inbound.password` - In-bound CHAP authentication password.
* `chap.outbound.user` - Out-bound CHAP authentication user name.
* `chap.outbound.password` - Out-bound CHAP authentication password.
### Related ONTAP commands
* `vserver iscsi security create`
### Learn more
* [`DOC /protocols/san/iscsi/credentials`](#docs-SAN-protocols_san_iscsi_credentials)
*/
func (a *Client) IscsiCredentialsCreate(params *IscsiCredentialsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/iscsi/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiCredentialsDelete Deletes specified iSCSI credentials.

### Related ONTAP commands
* `vserver iscsi security delete`
### Learn more
* [`DOC /protocols/san/iscsi/credentials`](#docs-SAN-protocols_san_iscsi_credentials)
*/
func (a *Client) IscsiCredentialsDelete(params *IscsiCredentialsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/iscsi/credentials/{svm.uuid}/{initiator}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IscsiCredentialsDeleteCollection iscsi credentials delete collection API
*/
func (a *Client) IscsiCredentialsDeleteCollection(params *IscsiCredentialsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/iscsi/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiCredentialsGet Retrieves specified iSCSI credentials.

### Related ONTAP commands
* `vserver iscsi security show`
### Learn more
* [`DOC /protocols/san/iscsi/credentials`](#docs-SAN-protocols_san_iscsi_credentials)
*/
func (a *Client) IscsiCredentialsGet(params *IscsiCredentialsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/credentials/{svm.uuid}/{initiator}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiCredentialsModify Updates specified iSCSI credentials.

### Related ONTAP commands
* `vserver iscsi security add-initiator-address-ranges`
* `vserver iscsi security default`
* `vserver iscsi security modify`
* `vserver iscsi security remove-initiator-address-ranges`
### Learn more
* [`DOC /protocols/san/iscsi/credentials`](#docs-SAN-protocols_san_iscsi_credentials)
*/
func (a *Client) IscsiCredentialsModify(params *IscsiCredentialsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/iscsi/credentials/{svm.uuid}/{initiator}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IscsiCredentialsModifyCollection iscsi credentials modify collection API
*/
func (a *Client) IscsiCredentialsModifyCollection(params *IscsiCredentialsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiCredentialsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiCredentialsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_credentials_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/iscsi/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiCredentialsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiCredentialsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiCredentialsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiServiceCollectionGet Retrieves iSCSI services.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver iscsi show`
### Learn more
* [`DOC /protocols/san/iscsi/services`](#docs-SAN-protocols_san_iscsi_services)
*/
func (a *Client) IscsiServiceCollectionGet(params *IscsiServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiServiceCreate Creates an iSCSI service.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the iSCSI service.
### Related ONTAP commands
* `vserver iscsi create`
### Learn more
* [`DOC /protocols/san/iscsi/services`](#docs-SAN-protocols_san_iscsi_services)
*/
func (a *Client) IscsiServiceCreate(params *IscsiServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/iscsi/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiServiceDelete Deletes an iSCSI service. An iSCSI service must be disabled before it can be deleted.

### Related ONTAP commands
* `vserver iscsi delete`
### Learn more
* [`DOC /protocols/san/iscsi/services`](#docs-SAN-protocols_san_iscsi_services)
*/
func (a *Client) IscsiServiceDelete(params *IscsiServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/iscsi/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IscsiServiceDeleteCollection iscsi service delete collection API
*/
func (a *Client) IscsiServiceDeleteCollection(params *IscsiServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/iscsi/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiServiceGet Retrieves an iSCSI service.

### Related ONTAP commands
* `vserver iscsi show`
### Learn more
* [`DOC /protocols/san/iscsi/services`](#docs-SAN-protocols_san_iscsi_services)
*/
func (a *Client) IscsiServiceGet(params *IscsiServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiServiceModify Updates an iSCSI service.

### Related ONTAP commands
* `vserver iscsi modify`
* `vserver iscsi start`
* `vserver iscsi stop`
### Learn more
* [`DOC /protocols/san/iscsi/services`](#docs-SAN-protocols_san_iscsi_services)
*/
func (a *Client) IscsiServiceModify(params *IscsiServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/iscsi/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IscsiServiceModifyCollection iscsi service modify collection API
*/
func (a *Client) IscsiServiceModifyCollection(params *IscsiServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiServiceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiServiceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_service_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/san/iscsi/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiServiceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiServiceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiServiceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiSessionCollectionGet Retrieves iSCSI sessions.

### Related ONTAP commands
* `vserver iscsi connection show`
* `vserver iscsi session parameter show`
* `vserver iscsi session show`
### Learn more
* [`DOC /protocols/san/iscsi/sessions`](#docs-SAN-protocols_san_iscsi_sessions)
*/
func (a *Client) IscsiSessionCollectionGet(params *IscsiSessionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiSessionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiSessionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_session_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/sessions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiSessionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiSessionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiSessionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IscsiSessionGet Retrieves an iSCSI session.

### Related ONTAP commands
* `vserver iscsi connection show`
* `vserver iscsi session parameter show`
* `vserver iscsi session show`
### Learn more
* [`DOC /protocols/san/iscsi/sessions`](#docs-SAN-protocols_san_iscsi_sessions)
*/
func (a *Client) IscsiSessionGet(params *IscsiSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IscsiSessionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIscsiSessionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "iscsi_session_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/sessions/{svm.uuid}/{tpgroup}/{tsih}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IscsiSessionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IscsiSessionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IscsiSessionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunAttributeCollectionGet Retrieves LUN attributes.

### Learn more
* [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes)
*/
func (a *Client) LunAttributeCollectionGet(params *LunAttributeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunAttributeCreate Adds an attribute to a LUN.

### Required properties
* `name` - The name of the attribute to add.
* `value` - The value of the attribute to add.
### Learn more
* [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes)
*/
func (a *Client) LunAttributeCreate(params *LunAttributeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeCreateCreated, *LunAttributeCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_create",
		Method:             "POST",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunAttributeCreateCreated:
		return value, nil, nil
	case *LunAttributeCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunAttributeDelete Deletes a LUN attribute.

### Learn more
* [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes)
*/
func (a *Client) LunAttributeDelete(params *LunAttributeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunAttributeDeleteCollection lun attribute delete collection API
*/
func (a *Client) LunAttributeDeleteCollection(params *LunAttributeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunAttributeGet Retrieves a LUN attribute.

### Learn more
* [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes)
*/
func (a *Client) LunAttributeGet(params *LunAttributeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_get",
		Method:             "GET",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunAttributeModify Updates a LUN attribute value.

### Learn more
* [`DOC /storage/luns/{lun.uuid}/attributes`](#docs-SAN-storage_luns_{lun.uuid}_attributes)
*/
func (a *Client) LunAttributeModify(params *LunAttributeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunAttributeModifyCollection lun attribute modify collection API
*/
func (a *Client) LunAttributeModifyCollection(params *LunAttributeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunAttributeModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunAttributeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_attribute_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/luns/{lun.uuid}/attributes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunAttributeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunAttributeModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunAttributeModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunCollectionGet Retrieves LUNs.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `attributes.*`
* `auto_delete`
* `copy.*`
* `lun_maps.*`
* `movement.*`
* `space.physical_used`
* `space.physical_used_by_snapshots`
* `space.efficiency_ratio`
* `space.snapshot.*`
* `statistics.*`
* `vvol.bindings.*`
* `metric.*`
### Related ONTAP commands
* `lun bind show`
* `lun copy show`
* `lun mapping show`
* `lun move show`
* `lun show`
* `volume file clone show-autodelete`
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunCollectionGet(params *LunCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/luns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunCreate Creates a LUN.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the LUN.
* `name`, `location.volume.name` or `location.volume.uuid` - Existing volume in which to create the LUN.
* `name` or `location.logical_unit` - Base name of the LUN.
* `os_type` - Operating system from which the LUN will be accessed. Required when creating a non-clone LUN and disallowed when creating a clone of an existing LUN. A clone's `os_type` is taken from the source LUN.
* `space.size` - Size of the LUN. Required when creating a non-clone LUN and disallowed when creating a clone of an existing LUN. A clone's size is taken from the source LUN.
### Recommended optional properties
* `qos_policy.name` or `qos_policy.uuid` - Existing traditional or adaptive QoS policy to be applied to the LUN. All LUNs should be managed by a QoS policy at the volume or LUN level.
### Default property values
If not specified in POST, the follow default property values are assigned.
* `auto_delete` - _false_
### Related ONTAP commands
* `lun create`
* `lun convert-from-namespace`
* `lun copy start`
* `volume file clone autodelete`
* `volume file clone create`
<personalities supports=asar2>
The `name` property is required when creating a new LUN. The name must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 203 characters or less in length. The `location` properties are not supported.
</personalities>
POST is asynchronous when creating a new LUN. It is synchronous when converting a namespace to a LUN via the `convert` property.
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunCreate(params *LunCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunCreateCreated, *LunCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_create",
		Method:             "POST",
		PathPattern:        "/storage/luns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunCreateCreated:
		return value, nil, nil
	case *LunCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunDelete Deletes a LUN.

### Related ONTAP commands
* `lun copy cancel`
* `lun delete`
<personalities supports=asar2>
DELETE is asynchronous.
</personalities>
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunDelete(params *LunDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunDeleteOK, *LunDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/luns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunDeleteOK:
		return value, nil, nil
	case *LunDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunDeleteCollection lun delete collection API
*/
func (a *Client) LunDeleteCollection(params *LunDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunDeleteCollectionOK, *LunDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/luns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunDeleteCollectionOK:
		return value, nil, nil
	case *LunDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunFormDataDelete Deletes a LUN.

### Related ONTAP commands
* `lun copy cancel`
* `lun delete`
<personalities supports=asar2>
DELETE is asynchronous.
</personalities>
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunFormDataDelete(params *LunFormDataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataDeleteOK, *LunFormDataDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunFormDataDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_form_data_delete",
		Method:             "DELETE",
		PathPattern:        "//storage/luns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunFormDataDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunFormDataDeleteOK:
		return value, nil, nil
	case *LunFormDataDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunFormDataDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunFormDataGet Retrieves a LUN's properties or a LUN's data.<br/>

LUN data read requests are distinguished by the header entry `Accept: multipart/form-data`. When this header entry is provided, query parameters `data.offset` and `data.size` are required and used to specify the portion of the LUN's data to read; no other query parameters are allowed. Reads are limited to one megabyte (1MB) per request. Data is returned as `multipart/form-data` content with exactly one form entry containing the data. The form entry has content type `application/octet-stream`.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `attributes.*`
* `auto_delete`
* `copy.*`
* `lun_maps.*`
* `movement.*`
* `space.physical_used`
* `space.physical_used_by_snapshots`
* `space.efficiency_ratio`
* `space.snapshot.*`
* `statistics.*`
* `vvol.bindings.*`
* `metric.*`
### Related ONTAP commands
* `lun bind show`
* `lun copy show`
* `lun mapping show`
* `lun move show`
* `lun show`
* `volume file clone show-autodelete`
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunFormDataGet(params *LunFormDataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunFormDataGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_form_data_get",
		Method:             "GET",
		PathPattern:        "//storage/luns/{uuid}",
		ProducesMediaTypes: []string{"multipart/form-data"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunFormDataGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunFormDataGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunFormDataGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunFormDataModify Updates an existing LUN in one of several ways:

- Updates the properties of a LUN.
- Writes data to a LUN. LUN data write requests are distinguished by the header entry `Content-Type: multipart/form-data`. When this header entry is provided, query parameter `data.offset` is required and used to specify the location within the LUN at which to write the data; no other query parameters are allowed. The request body must be `multipart/form-data` content with exactly one form entry containing the data to write. The content type entry of the form data is ignored and always treated as `application/octet-stream`. Writes are limited to one megabyte (1MB) per request.
- Overwrites the contents of a LUN as a clone of another.
- Begins the movement of a LUN between volumes. PATCH can also pause and resume the movement of a LUN between volumes that is already in active.
### Related ONTAP commands
* `lun copy modify`
* `lun copy pause`
* `lun copy resume`
* `lun modify`
* `lun move-in-volume`
* `lun move modify`
* `lun move pause`
* `lun move resume`
* `lun move start`
* `lun resize`
* `volume file clone autodelete`
<personalities supports=asar2>
PATCH is asynchronous when modifying `name` or `qos_policy`.
</personalities>
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunFormDataModify(params *LunFormDataModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunFormDataModifyOK, *LunFormDataModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunFormDataModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_form_data_modify",
		Method:             "PATCH",
		PathPattern:        "//storage/luns/{uuid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunFormDataModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunFormDataModifyOK:
		return value, nil, nil
	case *LunFormDataModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunFormDataModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunGet Retrieves a LUN's properties or a LUN's data.<br/>

LUN data read requests are distinguished by the header entry `Accept: multipart/form-data`. When this header entry is provided, query parameters `data.offset` and `data.size` are required and used to specify the portion of the LUN's data to read; no other query parameters are allowed. Reads are limited to one megabyte (1MB) per request. Data is returned as `multipart/form-data` content with exactly one form entry containing the data. The form entry has content type `application/octet-stream`.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `attributes.*`
* `auto_delete`
* `copy.*`
* `lun_maps.*`
* `movement.*`
* `space.physical_used`
* `space.physical_used_by_snapshots`
* `space.efficiency_ratio`
* `space.snapshot.*`
* `statistics.*`
* `vvol.bindings.*`
* `metric.*`
### Related ONTAP commands
* `lun bind show`
* `lun copy show`
* `lun mapping show`
* `lun move show`
* `lun show`
* `volume file clone show-autodelete`
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunGet(params *LunGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_get",
		Method:             "GET",
		PathPattern:        "/storage/luns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json", "multipart/form-data"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapCollectionGet Retrieves LUN maps.

### Related ONTAP commands
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/lun-maps`](#docs-SAN-protocols_san_lun-maps)
*/
func (a *Client) LunMapCollectionGet(params *LunMapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/lun-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapCreate Creates a LUN map.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the LUN map.
* `igroup.uuid` or `igroup.name` - Existing initiator group to map to the specified LUN.
* `lun.uuid` or `lun.name` - Existing LUN to map to the specified initiator group.
### Default property values
If not specified in POST, the following default property values are assigned.
* `logical_unit_number` - If no value is provided, ONTAP assigns the lowest available value.
### Related ONTAP commands
* `lun mapping create`
### Learn more
* [`DOC /protocols/san/lun-maps`](#docs-SAN-protocols_san_lun-maps)
*/
func (a *Client) LunMapCreate(params *LunMapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/lun-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapDelete Deletes a LUN map.

### Related ONTAP commands
* `lun mapping delete`
### Learn more
* [`DOC /protocols/san/lun-maps`](#docs-SAN-protocols_san_lun-maps)
*/
func (a *Client) LunMapDelete(params *LunMapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunMapDeleteCollection lun map delete collection API
*/
func (a *Client) LunMapDeleteCollection(params *LunMapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/lun-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapGet Retrieves a LUN map.

### Related ONTAP commands
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/lun-maps`](#docs-SAN-protocols_san_lun-maps)
*/
func (a *Client) LunMapGet(params *LunMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapReportingNodeCollectionGet Retrieves LUN map reporting nodes.

### Related ONTAP commands
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes`](#docs-SAN-protocols_san_lun-maps_{lun.uuid}_{igroup.uuid}_reporting-nodes)
*/
func (a *Client) LunMapReportingNodeCollectionGet(params *LunMapReportingNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapReportingNodeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_reporting_node_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapReportingNodeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapReportingNodeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapReportingNodeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapReportingNodeCreate Adds a reporting node and its HA partner to a LUN map.

### Required properties
* `uuid` or `name` - A cluster node to add.
### Related ONTAP commands
* `lun mapping add-reporting-nodes`
### Learn more
* [`DOC /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes`](#docs-SAN-protocols_san_lun-maps_{lun.uuid}_{igroup.uuid}_reporting-nodes)
*/
func (a *Client) LunMapReportingNodeCreate(params *LunMapReportingNodeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapReportingNodeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_reporting_node_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapReportingNodeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapReportingNodeCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapReportingNodeCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapReportingNodeDelete Removes a reporting node and its HA partner from a LUN map.

### Related ONTAP commands
* `lun mapping remove-reporting-nodes`
### Learn more
* [`DOC /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes`](#docs-SAN-protocols_san_lun-maps_{lun.uuid}_{igroup.uuid}_reporting-nodes)
*/
func (a *Client) LunMapReportingNodeDelete(params *LunMapReportingNodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapReportingNodeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_reporting_node_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapReportingNodeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapReportingNodeDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapReportingNodeDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunMapReportingNodeDeleteCollection lun map reporting node delete collection API
*/
func (a *Client) LunMapReportingNodeDeleteCollection(params *LunMapReportingNodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapReportingNodeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_reporting_node_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapReportingNodeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapReportingNodeDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapReportingNodeDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunMapReportingNodeGet Retrieves a LUN map reporting node.

### Related ONTAP commands
* `lun mapping show`
### Learn more
* [`DOC /protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes`](#docs-SAN-protocols_san_lun-maps_{lun.uuid}_{igroup.uuid}_reporting-nodes)
*/
func (a *Client) LunMapReportingNodeGet(params *LunMapReportingNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunMapReportingNodeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunMapReportingNodeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_map_reporting_node_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/lun-maps/{lun.uuid}/{igroup.uuid}/reporting-nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunMapReportingNodeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LunMapReportingNodeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunMapReportingNodeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LunModify Updates an existing LUN in one of several ways:

- Updates the properties of a LUN.
- Writes data to a LUN. LUN data write requests are distinguished by the header entry `Content-Type: multipart/form-data`. When this header entry is provided, query parameter `data.offset` is required and used to specify the location within the LUN at which to write the data; no other query parameters are allowed. The request body must be `multipart/form-data` content with exactly one form entry containing the data to write. The content type entry of the form data is ignored and always treated as `application/octet-stream`. Writes are limited to one megabyte (1MB) per request.
- Overwrites the contents of a LUN as a clone of another.
- Begins the movement of a LUN between volumes. PATCH can also pause and resume the movement of a LUN between volumes that is already in active.
### Related ONTAP commands
* `lun copy modify`
* `lun copy pause`
* `lun copy resume`
* `lun modify`
* `lun move-in-volume`
* `lun move modify`
* `lun move pause`
* `lun move resume`
* `lun move start`
* `lun resize`
* `volume file clone autodelete`
<personalities supports=asar2>
PATCH is asynchronous when modifying `name` or `qos_policy`.
</personalities>
### Learn more
* [`DOC /storage/luns`](#docs-SAN-storage_luns)
*/
func (a *Client) LunModify(params *LunModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunModifyOK, *LunModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/luns/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunModifyOK:
		return value, nil, nil
	case *LunModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LunModifyCollection lun modify collection API
*/
func (a *Client) LunModifyCollection(params *LunModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LunModifyCollectionOK, *LunModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLunModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "lun_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/luns",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LunModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LunModifyCollectionOK:
		return value, nil, nil
	case *LunModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LunModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcpMetricCollectionGet Retrieves historical performance metrics for the FC Protocol service of an SVM.
*/
func (a *Client) PerformanceFcpMetricCollectionGet(params *PerformanceFcpMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcpMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcpMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fcp_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/fcp/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcpMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcpMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcpMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcpMetricGet Retrieves historical performance metrics for the FC Protocol service of an SVM for a specific time.
*/
func (a *Client) PerformanceFcpMetricGet(params *PerformanceFcpMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcpMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcpMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fcp_metric_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/fcp/services/{svm.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcpMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcpMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcpMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceIscsiMetricCollectionGet Retrieves historical performance metrics for the iSCSI protocol service of an SVM.
*/
func (a *Client) PerformanceIscsiMetricCollectionGet(params *PerformanceIscsiMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceIscsiMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceIscsiMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_iscsi_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceIscsiMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceIscsiMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceIscsiMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceIscsiMetricGet Retrieves historical performance metrics for the iSCSI protocol service of an SVM for a specific time.
*/
func (a *Client) PerformanceIscsiMetricGet(params *PerformanceIscsiMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceIscsiMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceIscsiMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_iscsi_metric_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/iscsi/services/{svm.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceIscsiMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceIscsiMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceIscsiMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceLunMetricCollectionGet Retrieves historical space and performance metrics for a LUN.
*/
func (a *Client) PerformanceLunMetricCollectionGet(params *PerformanceLunMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceLunMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceLunMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_lun_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/luns/{lun.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceLunMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceLunMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceLunMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceLunMetricGet Retrieves historical space and performance metrics for a LUN for a specific time.
*/
func (a *Client) PerformanceLunMetricGet(params *PerformanceLunMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceLunMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceLunMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_lun_metric_get",
		Method:             "GET",
		PathPattern:        "/storage/luns/{lun.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceLunMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceLunMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceLunMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetCollectionGet Retrieves portsets.

### Related ONTAP commands
* `lun portset show`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetCollectionGet(params *PortsetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/portsets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetCreate Creates a portset.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the portset.
* `name` - Name of the portset.
### Recommended optional properties
* `protocol` - The network protocol of the interfaces in the portset.
* `interfaces` - Network interfaces to include in the portset. This property can be used to create the portset and populate it with network interfaces in a single request.
### Default property values
If not specified in POST, the following default property values are assigned.
* `protocol` - _mixed_ - Data protocol of the portset's network interfaces.
### Related ONTAP commands
* `lun portset create`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetCreate(params *PortsetCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/portsets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetDelete Deletes a portset.

### Related ONTAP commands
* `lun portset delete`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetDelete(params *PortsetDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/portsets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PortsetDeleteCollection portset delete collection API
*/
func (a *Client) PortsetDeleteCollection(params *PortsetDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/portsets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetGet Retrieves a portset.

### Related ONTAP commands
* `lun portset show`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetGet(params *PortsetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/portsets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetInterfaceCollectionGet Retrieves interfaces of a portset.

### Related ONTAP commands
* `lun portset show`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetInterfaceCollectionGet(params *PortsetInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetInterfaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_interface_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/portsets/{portset.uuid}/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetInterfaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetInterfaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetInterfaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetInterfaceCreate Adds one or more interfaces to a portset.

### Required properties
* `fc`, `ip` or `records` - Network interface(s) to add to the portset.
### Related ONTAP commands
* `lun portset add`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetInterfaceCreate(params *PortsetInterfaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetInterfaceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_interface_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/portsets/{portset.uuid}/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetInterfaceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetInterfaceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetInterfaceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetInterfaceDelete Deletes a network interface from a portset.

### Related ONTAP commands
* `lun portset remove`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetInterfaceDelete(params *PortsetInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetInterfaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_interface_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/portsets/{portset.uuid}/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetInterfaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetInterfaceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetInterfaceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PortsetInterfaceDeleteCollection portset interface delete collection API
*/
func (a *Client) PortsetInterfaceDeleteCollection(params *PortsetInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetInterfaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_interface_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/portsets/{portset.uuid}/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetInterfaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetInterfaceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetInterfaceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PortsetInterfaceGet Retrieves a network interface of a portset.

### Related ONTAP commands
* `lun portset show`
### Learn more
* [`DOC /protocols/san/portsets`](#docs-SAN-protocols_san_portsets)
*/
func (a *Client) PortsetInterfaceGet(params *PortsetInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortsetInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortsetInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "portset_interface_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/portsets/{portset.uuid}/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortsetInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortsetInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortsetInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitCollectionGet Retrieves storage units.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `clone.inherited_physical_used`
* `clone.inherited_savings`
* `clone.match_source_storage_tier`
* `clone.source.snapshot.name`
* `clone.source.snapshot.uuid`
* `clone.split_complete_percent`
* `clone.split_estimate`
* `clone.split_initiated`
* `maps.*`
* `metric.*`
* `movement.percent_complete`
* `movement.start_time`
* `movement.state`
* `space.physical_used_by_snapshots`
* `space.physical_used`
* `space.snapshot.*`
* `statistics.*`
### Learn more
* [`DOC /storage/storage-units`](#docs-SAN-storage_storage-units)
*/
func (a *Client) StorageUnitCollectionGet(params *StorageUnitCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/storage-units",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitCreate Creates a storage unit.<br/>

A storage unit can only be directly created as a clone of an existing storage unit. To create a new storage unit that is not a clone of another, use /api/storage/luns or /api/storage/namespaces.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the storage unit.
* `name` - The name of the storage unit.
* `clone` - Identifiers of the parent storage unit or storage unit snapshot from which to clone a new storage unit.
### Learn more
* [`DOC /storage/storage-units`](#docs-SAN-storage_storage-units)
*/
func (a *Client) StorageUnitCreate(params *StorageUnitCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitCreateCreated, *StorageUnitCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_create",
		Method:             "POST",
		PathPattern:        "/storage/storage-units",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitCreateCreated:
		return value, nil, nil
	case *StorageUnitCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitGet Retrieves a storage unit's properties.<br/>

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `clone.inherited_physical_used`
* `clone.inherited_savings`
* `clone.match_source_storage_tier`
* `clone.source.snapshot.name`
* `clone.source.snapshot.uuid`
* `clone.split_complete_percent`
* `clone.split_estimate`
* `clone.split_initiated`
* `maps.*`
* `metric.*`
* `movement.percent_complete`
* `movement.start_time`
* `movement.state`
* `space.physical_used_by_snapshots`
* `space.physical_used`
* `space.snapshot.*`
* `statistics.*`
### Learn more
* [`DOC /storage/storage-units`](#docs-SAN-storage_storage-units)
*/
func (a *Client) StorageUnitGet(params *StorageUnitGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_get",
		Method:             "GET",
		PathPattern:        "/storage/storage-units/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitModify Modify an existing storage unit.<br/>

Storage unit modification supports the following:
* `restore_to` - Restores the storage unit to a prior snapshot. These properties are specified in the query.
* `clone.split_initiated` - Initiates a clone split operation.
### Learn more
* [`DOC /storage/storage-units`](#docs-SAN-storage_storage-units)
*/
func (a *Client) StorageUnitModify(params *StorageUnitModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitModifyOK, *StorageUnitModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/storage-units/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitModifyOK:
		return value, nil, nil
	case *StorageUnitModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitModifyCollection storage unit modify collection API
*/
func (a *Client) StorageUnitModifyCollection(params *StorageUnitModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitModifyCollectionOK, *StorageUnitModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/storage-units",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitModifyCollectionOK:
		return value, nil, nil
	case *StorageUnitModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitSnapshotCollectionGet Retrieves the collection of volume snapshots.

### Expensive properties
There is an added computational cost to retrieving the amount of reclaimable space for snapshots, as the calculation is done on demand based on the list of snapshots provided.
* `reclaimable_space`
* `delta`
### Learn more
* [`DOC /storage/storage-units/{storage_unit.uuid}/snapshots`](#docs-SAN-storage_storage-units_{storage_unit.uuid}_snapshots)
*/
func (a *Client) StorageUnitSnapshotCollectionGet(params *StorageUnitSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitSnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitSnapshotCreate Creates a storage unit snapshot.

### Required properties
* `name` - Name of the snapshot to be created.
### Recommended optional properties
* `comment` - Comment associated with the snapshot.
* `expiry_time` - Snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
* `snapmirror_label` - Label for SnapMirror operations.
* `snaplock_expiry_time` - Expiry time for snapshot locking enabled volumes.
### Learn more
* [`DOC /storage/storage-units/{storage_unit.uuid}/snapshots`](#docs-SAN-storage_storage-units_{storage_unit.uuid}_snapshots)
*/
func (a *Client) StorageUnitSnapshotCreate(params *StorageUnitSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotCreateCreated, *StorageUnitSnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_create",
		Method:             "POST",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitSnapshotCreateCreated:
		return value, nil, nil
	case *StorageUnitSnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitSnapshotDelete Deletes a storage unit snapshot.

### Learn more
* [`DOC /storage/storage-units/{storage_unit.uuid}/snapshots`](#docs-SAN-storage_storage-units_{storage_unit.uuid}_snapshots)
*/
func (a *Client) StorageUnitSnapshotDelete(params *StorageUnitSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotDeleteOK, *StorageUnitSnapshotDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitSnapshotDeleteOK:
		return value, nil, nil
	case *StorageUnitSnapshotDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitSnapshotDeleteCollection storage unit snapshot delete collection API
*/
func (a *Client) StorageUnitSnapshotDeleteCollection(params *StorageUnitSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotDeleteCollectionOK, *StorageUnitSnapshotDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitSnapshotDeleteCollectionOK:
		return value, nil, nil
	case *StorageUnitSnapshotDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitSnapshotGet Retrieves details of a specific storage unit snapshot.

### Learn more
* [`DOC /storage/storage-units/{storage_unit.uuid}/snapshots`](#docs-SAN-storage_storage-units_{storage_unit.uuid}_snapshots)
*/
func (a *Client) StorageUnitSnapshotGet(params *StorageUnitSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_get",
		Method:             "GET",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitSnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	StorageUnitSnapshotModify Updates a storage unit snapshot.

### Learn more
* [`DOC /storage/storage-units/{storage_unit.uuid}/snapshots`](#docs-SAN-storage_storage-units_{storage_unit.uuid}_snapshots)
*/
func (a *Client) StorageUnitSnapshotModify(params *StorageUnitSnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotModifyOK, *StorageUnitSnapshotModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitSnapshotModifyOK:
		return value, nil, nil
	case *StorageUnitSnapshotModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitSnapshotModifyCollection storage unit snapshot modify collection API
*/
func (a *Client) StorageUnitSnapshotModifyCollection(params *StorageUnitSnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitSnapshotModifyCollectionOK, *StorageUnitSnapshotModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitSnapshotModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_snapshot_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/storage-units/{storage_unit.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitSnapshotModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitSnapshotModifyCollectionOK:
		return value, nil, nil
	case *StorageUnitSnapshotModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitSnapshotModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VvolBindingCollectionGet Retrieves vVol bindings.

### Related ONTAP commands
* `lun bind show`
* [`DOC /protocols/san/vvol-bindings`](#docs-SAN-protocols_san_vvol-bindings)
*/
func (a *Client) VvolBindingCollectionGet(params *VvolBindingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVvolBindingCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vvol_binding_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/vvol-bindings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VvolBindingCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VvolBindingCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VvolBindingCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VvolBindingCreate Creates a vVol binding. The binding between any two specific LUNs is reference counted. When a binding is created that already exists, the binding count is incremented.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the vVol binding.
* `protocol_endpoint.uuid` or `protocol_endpoint.name` - Existing class `protocol_endpoint` LUN to bind to the specified class `vvol` LUN.
* `vvol.uuid` or `vvol.name` - Existing class `vvol` LUN to bind to the specified class `protocol_endpoint` LUN.
### Related ONTAP commands
* `lun bind create`
### Learn more
* [`DOC /protocols/san/vvol-bindings`](#docs-SAN-protocols_san_vvol-bindings)
*/
func (a *Client) VvolBindingCreate(params *VvolBindingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVvolBindingCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vvol_binding_create",
		Method:             "POST",
		PathPattern:        "/protocols/san/vvol-bindings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VvolBindingCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VvolBindingCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VvolBindingCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VvolBindingDelete Deletes a vVol binding. The binding between any two specific LUNs is reference counted. When a binding is deleted, the binding count is decremented, but the LUNs remain bound if the resultant reference count is greater than zero. When the binding count reaches zero, the binding is destroyed.

### Related ONTAP commands
* `lun bind destroy`
### Learn more
* [`DOC /protocols/san/vvol-bindings`](#docs-SAN-protocols_san_vvol-bindings)
*/
func (a *Client) VvolBindingDelete(params *VvolBindingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVvolBindingDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vvol_binding_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VvolBindingDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VvolBindingDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VvolBindingDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VvolBindingDeleteCollection vvol binding delete collection API
*/
func (a *Client) VvolBindingDeleteCollection(params *VvolBindingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVvolBindingDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vvol_binding_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/san/vvol-bindings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VvolBindingDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VvolBindingDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VvolBindingDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VvolBindingGet Retrieves a vVol binding.

### Related ONTAP commands
* `lun bind show`
### Learn more
* [`DOC /protocols/san/vvol-bindings`](#docs-SAN-protocols_san_vvol-bindings)
*/
func (a *Client) VvolBindingGet(params *VvolBindingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VvolBindingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVvolBindingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vvol_binding_get",
		Method:             "GET",
		PathPattern:        "/protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VvolBindingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VvolBindingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VvolBindingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WwpnAliasCollectionGet Retrieves FC WWPN aliases.

### Related ONTAP commands
* `vserver fcp wwpn-alias show`
### Learn more
* [`DOC /network/fc/wwpn-aliases`](#docs-SAN-network_fc_wwpn-aliases)
*/
func (a *Client) WwpnAliasCollectionGet(params *WwpnAliasCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWwpnAliasCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "wwpn_alias_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/wwpn-aliases",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WwpnAliasCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WwpnAliasCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WwpnAliasCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WwpnAliasCreate Creates an FC WWPN alias.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the FC alias.
* `alias` - Name of the FC alias.
* `wwpn` - FC WWPN for which to create the alias.
### Related ONTAP commands
* `vserver fcp wwpn-alias set`
### Learn more
* [`DOC /network/fc/wwpn-aliases`](#docs-SAN-network_fc_wwpn-aliases)
*/
func (a *Client) WwpnAliasCreate(params *WwpnAliasCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWwpnAliasCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "wwpn_alias_create",
		Method:             "POST",
		PathPattern:        "/network/fc/wwpn-aliases",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WwpnAliasCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WwpnAliasCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WwpnAliasCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WwpnAliasDelete Deletes an FC WWPN alias.

### Related ONTAP commands
* `vserver fcp wwpn-alias remove`
### Learn more
* [`DOC /network/fc/wwpn-aliases`](#docs-SAN-network_fc_wwpn-aliases)
*/
func (a *Client) WwpnAliasDelete(params *WwpnAliasDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWwpnAliasDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "wwpn_alias_delete",
		Method:             "DELETE",
		PathPattern:        "/network/fc/wwpn-aliases/{svm.uuid}/{alias}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WwpnAliasDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WwpnAliasDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WwpnAliasDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WwpnAliasDeleteCollection wwpn alias delete collection API
*/
func (a *Client) WwpnAliasDeleteCollection(params *WwpnAliasDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWwpnAliasDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "wwpn_alias_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/fc/wwpn-aliases",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WwpnAliasDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WwpnAliasDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WwpnAliasDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WwpnAliasGet Retrieves an FC WWPN alias.

### Related ONTAP commands
* `vserver fcp wwpn-alias show`
### Learn more
* [`DOC /network/fc/wwpn-aliases`](#docs-SAN-network_fc_wwpn-aliases)
*/
func (a *Client) WwpnAliasGet(params *WwpnAliasGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WwpnAliasGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWwpnAliasGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "wwpn_alias_get",
		Method:             "GET",
		PathPattern:        "/network/fc/wwpn-aliases/{svm.uuid}/{alias}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WwpnAliasGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WwpnAliasGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WwpnAliasGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
