// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitCreateReader is a Reader for the StorageUnitCreate structure.
type StorageUnitCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewStorageUnitCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitCreateCreated creates a StorageUnitCreateCreated with default headers values
func NewStorageUnitCreateCreated() *StorageUnitCreateCreated {
	return &StorageUnitCreateCreated{}
}

/*
StorageUnitCreateCreated describes a response with status code 201, with default header values.

Created
*/
type StorageUnitCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit create created response has a 2xx status code
func (o *StorageUnitCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit create created response has a 3xx status code
func (o *StorageUnitCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit create created response has a 4xx status code
func (o *StorageUnitCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit create created response has a 5xx status code
func (o *StorageUnitCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit create created response a status code equal to that given
func (o *StorageUnitCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the storage unit create created response
func (o *StorageUnitCreateCreated) Code() int {
	return 201
}

func (o *StorageUnitCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storageUnitCreateCreated %s", 201, payload)
}

func (o *StorageUnitCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storageUnitCreateCreated %s", 201, payload)
}

func (o *StorageUnitCreateCreated) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitCreateAccepted creates a StorageUnitCreateAccepted with default headers values
func NewStorageUnitCreateAccepted() *StorageUnitCreateAccepted {
	return &StorageUnitCreateAccepted{}
}

/*
StorageUnitCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit create accepted response has a 2xx status code
func (o *StorageUnitCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit create accepted response has a 3xx status code
func (o *StorageUnitCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit create accepted response has a 4xx status code
func (o *StorageUnitCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit create accepted response has a 5xx status code
func (o *StorageUnitCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit create accepted response a status code equal to that given
func (o *StorageUnitCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit create accepted response
func (o *StorageUnitCreateAccepted) Code() int {
	return 202
}

func (o *StorageUnitCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storageUnitCreateAccepted %s", 202, payload)
}

func (o *StorageUnitCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storageUnitCreateAccepted %s", 202, payload)
}

func (o *StorageUnitCreateAccepted) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitCreateDefault creates a StorageUnitCreateDefault with default headers values
func NewStorageUnitCreateDefault(code int) *StorageUnitCreateDefault {
	return &StorageUnitCreateDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917525 | The specified storage unit does not exist in the svm. |
| 917526 | Duplicate storage unit name. |
| 918232 | The specified storage unit identifier properties must be provided. |
| 918243 | The specified snapshot UUID is not correct for the specified snapshot name. |
| 1638400 | Failed to retrieve the storage unit snapshot information. |
| 5374604 | _false_ is not a supported value for this property. |
| 5376459 | The specified storage unit UUID is not correct for the storage unit name. |
| 5376461 | An invalid storage unit name was specified. |
| 5376489 | The specified storage unit does not exist in the svm. |
| 5376490 | Storage unit not found. |
| 5376492 | The source storage unit for the clone operation is not specified. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit create default response has a 2xx status code
func (o *StorageUnitCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit create default response has a 3xx status code
func (o *StorageUnitCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit create default response has a 4xx status code
func (o *StorageUnitCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit create default response has a 5xx status code
func (o *StorageUnitCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit create default response a status code equal to that given
func (o *StorageUnitCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit create default response
func (o *StorageUnitCreateDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storage_unit_create default %s", o._statusCode, payload)
}

func (o *StorageUnitCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units][%d] storage_unit_create default %s", o._statusCode, payload)
}

func (o *StorageUnitCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
