// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitGetReader is a Reader for the StorageUnitGet structure.
type StorageUnitGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitGetOK creates a StorageUnitGetOK with default headers values
func NewStorageUnitGetOK() *StorageUnitGetOK {
	return &StorageUnitGetOK{}
}

/*
StorageUnitGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitGetOK struct {
	Payload *models.StorageUnit
}

// IsSuccess returns true when this storage unit get o k response has a 2xx status code
func (o *StorageUnitGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit get o k response has a 3xx status code
func (o *StorageUnitGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit get o k response has a 4xx status code
func (o *StorageUnitGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit get o k response has a 5xx status code
func (o *StorageUnitGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit get o k response a status code equal to that given
func (o *StorageUnitGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit get o k response
func (o *StorageUnitGetOK) Code() int {
	return 200
}

func (o *StorageUnitGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{uuid}][%d] storageUnitGetOK %s", 200, payload)
}

func (o *StorageUnitGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{uuid}][%d] storageUnitGetOK %s", 200, payload)
}

func (o *StorageUnitGetOK) GetPayload() *models.StorageUnit {
	return o.Payload
}

func (o *StorageUnitGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnit)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitGetDefault creates a StorageUnitGetDefault with default headers values
func NewStorageUnitGetDefault(code int) *StorageUnitGetDefault {
	return &StorageUnitGetDefault{
		_statusCode: code,
	}
}

/*
StorageUnitGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageUnitGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit get default response has a 2xx status code
func (o *StorageUnitGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit get default response has a 3xx status code
func (o *StorageUnitGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit get default response has a 4xx status code
func (o *StorageUnitGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit get default response has a 5xx status code
func (o *StorageUnitGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit get default response a status code equal to that given
func (o *StorageUnitGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit get default response
func (o *StorageUnitGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{uuid}][%d] storage_unit_get default %s", o._statusCode, payload)
}

func (o *StorageUnitGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{uuid}][%d] storage_unit_get default %s", o._statusCode, payload)
}

func (o *StorageUnitGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
