// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitModifyCollectionReader is a Reader for the StorageUnitModifyCollection structure.
type StorageUnitModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitModifyCollectionOK creates a StorageUnitModifyCollectionOK with default headers values
func NewStorageUnitModifyCollectionOK() *StorageUnitModifyCollectionOK {
	return &StorageUnitModifyCollectionOK{}
}

/*
StorageUnitModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitModifyCollectionOK struct {
	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit modify collection o k response has a 2xx status code
func (o *StorageUnitModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit modify collection o k response has a 3xx status code
func (o *StorageUnitModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit modify collection o k response has a 4xx status code
func (o *StorageUnitModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit modify collection o k response has a 5xx status code
func (o *StorageUnitModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit modify collection o k response a status code equal to that given
func (o *StorageUnitModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit modify collection o k response
func (o *StorageUnitModifyCollectionOK) Code() int {
	return 200
}

func (o *StorageUnitModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storageUnitModifyCollectionOK %s", 200, payload)
}

func (o *StorageUnitModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storageUnitModifyCollectionOK %s", 200, payload)
}

func (o *StorageUnitModifyCollectionOK) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitModifyCollectionAccepted creates a StorageUnitModifyCollectionAccepted with default headers values
func NewStorageUnitModifyCollectionAccepted() *StorageUnitModifyCollectionAccepted {
	return &StorageUnitModifyCollectionAccepted{}
}

/*
StorageUnitModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitModifyCollectionAccepted struct {
	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit modify collection accepted response has a 2xx status code
func (o *StorageUnitModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit modify collection accepted response has a 3xx status code
func (o *StorageUnitModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit modify collection accepted response has a 4xx status code
func (o *StorageUnitModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit modify collection accepted response has a 5xx status code
func (o *StorageUnitModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit modify collection accepted response a status code equal to that given
func (o *StorageUnitModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit modify collection accepted response
func (o *StorageUnitModifyCollectionAccepted) Code() int {
	return 202
}

func (o *StorageUnitModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storageUnitModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storageUnitModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitModifyCollectionAccepted) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitModifyCollectionDefault creates a StorageUnitModifyCollectionDefault with default headers values
func NewStorageUnitModifyCollectionDefault(code int) *StorageUnitModifyCollectionDefault {
	return &StorageUnitModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1638592 | The specified snapshot UUID is not correct for the specified snapshot name. |
| 1638600 | The specified snapshot does not exist. |
| 5374614 | A non-existent storage availability zone was specified. |
| 5376461 | An invalid storage unit name was specified. |
| 5376497 | The storage unit move operation is not ready for cutover. |
| 5376499 | The storage unit move operation cannot be paused. |
| 5376500 | The storage unit move operation is not paused. |
| 5376508 | A storage unit move operation of a secondary storage unit is not supported. To move a secondary storage unit, you must move the associated primary storage unit which moves all of the secondary storage units. |
| 5376509 | Storage unit move operations are not allowed for an SVM administrator. |
| 5376510 | Storage unit move operation is not allowed for protocol endpoints. |
| 5376511 | A storage unit move operation is already in progress for the storage unit. |
| 5376512 | A storage unit move operation is not in progress for the storage unit. |
| 5376513 | An attempt was made to patch a storage unit move operation state to an unsupported state. Allowed states are aborted, cutover, paused, replicating, and cutover_wait. |
| 5376518 | The storage unit move operation cannot be paused at the current time. Wait and try again. |
| 5376521 | An attempt was made to modify a property of a secondary storage unit that can only be modified via the primary storage unit. |
| 5376522 | Storage unit clone-related operations are not supported on a secondary storage unit. You must perform a clone-related operation on the associated primary storage unit which is then applied to all of the secondary storage units. |
| 5376523 | Query parameter `restore_to.snapshot.name` or `restore_to.snapshot.uuid` must be supplied when supplying other `restore_to` query parameters. |
| 5376524 | The specified query parameter requires `restore_to.keep_snapshots` to be `true`. |
| 5376525 | Query parameter `restore_to.keep_snapshots` must be `true` for secondary storage units. |
| 5376526 | Query parameter `restore_to.start_byte` and `restore_to.byte_count` must both be supplied to request a partial storage unit snapshot restore. |
| 5376527 | Query parameter `restore_to.start_byte` and `restore_to.byte_count` must both be increments of 4096. |
| 5376530 | The specified storage unit does not exist in the specified snapshot. |
| 203161607 | An attempt to set the anti-ransomware state to dry-run when it is already enabled. |
| 203161610 | An attempt pause anti-ransomware checking when it is in a conflicting state. |
| 203161611 | An attempt to resume anti-ransomware checking when it is in a conflicting state. |
| 203161613 | Anti-ransomware is disabled. |
| 203161623 | Anti-ransomware is being disabled. |
| 203161633 | An attempt to resume anti-ransomware checking when it is paused in a conflicting state. |
| 203161642 | An attempt to set the anti-ransomware state to dry-run-paused when it is already enabled. |
| 203161643 | An attempt to set the anti-ransomware state to enable-paused when it is already enabled. |
| 203161644 | An attempt to set the anti-ransomware state to a disallowed value. |
| 203161645 | An attempt to set the anti-ransomware on a storage unit that is moving. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit modify collection default response has a 2xx status code
func (o *StorageUnitModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit modify collection default response has a 3xx status code
func (o *StorageUnitModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit modify collection default response has a 4xx status code
func (o *StorageUnitModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit modify collection default response has a 5xx status code
func (o *StorageUnitModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit modify collection default response a status code equal to that given
func (o *StorageUnitModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit modify collection default response
func (o *StorageUnitModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storage_unit_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units][%d] storage_unit_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StorageUnitModifyCollectionBody storage unit modify collection body
swagger:model StorageUnitModifyCollectionBody
*/
type StorageUnitModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// anti ransomware
	AntiRansomware *models.StorageUnitInlineAntiRansomware `json:"anti_ransomware,omitempty"`

	// The class of LUN.
	//
	// Read Only: true
	// Enum: ["regular","vvol"]
	Class *string `json:"class,omitempty"`

	// clone
	Clone *models.StorageUnitClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator.
	//
	// Read Only: true
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *models.StorageUnitInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// The time the storage unit was created.
	//
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the storage unit. Storage units can be disabled to prevent access to the storage unit. Certain error conditions also cause the storage unit to become disabled. If the storage unit is disabled, check the `status.state` property to determine if the storage unit is administratively disabled (_offline_) or has become disabled as a result of an error.<br/>
	// A storage unit in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_ using /api/storage/luns or /api/storage/namespaces. Upon creation, a storage unit is enabled by default.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// encryption
	Encryption *models.StorageUnitEncryption `json:"encryption,omitempty"`

	// location
	Location *models.StorageUnitInlineLocation `json:"location,omitempty"`

	// metric
	Metric *models.StorageUnitInlineMetric `json:"metric,omitempty"`

	// movement
	Movement *models.StorageUnitInlineMovement `json:"movement,omitempty"`

	// The name of the storage unit. The name must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 203 characters or less in length. Valid in POST.
	//
	// Example: lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the storage unit.<br/>
	//
	// Read Only: true
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// qos policy
	QosPolicy *models.StorageUnitInlineQosPolicy `json:"qos_policy,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// The LUN serial number encoded in hexadecimal format. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	SerialNumberHex *string `json:"serial_number_hex,omitempty"`

	// space
	Space *models.StorageUnitInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *models.StorageUnitInlineStatistics `json:"statistics,omitempty"`

	// status
	Status *models.StorageUnitInlineStatus `json:"status,omitempty"`

	// Maps between the storage unit and host groups.
	//
	// Read Only: true
	StorageUnitInlineMaps []*models.StorageUnitInlineMapsInlineArrayItem `json:"maps,omitempty"`

	// storage unit response inline records
	StorageUnitResponseInlineRecords []*models.StorageUnit `json:"records,omitempty"`

	// svm
	Svm *models.StorageUnitInlineSvm `json:"svm,omitempty"`

	// The type of storage unit.
	//
	// Read Only: true
	// Enum: ["lun","namespace"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the storage unit. The UUID is generated by ONTAP when the storage unit is created. The storage unit UUID is the same as the LUN or namespace UUID.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit modify collection body
func (o *StorageUnitModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClass(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMovement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnitInlineMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnitResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(o.AntiRansomware) { // not required
		return nil
	}

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

var storageUnitModifyCollectionBodyTypeClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","vvol"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitModifyCollectionBodyTypeClassPropEnum = append(storageUnitModifyCollectionBodyTypeClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// class
	// Class
	// regular
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyClassRegular captures enum value "regular"
	StorageUnitModifyCollectionBodyClassRegular string = "regular"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// class
	// Class
	// vvol
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyClassVvol captures enum value "vvol"
	StorageUnitModifyCollectionBodyClassVvol string = "vvol"
)

// prop value enum
func (o *StorageUnitModifyCollectionBody) validateClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitModifyCollectionBodyTypeClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitModifyCollectionBody) validateClass(formats strfmt.Registry) error {
	if swag.IsZero(o.Class) { // not required
		return nil
	}

	// value enum
	if err := o.validateClassEnum("info"+"."+"class", "body", *o.Class); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(o.Clone) { // not required
		return nil
	}

	if o.Clone != nil {
		if err := o.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.ConsistencyGroup) { // not required
		return nil
	}

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateMovement(formats strfmt.Registry) error {
	if swag.IsZero(o.Movement) { // not required
		return nil
	}

	if o.Movement != nil {
		if err := o.Movement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

var storageUnitModifyCollectionBodyTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitModifyCollectionBodyTypeOsTypePropEnum = append(storageUnitModifyCollectionBodyTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeAix captures enum value "aix"
	StorageUnitModifyCollectionBodyOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeHpux captures enum value "hpux"
	StorageUnitModifyCollectionBodyOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeHyperv captures enum value "hyper_v"
	StorageUnitModifyCollectionBodyOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeLinux captures enum value "linux"
	StorageUnitModifyCollectionBodyOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeNetware captures enum value "netware"
	StorageUnitModifyCollectionBodyOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeOpenvms captures enum value "openvms"
	StorageUnitModifyCollectionBodyOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeSolaris captures enum value "solaris"
	StorageUnitModifyCollectionBodyOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeSolarisEfi captures enum value "solaris_efi"
	StorageUnitModifyCollectionBodyOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeVmware captures enum value "vmware"
	StorageUnitModifyCollectionBodyOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeWindows captures enum value "windows"
	StorageUnitModifyCollectionBodyOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeWindows2008 captures enum value "windows_2008"
	StorageUnitModifyCollectionBodyOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeWindowsGpt captures enum value "windows_gpt"
	StorageUnitModifyCollectionBodyOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyOsTypeXen captures enum value "xen"
	StorageUnitModifyCollectionBodyOsTypeXen string = "xen"
)

// prop value enum
func (o *StorageUnitModifyCollectionBody) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitModifyCollectionBodyTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitModifyCollectionBody) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("info"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"serial_number", "body", *o.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	if o.Status != nil {
		if err := o.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateStorageUnitInlineMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnitInlineMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageUnitInlineMaps); i++ {
		if swag.IsZero(o.StorageUnitInlineMaps[i]) { // not required
			continue
		}

		if o.StorageUnitInlineMaps[i] != nil {
			if err := o.StorageUnitInlineMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateStorageUnitResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnitResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageUnitResponseInlineRecords); i++ {
		if swag.IsZero(o.StorageUnitResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StorageUnitResponseInlineRecords[i] != nil {
			if err := o.StorageUnitResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var storageUnitModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["lun","namespace"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitModifyCollectionBodyTypeTypePropEnum = append(storageUnitModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// type
	// Type
	// lun
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyTypeLun captures enum value "lun"
	StorageUnitModifyCollectionBodyTypeLun string = "lun"

	// BEGIN DEBUGGING
	// StorageUnitModifyCollectionBody
	// StorageUnitModifyCollectionBody
	// type
	// Type
	// namespace
	// END DEBUGGING
	// StorageUnitModifyCollectionBodyTypeNamespace captures enum value "namespace"
	StorageUnitModifyCollectionBodyTypeNamespace string = "namespace"
)

// prop value enum
func (o *StorageUnitModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit modify collection body based on the context it is used
func (o *StorageUnitModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateComment(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMovement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOsType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSerialNumberHex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnitInlineMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnitResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"class", "body", o.Class); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if o.Clone != nil {
		if err := o.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "clone")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateComment(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"comment", "body", o.Comment); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.ConsistencyGroup != nil {
		if err := o.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateMovement(ctx context.Context, formats strfmt.Registry) error {

	if o.Movement != nil {
		if err := o.Movement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateOsType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"os_type", "body", o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number", "body", o.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateSerialNumberHex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"serial_number_hex", "body", o.SerialNumberHex); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.Status != nil {
		if err := o.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "status")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateStorageUnitInlineMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"maps", "body", []*models.StorageUnitInlineMapsInlineArrayItem(o.StorageUnitInlineMaps)); err != nil {
		return err
	}

	for i := 0; i < len(o.StorageUnitInlineMaps); i++ {

		if o.StorageUnitInlineMaps[i] != nil {
			if err := o.StorageUnitInlineMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateStorageUnitResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StorageUnitResponseInlineRecords); i++ {

		if o.StorageUnitResponseInlineRecords[i] != nil {
			if err := o.StorageUnitResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res StorageUnitModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0 storage unit modify collection params body anti ransomware attack reports items0
swagger:model StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0
*/
type StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0 struct {

	// Timestamp at which ransomware attack is observed.
	//
	// Example: 2021-06-01 20:36:41+05:30
	// Read Only: true
	// Format: date-time
	Time *strfmt.DateTime `json:"time,omitempty"`
}

// Validate validates this storage unit modify collection params body anti ransomware attack reports items0
func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) validateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.Time) { // not required
		return nil
	}

	if err := validate.FormatOf("time", "body", "date-time", o.Time.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit modify collection params body anti ransomware attack reports items0 based on the context it is used
func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) contextValidateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time", "body", o.Time); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0) UnmarshalBinary(b []byte) error {
	var res StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineAntiRansomware The anti-ransomware properties of the storage unit.
//
swagger:model storage_unit_inline_anti_ransomware
*/
type StorageUnitInlineAntiRansomware struct {

	// The probability of a ransomware attack.<br/>
	// Possible values:
	// * `none` No suspected ransomware activity.
	// * `moderate` Suspected ransomware activity.
	//
	// Read Only: true
	// Enum: ["none","moderate"]
	AttackProbability *string `json:"attack_probability,omitempty"`

	// attack reports
	// Read Only: true
	AttackReports []*StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0 `json:"attack_reports,omitempty"`

	// The anti-ransomware state for the storage unit.<br/>
	// Possible values:
	// * `disabled` Anti-ransomware monitoring is disabled for the storage unit. Valid in PATCH and GET.
	// * `disable_in_progress` Anti-ransomware monitoring is being disabled and a clean-up operation is in progress. Valid in GET.
	// * `enabled` Anti-ransomware monitoring is active for the storage unit. Valid in PATCH and GET.
	// * `paused` Anti-ransomware monitoring is paused for the storage unit from its earlier enabled state. Valid in PATCH and GET.
	//
	// Enum: ["disabled","disable_in_progress","enabled","paused"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline anti ransomware
func (o *StorageUnitInlineAntiRansomware) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAttackProbability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAttackReports(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","moderate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum = append(storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// none
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareAttackProbabilityNone captures enum value "none"
	StorageUnitInlineAntiRansomwareAttackProbabilityNone string = "none"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// attack_probability
	// AttackProbability
	// moderate
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareAttackProbabilityModerate captures enum value "moderate"
	StorageUnitInlineAntiRansomwareAttackProbabilityModerate string = "moderate"
)

// prop value enum
func (o *StorageUnitInlineAntiRansomware) validateAttackProbabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineAntiRansomwareTypeAttackProbabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineAntiRansomware) validateAttackProbability(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackProbability) { // not required
		return nil
	}

	// value enum
	if err := o.validateAttackProbabilityEnum("info"+"."+"anti_ransomware"+"."+"attack_probability", "body", *o.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineAntiRansomware) validateAttackReports(formats strfmt.Registry) error {
	if swag.IsZero(o.AttackReports) { // not required
		return nil
	}

	for i := 0; i < len(o.AttackReports); i++ {
		if swag.IsZero(o.AttackReports[i]) { // not required
			continue
		}

		if o.AttackReports[i] != nil {
			if err := o.AttackReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var storageUnitInlineAntiRansomwareTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","disable_in_progress","enabled","paused"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineAntiRansomwareTypeStatePropEnum = append(storageUnitInlineAntiRansomwareTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// disabled
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateDisabled captures enum value "disabled"
	StorageUnitInlineAntiRansomwareStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// disable_in_progress
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateDisableInProgress captures enum value "disable_in_progress"
	StorageUnitInlineAntiRansomwareStateDisableInProgress string = "disable_in_progress"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// enabled
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStateEnabled captures enum value "enabled"
	StorageUnitInlineAntiRansomwareStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// storage_unit_inline_anti_ransomware
	// StorageUnitInlineAntiRansomware
	// state
	// State
	// paused
	// END DEBUGGING
	// StorageUnitInlineAntiRansomwareStatePaused captures enum value "paused"
	StorageUnitInlineAntiRansomwareStatePaused string = "paused"
)

// prop value enum
func (o *StorageUnitInlineAntiRansomware) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineAntiRansomwareTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineAntiRansomware) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"anti_ransomware"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline anti ransomware based on the context it is used
func (o *StorageUnitInlineAntiRansomware) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAttackProbability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAttackReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineAntiRansomware) contextValidateAttackProbability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"attack_probability", "body", o.AttackProbability); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineAntiRansomware) contextValidateAttackReports(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"anti_ransomware"+"."+"attack_reports", "body", []*StorageUnitModifyCollectionParamsBodyAntiRansomwareAttackReportsItems0(o.AttackReports)); err != nil {
		return err
	}

	for i := 0; i < len(o.AttackReports); i++ {

		if o.AttackReports[i] != nil {
			if err := o.AttackReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "anti_ransomware" + "." + "attack_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineAntiRansomware) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineAntiRansomware) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineAntiRansomware
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineConsistencyGroup The storage unit's consistency group. This property is populated for storage units that are members of a consistency group.
//
swagger:model storage_unit_inline_consistency_group
*/
type StorageUnitInlineConsistencyGroup struct {

	// links
	Links *models.StorageUnitInlineConsistencyGroupInlineLinks `json:"_links,omitempty"`

	// The name of the consistency group.
	//
	// Example: cg1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	//
	// Example: 4abc2317-4332-9d37-93a0-20bd29c22df0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline consistency group
func (o *StorageUnitInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline consistency group based on the context it is used
func (o *StorageUnitInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineConsistencyGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"consistency_group"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"consistency_group"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineConsistencyGroupInlineLinks storage unit inline consistency group inline links
swagger:model storage_unit_inline_consistency_group_inline__links
*/
type StorageUnitInlineConsistencyGroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline consistency group inline links
func (o *StorageUnitInlineConsistencyGroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineConsistencyGroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline consistency group inline links based on the context it is used
func (o *StorageUnitInlineConsistencyGroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineConsistencyGroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineConsistencyGroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineConsistencyGroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineConsistencyGroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocation storage unit inline location
swagger:model storage_unit_inline_location
*/
type StorageUnitInlineLocation struct {

	// node
	Node *models.StorageUnitInlineLocationInlineNode `json:"node,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *models.StorageUnitInlineLocationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// volume
	Volume *models.StorageUnitInlineLocationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this storage unit inline location
func (o *StorageUnitInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineLocation) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZone) { // not required
		return nil
	}

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineLocation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location based on the context it is used
func (o *StorageUnitInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineLocation) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineLocation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocation) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineNode The cluster node that hosts the storage unit.
//
swagger:model storage_unit_inline_location_inline_node
*/
type StorageUnitInlineLocationInlineNode struct {

	// links
	Links *models.StorageUnitInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline node
func (o *StorageUnitInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline node based on the context it is used
func (o *StorageUnitInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineNodeInlineLinks storage unit inline location inline node inline links
swagger:model storage_unit_inline_location_inline_node_inline__links
*/
type StorageUnitInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline node inline links
func (o *StorageUnitInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline node inline links based on the context it is used
func (o *StorageUnitInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineStorageAvailabilityZone The storage availability zone that contains the storage unit.<br/>
// Available in PATCH to initiate a storage unit move operation.
//
swagger:model storage_unit_inline_location_inline_storage_availability_zone
*/
type StorageUnitInlineLocationInlineStorageAvailabilityZone struct {

	// links
	Links *models.StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline storage availability zone
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline storage availability zone based on the context it is used
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks storage unit inline location inline storage availability zone inline links
swagger:model storage_unit_inline_location_inline_storage_availability_zone_inline__links
*/
type StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline storage availability zone inline links
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline storage availability zone inline links based on the context it is used
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineVolume The legacy ONTAP volume associated with the storage unit.<br/>
// Functionality not supported on the storage-unit endpoint is
// available from the legacy /api/storage/volumes endpoint.
//
swagger:model storage_unit_inline_location_inline_volume
*/
type StorageUnitInlineLocationInlineVolume struct {

	// links
	Links *models.StorageUnitInlineLocationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline location inline volume
func (o *StorageUnitInlineLocationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline volume based on the context it is used
func (o *StorageUnitInlineLocationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineVolume) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineLocationInlineVolumeInlineLinks storage unit inline location inline volume inline links
swagger:model storage_unit_inline_location_inline_volume_inline__links
*/
type StorageUnitInlineLocationInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline location inline volume inline links
func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline location inline volume inline links based on the context it is used
func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineLocationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineLocationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItem A map between the storage unit and a host group. A map is either a LUN map or an NVMe subsystem map.
//
swagger:model storage_unit_inline_maps_inline_array_item
*/
type StorageUnitInlineMapsInlineArrayItem struct {

	// host group
	HostGroup *models.StorageUnitInlineMapsInlineArrayItemInlineHostGroup `json:"host_group,omitempty"`

	// lun map
	LunMap *models.StorageUnitInlineMapsInlineArrayItemInlineLunMap `json:"lun_map,omitempty"`

	// subsystem map
	SubsystemMap *models.StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap `json:"subsystem_map,omitempty"`
}

// Validate validates this storage unit inline maps inline array item
func (o *StorageUnitInlineMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHostGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunMap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) validateHostGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.HostGroup) { // not required
		return nil
	}

	if o.HostGroup != nil {
		if err := o.HostGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_group")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) validateLunMap(formats strfmt.Registry) error {
	if swag.IsZero(o.LunMap) { // not required
		return nil
	}

	if o.LunMap != nil {
		if err := o.LunMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(o.SubsystemMap) { // not required
		return nil
	}

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHostGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) contextValidateHostGroup(ctx context.Context, formats strfmt.Registry) error {

	if o.HostGroup != nil {
		if err := o.HostGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host_group")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) contextValidateLunMap(ctx context.Context, formats strfmt.Registry) error {

	if o.LunMap != nil {
		if err := o.LunMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItem) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if o.SubsystemMap != nil {
		if err := o.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineHostGroup A host group mapped to the storage unit. A host group is either an initiator group or an NVMe subsystem.
//
swagger:model storage_unit_inline_maps_inline_array_item_inline_host_group
*/
type StorageUnitInlineMapsInlineArrayItemInlineHostGroup struct {

	// The name of the mapped host group.
	//
	// Example: host_group1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the mapped host group.
	//
	// Example: 19f8d194-4d24-b1df-f3f7-e7aa68bc53db
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline host group
func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline host group based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_group"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host_group"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineHostGroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineHostGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineLunMap A map between the storage unit and an initiator group.
//
swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map
*/
type StorageUnitInlineMapsInlineArrayItemInlineLunMap struct {

	// links
	Links *models.StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks `json:"_links,omitempty"`

	// igroup
	Igroup *models.StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through Fibre Channel Protocol or iSCSI.
	//
	// Example: 1
	// Read Only: true
	// Maximum: 4095
	// Minimum: 0
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLogicalUnitNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) validateLogicalUnitNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.LogicalUnitNumber) { // not required
		return nil
	}

	if err := validate.MinimumInt("lun_map"+"."+"logical_unit_number", "body", *o.LogicalUnitNumber, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("lun_map"+"."+"logical_unit_number", "body", *o.LogicalUnitNumber, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUnitNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) contextValidateLogicalUnitNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun_map"+"."+"logical_unit_number", "body", o.LogicalUnitNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMap) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks storage unit inline maps inline array item inline lun map inline links
swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline__links
*/
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline links
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline links based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup storage unit inline maps inline array item inline lun map inline igroup
swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline_igroup
*/
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup struct {

	// links
	Links *models.StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline igroup
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("lun_map"+"."+"igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("lun_map"+"."+"igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline igroup based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks storage unit inline maps inline array item inline lun map inline igroup inline links
swagger:model storage_unit_inline_maps_inline_array_item_inline_lun_map_inline_igroup_inline__links
*/
type StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline lun map inline igroup inline links
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline lun map inline igroup inline links based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun_map" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineLunMapInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap A map between the storage unit and an NVMe subsystem.
//
swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map
*/
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap struct {

	// links
	Links *models.StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks `json:"_links,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// subsystem
	Subsystem *models.StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(o.Subsystem) { // not required
		return nil
	}

	if o.Subsystem != nil {
		if err := o.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", o.Nsid); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if o.Subsystem != nil {
		if err := o.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks storage unit inline maps inline array item inline subsystem map inline links
swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline__links
*/
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline links
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline links based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem An NVMe subsystem maintains configuration state and NVMe namespace access control for a set of NVMe-connected hosts.
//
swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline_subsystem
*/
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem struct {

	// links
	Links *models.StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline subsystem
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline subsystem based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks storage unit inline maps inline array item inline subsystem map inline subsystem inline links
swagger:model storage_unit_inline_maps_inline_array_item_inline_subsystem_map_inline_subsystem_inline__links
*/
type StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline maps inline array item inline subsystem map inline subsystem inline links
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline maps inline array item inline subsystem map inline subsystem inline links based on the context it is used
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMapsInlineArrayItemInlineSubsystemMapInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMetric Performance numbers, such as IOPS latency and throughput.
swagger:model storage_unit_inline_metric
*/
type StorageUnitInlineMetric struct {

	// links
	Links *models.StorageUnitInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.StorageUnitInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.StorageUnitInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.StorageUnitInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit inline metric
func (o *StorageUnitInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMetricTypeDurationPropEnum = append(storageUnitInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT15S captures enum value "PT15S"
	StorageUnitInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT4M captures enum value "PT4M"
	StorageUnitInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT30M captures enum value "PT30M"
	StorageUnitInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT2H captures enum value "PT2H"
	StorageUnitInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// StorageUnitInlineMetricDurationP1D captures enum value "P1D"
	StorageUnitInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// StorageUnitInlineMetricDurationPT5M captures enum value "PT5M"
	StorageUnitInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *StorageUnitInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMetricTypeStatusPropEnum = append(storageUnitInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// StorageUnitInlineMetricStatusOk captures enum value "ok"
	StorageUnitInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// StorageUnitInlineMetricStatusError captures enum value "error"
	StorageUnitInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	StorageUnitInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	StorageUnitInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	StorageUnitInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// StorageUnitInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	StorageUnitInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// StorageUnitInlineMetricStatusNotFound captures enum value "not_found"
	StorageUnitInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	StorageUnitInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// StorageUnitInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	StorageUnitInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// StorageUnitInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	StorageUnitInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_metric
	// StorageUnitInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// StorageUnitInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	StorageUnitInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *StorageUnitInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline metric based on the context it is used
func (o *StorageUnitInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMetric) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMetricInlineLinks storage unit inline metric inline links
swagger:model storage_unit_inline_metric_inline__links
*/
type StorageUnitInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline metric inline links
func (o *StorageUnitInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline metric inline links based on the context it is used
func (o *StorageUnitInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model storage_unit_inline_metric_inline_iops
*/
type StorageUnitInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline iops
func (o *StorageUnitInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline iops based on the context it is used
func (o *StorageUnitInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model storage_unit_inline_metric_inline_latency
*/
type StorageUnitInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline latency
func (o *StorageUnitInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline latency based on the context it is used
func (o *StorageUnitInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model storage_unit_inline_metric_inline_throughput
*/
type StorageUnitInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline metric inline throughput
func (o *StorageUnitInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline metric inline throughput based on the context it is used
func (o *StorageUnitInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovement The properties of a storage unit move operation from one storage availability zone to another.
//
swagger:model storage_unit_inline_movement
*/
type StorageUnitInlineMovement struct {

	// destination
	Destination *models.StorageUnitInlineMovementInlineDestination `json:"destination,omitempty"`

	// The percentage complete of the storage unit move operation.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	PercentComplete *int64 `json:"percent_complete,omitempty"`

	// source
	Source *models.StorageUnitInlineMovementInlineSource `json:"source,omitempty"`

	// The start date and time of the storage unit move operation.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 2024-12-07 03:45:12-05:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`

	// The state of the storage unit move operation.<br>
	// The state can be updated to influence the progress of an on-going storage unit move operation. The allowed new state depends on the current state:
	// - Update the state to `aborted` to cancel the storage unit move operation.
	// - Update the state to `cutover` to trigger cutover of the storage unit move operation.
	// - Update the state to `paused` to pause an in progress storage unit move operation. If the move operation has just begun replication, an update to `paused` may not be immediately possible, in which case it will fail with error 5376518 and require a retry.
	// - Update the state to `replicating` to resume a paused storage unit move operation.
	// - Update the state to `cutover_wait` to go into cutover for the storage unit move operation, manually.
	// When the storage unit move operation is waiting to go into the `cutover` state, the state is `cutover_pending`.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: replicating
	// Enum: ["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline movement
func (o *StorageUnitInlineMovement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovement) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMovement) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMovement) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"movement"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var storageUnitInlineMovementTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aborted","cutover","cutover_wait","cutover_pending","failed","paused","queued","replicating","success"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineMovementTypeStatePropEnum = append(storageUnitInlineMovementTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// aborted
	// END DEBUGGING
	// StorageUnitInlineMovementStateAborted captures enum value "aborted"
	StorageUnitInlineMovementStateAborted string = "aborted"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutover captures enum value "cutover"
	StorageUnitInlineMovementStateCutover string = "cutover"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover_wait
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutoverWait captures enum value "cutover_wait"
	StorageUnitInlineMovementStateCutoverWait string = "cutover_wait"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// cutover_pending
	// END DEBUGGING
	// StorageUnitInlineMovementStateCutoverPending captures enum value "cutover_pending"
	StorageUnitInlineMovementStateCutoverPending string = "cutover_pending"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// failed
	// END DEBUGGING
	// StorageUnitInlineMovementStateFailed captures enum value "failed"
	StorageUnitInlineMovementStateFailed string = "failed"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// paused
	// END DEBUGGING
	// StorageUnitInlineMovementStatePaused captures enum value "paused"
	StorageUnitInlineMovementStatePaused string = "paused"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// queued
	// END DEBUGGING
	// StorageUnitInlineMovementStateQueued captures enum value "queued"
	StorageUnitInlineMovementStateQueued string = "queued"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// replicating
	// END DEBUGGING
	// StorageUnitInlineMovementStateReplicating captures enum value "replicating"
	StorageUnitInlineMovementStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// storage_unit_inline_movement
	// StorageUnitInlineMovement
	// state
	// State
	// success
	// END DEBUGGING
	// StorageUnitInlineMovementStateSuccess captures enum value "success"
	StorageUnitInlineMovementStateSuccess string = "success"
)

// prop value enum
func (o *StorageUnitInlineMovement) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineMovementTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineMovement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"movement"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline movement based on the context it is used
func (o *StorageUnitInlineMovement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePercentComplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovement) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMovement) contextValidatePercentComplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"movement"+"."+"percent_complete", "body", o.PercentComplete); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineMovement) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineMovement) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"movement"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovement) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineDestination The destination of a storage unit move operation.
//
swagger:model storage_unit_inline_movement_inline_destination
*/
type StorageUnitInlineMovementInlineDestination struct {

	// storage availability zone
	StorageAvailabilityZone *models.StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`
}

// Validate validates this storage unit inline movement inline destination
func (o *StorageUnitInlineMovementInlineDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestination) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZone) { // not required
		return nil
	}

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination based on the context it is used
func (o *StorageUnitInlineMovementInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestination) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestination) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestination) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone The storage availability zone to which the storage unit is being moved.
//
swagger:model storage_unit_inline_movement_inline_destination_inline_storage_availability_zone
*/
type StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone struct {

	// links
	Links *models.StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline movement inline destination inline storage availability zone
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination inline storage availability zone based on the context it is used
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks storage unit inline movement inline destination inline storage availability zone inline links
swagger:model storage_unit_inline_movement_inline_destination_inline_storage_availability_zone_inline__links
*/
type StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline movement inline destination inline storage availability zone inline links
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline destination inline storage availability zone inline links based on the context it is used
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "destination" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineDestinationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineSource The source of a storage unit move operation.
//
swagger:model storage_unit_inline_movement_inline_source
*/
type StorageUnitInlineMovementInlineSource struct {

	// storage availability zone
	StorageAvailabilityZone *models.StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`
}

// Validate validates this storage unit inline movement inline source
func (o *StorageUnitInlineMovementInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSource) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageAvailabilityZone) { // not required
		return nil
	}

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source based on the context it is used
func (o *StorageUnitInlineMovementInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSource) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageAvailabilityZone != nil {
		if err := o.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSource) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone The storage availability zone from which the storage unit is being moved.
//
swagger:model storage_unit_inline_movement_inline_source_inline_storage_availability_zone
*/
type StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone struct {

	// links
	Links *models.StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline movement inline source inline storage availability zone
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source inline storage availability zone based on the context it is used
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks storage unit inline movement inline source inline storage availability zone inline links
swagger:model storage_unit_inline_movement_inline_source_inline_storage_availability_zone_inline__links
*/
type StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline movement inline source inline storage availability zone inline links
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline movement inline source inline storage availability zone inline links based on the context it is used
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "movement" + "." + "source" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineMovementInlineSourceInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineQosPolicy The QoS policy for the storage unit. Both traditional and adaptive QoS policies are supported.
//
swagger:model storage_unit_inline_qos_policy
*/
type StorageUnitInlineQosPolicy struct {

	// links
	Links *models.StorageUnitInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy.
	//
	// Example: qos1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline qos policy
func (o *StorageUnitInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline qos policy based on the context it is used
func (o *StorageUnitInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineQosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"qos_policy"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineQosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"qos_policy"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineQosPolicyInlineLinks storage unit inline qos policy inline links
swagger:model storage_unit_inline_qos_policy_inline__links
*/
type StorageUnitInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline qos policy inline links
func (o *StorageUnitInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline qos policy inline links based on the context it is used
func (o *StorageUnitInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineSpace The storage space related properties of the storage unit.
//
swagger:model storage_unit_inline_space
*/
type StorageUnitInlineSpace struct {

	// The storage efficiency ratio of the storage unit without snapshots. (Logical Used / Used)
	//
	// Example: 2.5
	// Read Only: true
	EfficiencyRatio *float64 `json:"efficiency_ratio,omitempty"`

	// The number of bytes consumed on the disk by the storage unit, excluding snapshots.
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The number of bytes consumed on the disk by the storage unit's snapshots.
	// This property has been replaced by `space.snapshot.used`.
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsedBySnapshots *int64 `json:"physical_used_by_snapshots,omitempty"`

	// The total provisioned size of the storage unit. The storage unit size can be increased but not decreased using the /api/storage/luns or /api/storage/namespaces endpoints.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform and the available space.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Read Only: true
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *models.StorageUnitInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the storage unit.<br/>
	// This value is the total space consumed, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN or namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN or namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this storage unit inline space
func (o *StorageUnitInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"space"+"."+"size", "body", *o.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"space"+"."+"size", "body", *o.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline space based on the context it is used
func (o *StorageUnitInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEfficiencyRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSpace) contextValidateEfficiencyRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_ratio", "body", o.EfficiencyRatio); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used", "body", o.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpace) contextValidatePhysicalUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"physical_used_by_snapshots", "body", o.PhysicalUsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineSpace) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineSpaceInlineSnapshot storage unit inline space inline snapshot
swagger:model storage_unit_inline_space_inline_snapshot
*/
type StorageUnitInlineSpaceInlineSnapshot struct {

	// autodelete
	Autodelete *models.StorageUnitInlineSpaceInlineSnapshotInlineAutodelete `json:"autodelete,omitempty"`

	// Size available for snapshots within the snapshot reserve, in bytes.
	// Read Only: true
	ReserveAvailable *int64 `json:"reserve_available,omitempty"`

	// The space that has been reserved for snapshot usage, in percent.
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Size that has been reserved for snapshot usage, in bytes.
	// Read Only: true
	ReserveSize *int64 `json:"reserve_size,omitempty"`

	// Percentage of snapshot reserve size that has been used.
	// Read Only: true
	SpaceUsedPercent *int64 `json:"space_used_percent,omitempty"`

	// The total space used by snapshots, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this storage unit inline space inline snapshot
func (o *StorageUnitInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAutodelete(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) validateAutodelete(formats strfmt.Registry) error {
	if swag.IsZero(o.Autodelete) { // not required
		return nil
	}

	if o.Autodelete != nil {
		if err := o.Autodelete.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline space inline snapshot based on the context it is used
func (o *StorageUnitInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAutodelete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReserveAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReserveSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpaceUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) contextValidateAutodelete(ctx context.Context, formats strfmt.Registry) error {

	if o.Autodelete != nil {
		if err := o.Autodelete.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot" + "." + "autodelete")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) contextValidateReserveAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"reserve_available", "body", o.ReserveAvailable); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) contextValidateReserveSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"reserve_size", "body", o.ReserveSize); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) contextValidateSpaceUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"space_used_percent", "body", o.SpaceUsedPercent); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineSpaceInlineSnapshotInlineAutodelete storage unit inline space inline snapshot inline autodelete
swagger:model storage_unit_inline_space_inline_snapshot_inline_autodelete
*/
type StorageUnitInlineSpaceInlineSnapshotInlineAutodelete struct {

	// Specifies whether snapshot autodelete is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this storage unit inline space inline snapshot inline autodelete
func (o *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this storage unit inline space inline snapshot inline autodelete based on context it is used
func (o *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineSpaceInlineSnapshotInlineAutodelete) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSpaceInlineSnapshotInlineAutodelete
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model storage_unit_inline_statistics
*/
type StorageUnitInlineStatistics struct {

	// iops raw
	IopsRaw *models.StorageUnitInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.StorageUnitInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.StorageUnitInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this storage unit inline statistics
func (o *StorageUnitInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var storageUnitInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatisticsTypeStatusPropEnum = append(storageUnitInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusOk captures enum value "ok"
	StorageUnitInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusError captures enum value "error"
	StorageUnitInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	StorageUnitInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	StorageUnitInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	StorageUnitInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	StorageUnitInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusNotFound captures enum value "not_found"
	StorageUnitInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	StorageUnitInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	StorageUnitInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	StorageUnitInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// storage_unit_inline_statistics
	// StorageUnitInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// StorageUnitInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	StorageUnitInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *StorageUnitInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline statistics based on the context it is used
func (o *StorageUnitInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineStatistics) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model storage_unit_inline_statistics_inline_iops_raw
*/
type StorageUnitInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline iops raw
func (o *StorageUnitInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline iops raw based on the context it is used
func (o *StorageUnitInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model storage_unit_inline_statistics_inline_latency_raw
*/
type StorageUnitInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline latency raw
func (o *StorageUnitInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline latency raw based on the context it is used
func (o *StorageUnitInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model storage_unit_inline_statistics_inline_throughput_raw
*/
type StorageUnitInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this storage unit inline statistics inline throughput raw
func (o *StorageUnitInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this storage unit inline statistics inline throughput raw based on the context it is used
func (o *StorageUnitInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineStatus Status information about the storage unit.
//
swagger:model storage_unit_inline_status
*/
type StorageUnitInlineStatus struct {

	// The state of the storage unit and aggregate that contains it. Storage units are only available when their containers are available.
	//
	// Read Only: true
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the storage unit is mapped to one or more hosts.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the storage unit allows only read access.
	//
	// Read Only: true
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the storage unit. Normal states for a storage unit are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Read Only: true
	// Enum: ["foreign_lun_error","nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this storage unit inline status
func (o *StorageUnitInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var storageUnitInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatusTypeContainerStatePropEnum = append(storageUnitInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateOnline captures enum value "online"
	StorageUnitInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	StorageUnitInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// StorageUnitInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	StorageUnitInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (o *StorageUnitInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(o.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := o.validateContainerStateEnum("info"+"."+"status"+"."+"container_state", "body", *o.ContainerState); err != nil {
		return err
	}

	return nil
}

var storageUnitInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["foreign_lun_error","nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitInlineStatusTypeStatePropEnum = append(storageUnitInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// foreign_lun_error
	// END DEBUGGING
	// StorageUnitInlineStatusStateForeignLunError captures enum value "foreign_lun_error"
	StorageUnitInlineStatusStateForeignLunError string = "foreign_lun_error"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// StorageUnitInlineStatusStateNvfail captures enum value "nvfail"
	StorageUnitInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// StorageUnitInlineStatusStateOffline captures enum value "offline"
	StorageUnitInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// StorageUnitInlineStatusStateOnline captures enum value "online"
	StorageUnitInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// storage_unit_inline_status
	// StorageUnitInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// StorageUnitInlineStatusStateSpaceError captures enum value "space_error"
	StorageUnitInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (o *StorageUnitInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"status"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit inline status based on the context it is used
func (o *StorageUnitInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateContainerState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMapped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineStatus) contextValidateContainerState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"container_state", "body", o.ContainerState); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineStatus) contextValidateMapped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"mapped", "body", o.Mapped); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineStatus) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"read_only", "body", o.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineStatus) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineSvm The SVM in which the storage unit is located. Valid in POST.
//
swagger:model storage_unit_inline_svm
*/
type StorageUnitInlineSvm struct {

	// links
	Links *models.StorageUnitInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit inline svm
func (o *StorageUnitInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline svm based on the context it is used
func (o *StorageUnitInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineSvm) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitInlineSvmInlineLinks storage unit inline svm inline links
swagger:model storage_unit_inline_svm_inline__links
*/
type StorageUnitInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit inline svm inline links
func (o *StorageUnitInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit inline svm inline links based on the context it is used
func (o *StorageUnitInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
