// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewStorageUnitModifyParams creates a new StorageUnitModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageUnitModifyParams() *StorageUnitModifyParams {
	return &StorageUnitModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageUnitModifyParamsWithTimeout creates a new StorageUnitModifyParams object
// with the ability to set a timeout on a request.
func NewStorageUnitModifyParamsWithTimeout(timeout time.Duration) *StorageUnitModifyParams {
	return &StorageUnitModifyParams{
		timeout: timeout,
	}
}

// NewStorageUnitModifyParamsWithContext creates a new StorageUnitModifyParams object
// with the ability to set a context for a request.
func NewStorageUnitModifyParamsWithContext(ctx context.Context) *StorageUnitModifyParams {
	return &StorageUnitModifyParams{
		Context: ctx,
	}
}

// NewStorageUnitModifyParamsWithHTTPClient creates a new StorageUnitModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageUnitModifyParamsWithHTTPClient(client *http.Client) *StorageUnitModifyParams {
	return &StorageUnitModifyParams{
		HTTPClient: client,
	}
}

/*
StorageUnitModifyParams contains all the parameters to send to the API endpoint

	for the storage unit modify operation.

	Typically these are written to a http.Request.
*/
type StorageUnitModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.StorageUnit

	/* RestoreToByteCount.

	   The number of bytes to restore from the source storage unit, in multiples of 4096. When set, `restore_to.start_byte` must also be set. Setting these parameters requires also setting `restore_to.keep_snapshots` to `true`.

	*/
	RestoreToByteCount *float64

	/* RestoreToKeepSnapshots.

	     Requests that snapshots created after the restored snapshot be retained for the storage unit.
	- If `false`, all snapshots created after the restored snapshot are deleted when the snapshot is restored.
	- If `true`, all snapshots created after the restored snapshot are retained when the snapshot is restored.
	This must be set to `true` when `restore_to.start_byte` and `restore_to.byte_count` are set or when called for a secondary storage unit.<br/>


	*/
	RestoreToKeepSnapshots *bool

	/* RestoreToSnapshotName.

	   The name of the snapshot to restore the storage unit to the point in time at which the snapshot was taken.

	*/
	RestoreToSnapshotName *string

	/* RestoreToSnapshotUUID.

	   The UUID of the snapshot to restore the storage unit to the point in time at which the snapshot was taken.

	*/
	RestoreToSnapshotUUID *string

	/* RestoreToStartByte.

	   The starting byte offset of the source storage unit, in multiples of 4096. When set, `restore_to.byte_count` must also be set. Setting these parameters requires also setting `restore_to.keep_snapshots` to `true`.

	*/
	RestoreToStartByte *float64

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   The unique identifier of the storage unit.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage unit modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitModifyParams) WithDefaults() *StorageUnitModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage unit modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitModifyParams) SetDefaults() {
	var (
		restoreToKeepSnapshotsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := StorageUnitModifyParams{
		RestoreToKeepSnapshots: &restoreToKeepSnapshotsDefault,
		ReturnTimeout:          &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage unit modify params
func (o *StorageUnitModifyParams) WithTimeout(timeout time.Duration) *StorageUnitModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage unit modify params
func (o *StorageUnitModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage unit modify params
func (o *StorageUnitModifyParams) WithContext(ctx context.Context) *StorageUnitModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage unit modify params
func (o *StorageUnitModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage unit modify params
func (o *StorageUnitModifyParams) WithHTTPClient(client *http.Client) *StorageUnitModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage unit modify params
func (o *StorageUnitModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the storage unit modify params
func (o *StorageUnitModifyParams) WithInfo(info *models.StorageUnit) *StorageUnitModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage unit modify params
func (o *StorageUnitModifyParams) SetInfo(info *models.StorageUnit) {
	o.Info = info
}

// WithRestoreToByteCount adds the restoreToByteCount to the storage unit modify params
func (o *StorageUnitModifyParams) WithRestoreToByteCount(restoreToByteCount *float64) *StorageUnitModifyParams {
	o.SetRestoreToByteCount(restoreToByteCount)
	return o
}

// SetRestoreToByteCount adds the restoreToByteCount to the storage unit modify params
func (o *StorageUnitModifyParams) SetRestoreToByteCount(restoreToByteCount *float64) {
	o.RestoreToByteCount = restoreToByteCount
}

// WithRestoreToKeepSnapshots adds the restoreToKeepSnapshots to the storage unit modify params
func (o *StorageUnitModifyParams) WithRestoreToKeepSnapshots(restoreToKeepSnapshots *bool) *StorageUnitModifyParams {
	o.SetRestoreToKeepSnapshots(restoreToKeepSnapshots)
	return o
}

// SetRestoreToKeepSnapshots adds the restoreToKeepSnapshots to the storage unit modify params
func (o *StorageUnitModifyParams) SetRestoreToKeepSnapshots(restoreToKeepSnapshots *bool) {
	o.RestoreToKeepSnapshots = restoreToKeepSnapshots
}

// WithRestoreToSnapshotName adds the restoreToSnapshotName to the storage unit modify params
func (o *StorageUnitModifyParams) WithRestoreToSnapshotName(restoreToSnapshotName *string) *StorageUnitModifyParams {
	o.SetRestoreToSnapshotName(restoreToSnapshotName)
	return o
}

// SetRestoreToSnapshotName adds the restoreToSnapshotName to the storage unit modify params
func (o *StorageUnitModifyParams) SetRestoreToSnapshotName(restoreToSnapshotName *string) {
	o.RestoreToSnapshotName = restoreToSnapshotName
}

// WithRestoreToSnapshotUUID adds the restoreToSnapshotUUID to the storage unit modify params
func (o *StorageUnitModifyParams) WithRestoreToSnapshotUUID(restoreToSnapshotUUID *string) *StorageUnitModifyParams {
	o.SetRestoreToSnapshotUUID(restoreToSnapshotUUID)
	return o
}

// SetRestoreToSnapshotUUID adds the restoreToSnapshotUuid to the storage unit modify params
func (o *StorageUnitModifyParams) SetRestoreToSnapshotUUID(restoreToSnapshotUUID *string) {
	o.RestoreToSnapshotUUID = restoreToSnapshotUUID
}

// WithRestoreToStartByte adds the restoreToStartByte to the storage unit modify params
func (o *StorageUnitModifyParams) WithRestoreToStartByte(restoreToStartByte *float64) *StorageUnitModifyParams {
	o.SetRestoreToStartByte(restoreToStartByte)
	return o
}

// SetRestoreToStartByte adds the restoreToStartByte to the storage unit modify params
func (o *StorageUnitModifyParams) SetRestoreToStartByte(restoreToStartByte *float64) {
	o.RestoreToStartByte = restoreToStartByte
}

// WithReturnTimeout adds the returnTimeout to the storage unit modify params
func (o *StorageUnitModifyParams) WithReturnTimeout(returnTimeout *int64) *StorageUnitModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage unit modify params
func (o *StorageUnitModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the storage unit modify params
func (o *StorageUnitModifyParams) WithUUID(uuid string) *StorageUnitModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the storage unit modify params
func (o *StorageUnitModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *StorageUnitModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.RestoreToByteCount != nil {

		// query param restore_to.byte_count
		var qrRestoreToByteCount float64

		if o.RestoreToByteCount != nil {
			qrRestoreToByteCount = *o.RestoreToByteCount
		}
		qRestoreToByteCount := swag.FormatFloat64(qrRestoreToByteCount)
		if qRestoreToByteCount != "" {

			if err := r.SetQueryParam("restore_to.byte_count", qRestoreToByteCount); err != nil {
				return err
			}
		}
	}

	if o.RestoreToKeepSnapshots != nil {

		// query param restore_to.keep_snapshots
		var qrRestoreToKeepSnapshots bool

		if o.RestoreToKeepSnapshots != nil {
			qrRestoreToKeepSnapshots = *o.RestoreToKeepSnapshots
		}
		qRestoreToKeepSnapshots := swag.FormatBool(qrRestoreToKeepSnapshots)
		if qRestoreToKeepSnapshots != "" {

			if err := r.SetQueryParam("restore_to.keep_snapshots", qRestoreToKeepSnapshots); err != nil {
				return err
			}
		}
	}

	if o.RestoreToSnapshotName != nil {

		// query param restore_to.snapshot.name
		var qrRestoreToSnapshotName string

		if o.RestoreToSnapshotName != nil {
			qrRestoreToSnapshotName = *o.RestoreToSnapshotName
		}
		qRestoreToSnapshotName := qrRestoreToSnapshotName
		if qRestoreToSnapshotName != "" {

			if err := r.SetQueryParam("restore_to.snapshot.name", qRestoreToSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.RestoreToSnapshotUUID != nil {

		// query param restore_to.snapshot.uuid
		var qrRestoreToSnapshotUUID string

		if o.RestoreToSnapshotUUID != nil {
			qrRestoreToSnapshotUUID = *o.RestoreToSnapshotUUID
		}
		qRestoreToSnapshotUUID := qrRestoreToSnapshotUUID
		if qRestoreToSnapshotUUID != "" {

			if err := r.SetQueryParam("restore_to.snapshot.uuid", qRestoreToSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.RestoreToStartByte != nil {

		// query param restore_to.start_byte
		var qrRestoreToStartByte float64

		if o.RestoreToStartByte != nil {
			qrRestoreToStartByte = *o.RestoreToStartByte
		}
		qRestoreToStartByte := swag.FormatFloat64(qrRestoreToStartByte)
		if qRestoreToStartByte != "" {

			if err := r.SetQueryParam("restore_to.start_byte", qRestoreToStartByte); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
