// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitModifyReader is a Reader for the StorageUnitModify structure.
type StorageUnitModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitModifyOK creates a StorageUnitModifyOK with default headers values
func NewStorageUnitModifyOK() *StorageUnitModifyOK {
	return &StorageUnitModifyOK{}
}

/*
StorageUnitModifyOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitModifyOK struct {
	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit modify o k response has a 2xx status code
func (o *StorageUnitModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit modify o k response has a 3xx status code
func (o *StorageUnitModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit modify o k response has a 4xx status code
func (o *StorageUnitModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit modify o k response has a 5xx status code
func (o *StorageUnitModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit modify o k response a status code equal to that given
func (o *StorageUnitModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit modify o k response
func (o *StorageUnitModifyOK) Code() int {
	return 200
}

func (o *StorageUnitModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storageUnitModifyOK %s", 200, payload)
}

func (o *StorageUnitModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storageUnitModifyOK %s", 200, payload)
}

func (o *StorageUnitModifyOK) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitModifyAccepted creates a StorageUnitModifyAccepted with default headers values
func NewStorageUnitModifyAccepted() *StorageUnitModifyAccepted {
	return &StorageUnitModifyAccepted{}
}

/*
StorageUnitModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitModifyAccepted struct {
	Payload *models.StorageUnitJobLinkResponse
}

// IsSuccess returns true when this storage unit modify accepted response has a 2xx status code
func (o *StorageUnitModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit modify accepted response has a 3xx status code
func (o *StorageUnitModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit modify accepted response has a 4xx status code
func (o *StorageUnitModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit modify accepted response has a 5xx status code
func (o *StorageUnitModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit modify accepted response a status code equal to that given
func (o *StorageUnitModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit modify accepted response
func (o *StorageUnitModifyAccepted) Code() int {
	return 202
}

func (o *StorageUnitModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storageUnitModifyAccepted %s", 202, payload)
}

func (o *StorageUnitModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storageUnitModifyAccepted %s", 202, payload)
}

func (o *StorageUnitModifyAccepted) GetPayload() *models.StorageUnitJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitModifyDefault creates a StorageUnitModifyDefault with default headers values
func NewStorageUnitModifyDefault(code int) *StorageUnitModifyDefault {
	return &StorageUnitModifyDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1638592 | The specified snapshot UUID is not correct for the specified snapshot name. |
| 1638600 | The specified snapshot does not exist. |
| 5374614 | A non-existent storage availability zone was specified. |
| 5376461 | An invalid storage unit name was specified. |
| 5376497 | The storage unit move operation is not ready for cutover. |
| 5376499 | The storage unit move operation cannot be paused. |
| 5376500 | The storage unit move operation is not paused. |
| 5376508 | A storage unit move operation of a secondary storage unit is not supported. To move a secondary storage unit, you must move the associated primary storage unit which moves all of the secondary storage units. |
| 5376509 | Storage unit move operations are not allowed for an SVM administrator. |
| 5376510 | Storage unit move operation is not allowed for protocol endpoints. |
| 5376511 | A storage unit move operation is already in progress for the storage unit. |
| 5376512 | A storage unit move operation is not in progress for the storage unit. |
| 5376513 | An attempt was made to patch a storage unit move operation state to an unsupported state. Allowed states are aborted, cutover, paused, replicating, and cutover_wait. |
| 5376518 | The storage unit move operation cannot be paused at the current time. Wait and try again. |
| 5376521 | An attempt was made to modify a property of a secondary storage unit that can only be modified via the primary storage unit. |
| 5376522 | Storage unit clone-related operations are not supported on a secondary storage unit. You must perform a clone-related operation on the associated primary storage unit which is then applied to all of the secondary storage units. |
| 5376523 | Query parameter `restore_to.snapshot.name` or `restore_to.snapshot.uuid` must be supplied when supplying other `restore_to` query parameters. |
| 5376524 | The specified query parameter requires `restore_to.keep_snapshots` to be `true`. |
| 5376525 | Query parameter `restore_to.keep_snapshots` must be `true` for secondary storage units. |
| 5376526 | Query parameter `restore_to.start_byte` and `restore_to.byte_count` must both be supplied to request a partial storage unit snapshot restore. |
| 5376527 | Query parameter `restore_to.start_byte` and `restore_to.byte_count` must both be increments of 4096. |
| 5376530 | The specified storage unit does not exist in the specified snapshot. |
| 203161607 | An attempt to set the anti-ransomware state to dry-run when it is already enabled. |
| 203161610 | An attempt pause anti-ransomware checking when it is in a conflicting state. |
| 203161611 | An attempt to resume anti-ransomware checking when it is in a conflicting state. |
| 203161613 | Anti-ransomware is disabled. |
| 203161623 | Anti-ransomware is being disabled. |
| 203161633 | An attempt to resume anti-ransomware checking when it is paused in a conflicting state. |
| 203161642 | An attempt to set the anti-ransomware state to dry-run-paused when it is already enabled. |
| 203161643 | An attempt to set the anti-ransomware state to enable-paused when it is already enabled. |
| 203161644 | An attempt to set the anti-ransomware state to a disallowed value. |
| 203161645 | An attempt to set the anti-ransomware on a storage unit that is moving. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit modify default response has a 2xx status code
func (o *StorageUnitModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit modify default response has a 3xx status code
func (o *StorageUnitModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit modify default response has a 4xx status code
func (o *StorageUnitModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit modify default response has a 5xx status code
func (o *StorageUnitModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit modify default response a status code equal to that given
func (o *StorageUnitModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit modify default response
func (o *StorageUnitModifyDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storage_unit_modify default %s", o._statusCode, payload)
}

func (o *StorageUnitModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{uuid}][%d] storage_unit_modify default %s", o._statusCode, payload)
}

func (o *StorageUnitModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
