// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewStorageUnitSnapshotCreateParams creates a new StorageUnitSnapshotCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStorageUnitSnapshotCreateParams() *StorageUnitSnapshotCreateParams {
	return &StorageUnitSnapshotCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStorageUnitSnapshotCreateParamsWithTimeout creates a new StorageUnitSnapshotCreateParams object
// with the ability to set a timeout on a request.
func NewStorageUnitSnapshotCreateParamsWithTimeout(timeout time.Duration) *StorageUnitSnapshotCreateParams {
	return &StorageUnitSnapshotCreateParams{
		timeout: timeout,
	}
}

// NewStorageUnitSnapshotCreateParamsWithContext creates a new StorageUnitSnapshotCreateParams object
// with the ability to set a context for a request.
func NewStorageUnitSnapshotCreateParamsWithContext(ctx context.Context) *StorageUnitSnapshotCreateParams {
	return &StorageUnitSnapshotCreateParams{
		Context: ctx,
	}
}

// NewStorageUnitSnapshotCreateParamsWithHTTPClient creates a new StorageUnitSnapshotCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewStorageUnitSnapshotCreateParamsWithHTTPClient(client *http.Client) *StorageUnitSnapshotCreateParams {
	return &StorageUnitSnapshotCreateParams{
		HTTPClient: client,
	}
}

/*
StorageUnitSnapshotCreateParams contains all the parameters to send to the API endpoint

	for the storage unit snapshot create operation.

	Typically these are written to a http.Request.
*/
type StorageUnitSnapshotCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.StorageUnitSnapshot

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* StorageUnitUUID.

	   Storage Unit UUID
	*/
	StorageUnitUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the storage unit snapshot create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitSnapshotCreateParams) WithDefaults() *StorageUnitSnapshotCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the storage unit snapshot create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StorageUnitSnapshotCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := StorageUnitSnapshotCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithTimeout(timeout time.Duration) *StorageUnitSnapshotCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithContext(ctx context.Context) *StorageUnitSnapshotCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithHTTPClient(client *http.Client) *StorageUnitSnapshotCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithInfo(info *models.StorageUnitSnapshot) *StorageUnitSnapshotCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetInfo(info *models.StorageUnitSnapshot) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithReturnRecords(returnRecords *bool) *StorageUnitSnapshotCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithReturnTimeout(returnTimeout *int64) *StorageUnitSnapshotCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStorageUnitUUID adds the storageUnitUUID to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) WithStorageUnitUUID(storageUnitUUID string) *StorageUnitSnapshotCreateParams {
	o.SetStorageUnitUUID(storageUnitUUID)
	return o
}

// SetStorageUnitUUID adds the storageUnitUuid to the storage unit snapshot create params
func (o *StorageUnitSnapshotCreateParams) SetStorageUnitUUID(storageUnitUUID string) {
	o.StorageUnitUUID = storageUnitUUID
}

// WriteToRequest writes these params to a swagger request
func (o *StorageUnitSnapshotCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param storage_unit.uuid
	if err := r.SetPathParam("storage_unit.uuid", o.StorageUnitUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
