// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitSnapshotCreateReader is a Reader for the StorageUnitSnapshotCreate structure.
type StorageUnitSnapshotCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitSnapshotCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewStorageUnitSnapshotCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitSnapshotCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitSnapshotCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitSnapshotCreateCreated creates a StorageUnitSnapshotCreateCreated with default headers values
func NewStorageUnitSnapshotCreateCreated() *StorageUnitSnapshotCreateCreated {
	return &StorageUnitSnapshotCreateCreated{}
}

/*
StorageUnitSnapshotCreateCreated describes a response with status code 201, with default header values.

Created
*/
type StorageUnitSnapshotCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot create created response has a 2xx status code
func (o *StorageUnitSnapshotCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot create created response has a 3xx status code
func (o *StorageUnitSnapshotCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot create created response has a 4xx status code
func (o *StorageUnitSnapshotCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot create created response has a 5xx status code
func (o *StorageUnitSnapshotCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot create created response a status code equal to that given
func (o *StorageUnitSnapshotCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the storage unit snapshot create created response
func (o *StorageUnitSnapshotCreateCreated) Code() int {
	return 201
}

func (o *StorageUnitSnapshotCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotCreateCreated %s", 201, payload)
}

func (o *StorageUnitSnapshotCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotCreateCreated %s", 201, payload)
}

func (o *StorageUnitSnapshotCreateCreated) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotCreateAccepted creates a StorageUnitSnapshotCreateAccepted with default headers values
func NewStorageUnitSnapshotCreateAccepted() *StorageUnitSnapshotCreateAccepted {
	return &StorageUnitSnapshotCreateAccepted{}
}

/*
StorageUnitSnapshotCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitSnapshotCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot create accepted response has a 2xx status code
func (o *StorageUnitSnapshotCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot create accepted response has a 3xx status code
func (o *StorageUnitSnapshotCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot create accepted response has a 4xx status code
func (o *StorageUnitSnapshotCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot create accepted response has a 5xx status code
func (o *StorageUnitSnapshotCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot create accepted response a status code equal to that given
func (o *StorageUnitSnapshotCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit snapshot create accepted response
func (o *StorageUnitSnapshotCreateAccepted) Code() int {
	return 202
}

func (o *StorageUnitSnapshotCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotCreateAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotCreateAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotCreateAccepted) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotCreateDefault creates a StorageUnitSnapshotCreateDefault with default headers values
func NewStorageUnitSnapshotCreateDefault(code int) *StorageUnitSnapshotCreateDefault {
	return &StorageUnitSnapshotCreateDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitSnapshotCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 524479 | The specified volume is not online or does not have enough space to create a snapshot. |
| 525059 | A snapshot with the specified name already exists. |
| 525062 | Cannot exceed maximum number of snapshots. |
| 1258207 | Snapshot operation is not allowed. |
| 1638461 | Snapshots can only be created on read/write (RW) storage units. |
| 1638477 | User-created snapshot names cannot begin with the specified prefix. |
| 1638518 | The specified snapshot name is invalid. |
| 1638532 | Failed to create the snapshot on the specified volume because a revert operation is in progress. |
| 1638537 | Cannot determine the status of the snapshot create operation for the specified volume. |
| 1638616 | Bulk snapshot create is not supported with multiple snapshot names. |
| 1638617 | Bulk snapshot create is not supported with volume names in a mixed-version cluster. |
| 1638618 | The property cannot be specified for snapshot create. |
| 1638630 | Snapshot create operation is not supported on destination of SnapMirror active sync relationship with policy-type "automated-failover-duplex". |
| 2621462 | The specified SVM name does not exist. |
| 5376459 | The specified properties refer to different storage units. |
| 5376489 | Storage unit not found in SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitSnapshotCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit snapshot create default response has a 2xx status code
func (o *StorageUnitSnapshotCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit snapshot create default response has a 3xx status code
func (o *StorageUnitSnapshotCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit snapshot create default response has a 4xx status code
func (o *StorageUnitSnapshotCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit snapshot create default response has a 5xx status code
func (o *StorageUnitSnapshotCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit snapshot create default response a status code equal to that given
func (o *StorageUnitSnapshotCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit snapshot create default response
func (o *StorageUnitSnapshotCreateDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitSnapshotCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_create default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_create default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
