// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitSnapshotDeleteCollectionReader is a Reader for the StorageUnitSnapshotDeleteCollection structure.
type StorageUnitSnapshotDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitSnapshotDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitSnapshotDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitSnapshotDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitSnapshotDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitSnapshotDeleteCollectionOK creates a StorageUnitSnapshotDeleteCollectionOK with default headers values
func NewStorageUnitSnapshotDeleteCollectionOK() *StorageUnitSnapshotDeleteCollectionOK {
	return &StorageUnitSnapshotDeleteCollectionOK{}
}

/*
StorageUnitSnapshotDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitSnapshotDeleteCollectionOK struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot delete collection o k response has a 2xx status code
func (o *StorageUnitSnapshotDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot delete collection o k response has a 3xx status code
func (o *StorageUnitSnapshotDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot delete collection o k response has a 4xx status code
func (o *StorageUnitSnapshotDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot delete collection o k response has a 5xx status code
func (o *StorageUnitSnapshotDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot delete collection o k response a status code equal to that given
func (o *StorageUnitSnapshotDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit snapshot delete collection o k response
func (o *StorageUnitSnapshotDeleteCollectionOK) Code() int {
	return 200
}

func (o *StorageUnitSnapshotDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionOK) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotDeleteCollectionAccepted creates a StorageUnitSnapshotDeleteCollectionAccepted with default headers values
func NewStorageUnitSnapshotDeleteCollectionAccepted() *StorageUnitSnapshotDeleteCollectionAccepted {
	return &StorageUnitSnapshotDeleteCollectionAccepted{}
}

/*
StorageUnitSnapshotDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitSnapshotDeleteCollectionAccepted struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot delete collection accepted response has a 2xx status code
func (o *StorageUnitSnapshotDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot delete collection accepted response has a 3xx status code
func (o *StorageUnitSnapshotDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot delete collection accepted response has a 4xx status code
func (o *StorageUnitSnapshotDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot delete collection accepted response has a 5xx status code
func (o *StorageUnitSnapshotDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot delete collection accepted response a status code equal to that given
func (o *StorageUnitSnapshotDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit snapshot delete collection accepted response
func (o *StorageUnitSnapshotDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *StorageUnitSnapshotDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionAccepted) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotDeleteCollectionDefault creates a StorageUnitSnapshotDeleteCollectionDefault with default headers values
func NewStorageUnitSnapshotDeleteCollectionDefault(code int) *StorageUnitSnapshotDeleteCollectionDefault {
	return &StorageUnitSnapshotDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitSnapshotDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 524481 | Snapshot was not deleted because the associated volume is locked or fenced. |
| 1638483 | Snapshots cannot be deleted when used as a reference snapshot by one or more SnapMirror relationships. |
| 1638521 | Snapshots can only be deleted on read/write (RW) volumes. |
| 1638538 | Cannot determine the status of the snapshot delete operation for the specified volume. |
| 1638543 | Failed to delete snapshot because it has an owner. |
| 1638555 | The specified snapshot has not expired or is locked. |
| 1638600 | The snapshot does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitSnapshotDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit snapshot delete collection default response has a 2xx status code
func (o *StorageUnitSnapshotDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit snapshot delete collection default response has a 3xx status code
func (o *StorageUnitSnapshotDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit snapshot delete collection default response has a 4xx status code
func (o *StorageUnitSnapshotDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit snapshot delete collection default response has a 5xx status code
func (o *StorageUnitSnapshotDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit snapshot delete collection default response a status code equal to that given
func (o *StorageUnitSnapshotDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit snapshot delete collection default response
func (o *StorageUnitSnapshotDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitSnapshotDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StorageUnitSnapshotDeleteCollectionBody storage unit snapshot delete collection body
swagger:model StorageUnitSnapshotDeleteCollectionBody
*/
type StorageUnitSnapshotDeleteCollectionBody struct {

	// Space reclaimed when the snapshot is deleted, in bytes.
	//
	// Read Only: true
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// storage unit snapshot response inline records
	StorageUnitSnapshotResponseInlineRecords []*models.StorageUnitSnapshot `json:"records,omitempty"`
}

// Validate validates this storage unit snapshot delete collection body
func (o *StorageUnitSnapshotDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStorageUnitSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotDeleteCollectionBody) validateStorageUnitSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnitSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageUnitSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.StorageUnitSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StorageUnitSnapshotResponseInlineRecords[i] != nil {
			if err := o.StorageUnitSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this storage unit snapshot delete collection body based on the context it is used
func (o *StorageUnitSnapshotDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReclaimableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnitSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotDeleteCollectionBody) contextValidateReclaimableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reclaimable_space", "body", o.ReclaimableSpace); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotDeleteCollectionBody) contextValidateStorageUnitSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StorageUnitSnapshotResponseInlineRecords); i++ {

		if o.StorageUnitSnapshotResponseInlineRecords[i] != nil {
			if err := o.StorageUnitSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
