// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitSnapshotDeleteReader is a Reader for the StorageUnitSnapshotDelete structure.
type StorageUnitSnapshotDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitSnapshotDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitSnapshotDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitSnapshotDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitSnapshotDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitSnapshotDeleteOK creates a StorageUnitSnapshotDeleteOK with default headers values
func NewStorageUnitSnapshotDeleteOK() *StorageUnitSnapshotDeleteOK {
	return &StorageUnitSnapshotDeleteOK{}
}

/*
StorageUnitSnapshotDeleteOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitSnapshotDeleteOK struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot delete o k response has a 2xx status code
func (o *StorageUnitSnapshotDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot delete o k response has a 3xx status code
func (o *StorageUnitSnapshotDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot delete o k response has a 4xx status code
func (o *StorageUnitSnapshotDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot delete o k response has a 5xx status code
func (o *StorageUnitSnapshotDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot delete o k response a status code equal to that given
func (o *StorageUnitSnapshotDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit snapshot delete o k response
func (o *StorageUnitSnapshotDeleteOK) Code() int {
	return 200
}

func (o *StorageUnitSnapshotDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotDeleteOK %s", 200, payload)
}

func (o *StorageUnitSnapshotDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotDeleteOK %s", 200, payload)
}

func (o *StorageUnitSnapshotDeleteOK) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotDeleteAccepted creates a StorageUnitSnapshotDeleteAccepted with default headers values
func NewStorageUnitSnapshotDeleteAccepted() *StorageUnitSnapshotDeleteAccepted {
	return &StorageUnitSnapshotDeleteAccepted{}
}

/*
StorageUnitSnapshotDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitSnapshotDeleteAccepted struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot delete accepted response has a 2xx status code
func (o *StorageUnitSnapshotDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot delete accepted response has a 3xx status code
func (o *StorageUnitSnapshotDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot delete accepted response has a 4xx status code
func (o *StorageUnitSnapshotDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot delete accepted response has a 5xx status code
func (o *StorageUnitSnapshotDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot delete accepted response a status code equal to that given
func (o *StorageUnitSnapshotDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit snapshot delete accepted response
func (o *StorageUnitSnapshotDeleteAccepted) Code() int {
	return 202
}

func (o *StorageUnitSnapshotDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotDeleteAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotDeleteAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotDeleteAccepted) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotDeleteDefault creates a StorageUnitSnapshotDeleteDefault with default headers values
func NewStorageUnitSnapshotDeleteDefault(code int) *StorageUnitSnapshotDeleteDefault {
	return &StorageUnitSnapshotDeleteDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitSnapshotDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 524481 | Snapshot was not deleted because the associated volume is locked or fenced. |
| 1638483 | Snapshots cannot be deleted when used as a reference snapshot by one or more SnapMirror relationships. |
| 1638521 | Snapshots can only be deleted on read/write (RW) volumes. |
| 1638538 | Cannot determine the status of the snapshot delete operation for the specified volume. |
| 1638543 | Failed to delete snapshot because it has an owner. |
| 1638555 | The specified snapshot has not expired or is locked. |
| 1638600 | The snapshot does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitSnapshotDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit snapshot delete default response has a 2xx status code
func (o *StorageUnitSnapshotDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit snapshot delete default response has a 3xx status code
func (o *StorageUnitSnapshotDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit snapshot delete default response has a 4xx status code
func (o *StorageUnitSnapshotDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit snapshot delete default response has a 5xx status code
func (o *StorageUnitSnapshotDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit snapshot delete default response a status code equal to that given
func (o *StorageUnitSnapshotDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit snapshot delete default response
func (o *StorageUnitSnapshotDeleteDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitSnapshotDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storage_unit_snapshot_delete default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storage_unit_snapshot_delete default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
