// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitSnapshotGetReader is a Reader for the StorageUnitSnapshotGet structure.
type StorageUnitSnapshotGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitSnapshotGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitSnapshotGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitSnapshotGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitSnapshotGetOK creates a StorageUnitSnapshotGetOK with default headers values
func NewStorageUnitSnapshotGetOK() *StorageUnitSnapshotGetOK {
	return &StorageUnitSnapshotGetOK{}
}

/*
StorageUnitSnapshotGetOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitSnapshotGetOK struct {
	Payload *models.StorageUnitSnapshot
}

// IsSuccess returns true when this storage unit snapshot get o k response has a 2xx status code
func (o *StorageUnitSnapshotGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot get o k response has a 3xx status code
func (o *StorageUnitSnapshotGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot get o k response has a 4xx status code
func (o *StorageUnitSnapshotGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot get o k response has a 5xx status code
func (o *StorageUnitSnapshotGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot get o k response a status code equal to that given
func (o *StorageUnitSnapshotGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit snapshot get o k response
func (o *StorageUnitSnapshotGetOK) Code() int {
	return 200
}

func (o *StorageUnitSnapshotGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotGetOK %s", 200, payload)
}

func (o *StorageUnitSnapshotGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storageUnitSnapshotGetOK %s", 200, payload)
}

func (o *StorageUnitSnapshotGetOK) GetPayload() *models.StorageUnitSnapshot {
	return o.Payload
}

func (o *StorageUnitSnapshotGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshot)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotGetDefault creates a StorageUnitSnapshotGetDefault with default headers values
func NewStorageUnitSnapshotGetDefault(code int) *StorageUnitSnapshotGetDefault {
	return &StorageUnitSnapshotGetDefault{
		_statusCode: code,
	}
}

/*
StorageUnitSnapshotGetDefault describes a response with status code -1, with default header values.

Error
*/
type StorageUnitSnapshotGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit snapshot get default response has a 2xx status code
func (o *StorageUnitSnapshotGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit snapshot get default response has a 3xx status code
func (o *StorageUnitSnapshotGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit snapshot get default response has a 4xx status code
func (o *StorageUnitSnapshotGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit snapshot get default response has a 5xx status code
func (o *StorageUnitSnapshotGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit snapshot get default response a status code equal to that given
func (o *StorageUnitSnapshotGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit snapshot get default response
func (o *StorageUnitSnapshotGetDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitSnapshotGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storage_unit_snapshot_get default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/storage-units/{storage_unit.uuid}/snapshots/{uuid}][%d] storage_unit_snapshot_get default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
