// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// StorageUnitSnapshotModifyCollectionReader is a Reader for the StorageUnitSnapshotModifyCollection structure.
type StorageUnitSnapshotModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StorageUnitSnapshotModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStorageUnitSnapshotModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewStorageUnitSnapshotModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStorageUnitSnapshotModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStorageUnitSnapshotModifyCollectionOK creates a StorageUnitSnapshotModifyCollectionOK with default headers values
func NewStorageUnitSnapshotModifyCollectionOK() *StorageUnitSnapshotModifyCollectionOK {
	return &StorageUnitSnapshotModifyCollectionOK{}
}

/*
StorageUnitSnapshotModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type StorageUnitSnapshotModifyCollectionOK struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot modify collection o k response has a 2xx status code
func (o *StorageUnitSnapshotModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot modify collection o k response has a 3xx status code
func (o *StorageUnitSnapshotModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot modify collection o k response has a 4xx status code
func (o *StorageUnitSnapshotModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot modify collection o k response has a 5xx status code
func (o *StorageUnitSnapshotModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot modify collection o k response a status code equal to that given
func (o *StorageUnitSnapshotModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the storage unit snapshot modify collection o k response
func (o *StorageUnitSnapshotModifyCollectionOK) Code() int {
	return 200
}

func (o *StorageUnitSnapshotModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotModifyCollectionOK %s", 200, payload)
}

func (o *StorageUnitSnapshotModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotModifyCollectionOK %s", 200, payload)
}

func (o *StorageUnitSnapshotModifyCollectionOK) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotModifyCollectionAccepted creates a StorageUnitSnapshotModifyCollectionAccepted with default headers values
func NewStorageUnitSnapshotModifyCollectionAccepted() *StorageUnitSnapshotModifyCollectionAccepted {
	return &StorageUnitSnapshotModifyCollectionAccepted{}
}

/*
StorageUnitSnapshotModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type StorageUnitSnapshotModifyCollectionAccepted struct {
	Payload *models.StorageUnitSnapshotJobLinkResponse
}

// IsSuccess returns true when this storage unit snapshot modify collection accepted response has a 2xx status code
func (o *StorageUnitSnapshotModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this storage unit snapshot modify collection accepted response has a 3xx status code
func (o *StorageUnitSnapshotModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this storage unit snapshot modify collection accepted response has a 4xx status code
func (o *StorageUnitSnapshotModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this storage unit snapshot modify collection accepted response has a 5xx status code
func (o *StorageUnitSnapshotModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this storage unit snapshot modify collection accepted response a status code equal to that given
func (o *StorageUnitSnapshotModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the storage unit snapshot modify collection accepted response
func (o *StorageUnitSnapshotModifyCollectionAccepted) Code() int {
	return 202
}

func (o *StorageUnitSnapshotModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storageUnitSnapshotModifyCollectionAccepted %s", 202, payload)
}

func (o *StorageUnitSnapshotModifyCollectionAccepted) GetPayload() *models.StorageUnitSnapshotJobLinkResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.StorageUnitSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStorageUnitSnapshotModifyCollectionDefault creates a StorageUnitSnapshotModifyCollectionDefault with default headers values
func NewStorageUnitSnapshotModifyCollectionDefault(code int) *StorageUnitSnapshotModifyCollectionDefault {
	return &StorageUnitSnapshotModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	StorageUnitSnapshotModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 524508 | The snapshot was not renamed because the name entered is not valid. |
| 1638455 | Failed to set comment for snapshot. |
| 1638476 | You cannot rename a snapshot created for use as a reference snapshot by other jobs. |
| 1638477 | User-created snapshot names cannot begin with the specified prefix. |
| 1638518 | The specified snapshot name is invalid. |
| 1638522 | Snapshots can only be renamed on read/write (RW) volumes. |
| 1638523 | Failed to set the specified SnapMirror label for the snapshot. |
| 1638524 | Adding SnapMirror labels is not allowed in a mixed version cluster. |
| 1638539 | Cannot determine the status of the snapshot rename operation for the specified volume. |
| 1638554 | Failed to set expiry time for the snapshot. |
| 1638600 | The snapshot does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type StorageUnitSnapshotModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this storage unit snapshot modify collection default response has a 2xx status code
func (o *StorageUnitSnapshotModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this storage unit snapshot modify collection default response has a 3xx status code
func (o *StorageUnitSnapshotModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this storage unit snapshot modify collection default response has a 4xx status code
func (o *StorageUnitSnapshotModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this storage unit snapshot modify collection default response has a 5xx status code
func (o *StorageUnitSnapshotModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this storage unit snapshot modify collection default response a status code equal to that given
func (o *StorageUnitSnapshotModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the storage unit snapshot modify collection default response
func (o *StorageUnitSnapshotModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *StorageUnitSnapshotModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/storage-units/{storage_unit.uuid}/snapshots][%d] storage_unit_snapshot_modify_collection default %s", o._statusCode, payload)
}

func (o *StorageUnitSnapshotModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *StorageUnitSnapshotModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
StorageUnitSnapshotModifyCollectionBody storage unit snapshot modify collection body
swagger:model StorageUnitSnapshotModifyCollectionBody
*/
type StorageUnitSnapshotModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// A comment associated with the snapshot. Valid in POST and PATCH.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Creation time of the snapshot. It is the storage unit access time when the snapshot was created.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// delta
	// Read Only: true
	Delta *models.SnapshotDelta `json:"delta,omitempty"`

	// The expiry time for the snapshot. Snapshots with an expiry time set are not allowed to be deleted until the retention time is reached.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Size of the logical used file system at the time the snapshot is captured.
	//
	// Example: 1228800
	// Read Only: true
	LogicalSize *int64 `json:"logical_size,omitempty"`

	// The name of the snapshot. Snapshot names cannot begin or end with whitespace. Valid in POST and PATCH.
	//
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// owners
	// Read Only: true
	Owners []*string `json:"owners,omitempty"`

	// Space reclaimed when the snapshot is deleted, in bytes.
	//
	// Read Only: true
	ReclaimableSpace *int64 `json:"reclaimable_space,omitempty"`

	// Size of the active file system at the time the snapshot is captured. The actual size of the snapshot also includes those blocks trapped by other snapshots. On a snapshot deletion, the `size` amount of blocks is the maximum number of blocks available. On a snapshot restore, the "AFS used size" value will match the snapshot `size` value.
	//
	// Example: 122880
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// snaplock
	Snaplock *models.StorageUnitSnapshotInlineSnaplock `json:"snaplock,omitempty"`

	// Label for SnapMirror operations. Valid in POST and PATCH.
	//
	// Max Length: 31
	// Min Length: 0
	SnapmirrorLabel *string `json:"snapmirror_label,omitempty"`

	// State of the FlexGroup volume snapshot. A recently created snapshot can be in the `unknown` state while the system is calculating the state. At all other times, a snapshot is valid.
	//
	// Read Only: true
	// Enum: ["valid","unknown"]
	State *string `json:"state,omitempty"`

	// storage unit
	StorageUnit *models.StorageUnitSnapshotInlineStorageUnit `json:"storage_unit,omitempty"`

	// storage unit snapshot response inline records
	StorageUnitSnapshotResponseInlineRecords []*models.StorageUnitSnapshot `json:"records,omitempty"`

	// svm
	Svm *models.StorageUnitSnapshotInlineSvm `json:"svm,omitempty"`

	// The UUID of the snapshot in the storage unit that uniquely identifies the snapshot in that storage unit.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// The 128 bit identifier that uniquely identifies a snapshot and its logical data layout.
	//
	// Read Only: true
	VersionUUID *string `json:"version_uuid,omitempty"`
}

// Validate validates this storage unit snapshot modify collection body
func (o *StorageUnitSnapshotModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDelta(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwners(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirrorLabel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageUnitSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateDelta(formats strfmt.Registry) error {
	if swag.IsZero(o.Delta) { // not required
		return nil
	}

	if o.Delta != nil {
		if err := o.Delta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "delta")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var storageUnitSnapshotModifyCollectionBodyOwnersItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","snapmirror","snapmirror_dependent","sync_mirror","volume_clone","volume_clone_dependent","snap_restore","snap_restore_dependent","dump","cifs_share","volume_copy","ndmp","worm_volume","sis_clone","s2c_iron","lun_clone","backup_dependent","snaplock_dependent","file_clone_dependent","volume_move_dependent","svmdr_dependent","anti_ransomware_backup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitSnapshotModifyCollectionBodyOwnersItemsEnum = append(storageUnitSnapshotModifyCollectionBodyOwnersItemsEnum, v)
	}
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateOwnersItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitSnapshotModifyCollectionBodyOwnersItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateOwners(formats strfmt.Registry) error {
	if swag.IsZero(o.Owners) { // not required
		return nil
	}

	for i := 0; i < len(o.Owners); i++ {
		if swag.IsZero(o.Owners[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateOwnersItemsEnum("info"+"."+"owners"+"."+strconv.Itoa(i), "body", *o.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(o.Snaplock) { // not required
		return nil
	}

	if o.Snaplock != nil {
		if err := o.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateSnapmirrorLabel(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapmirrorLabel) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"snapmirror_label", "body", *o.SnapmirrorLabel, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"snapmirror_label", "body", *o.SnapmirrorLabel, 31); err != nil {
		return err
	}

	return nil
}

var storageUnitSnapshotModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["valid","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		storageUnitSnapshotModifyCollectionBodyTypeStatePropEnum = append(storageUnitSnapshotModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// StorageUnitSnapshotModifyCollectionBody
	// StorageUnitSnapshotModifyCollectionBody
	// state
	// State
	// valid
	// END DEBUGGING
	// StorageUnitSnapshotModifyCollectionBodyStateValid captures enum value "valid"
	StorageUnitSnapshotModifyCollectionBodyStateValid string = "valid"

	// BEGIN DEBUGGING
	// StorageUnitSnapshotModifyCollectionBody
	// StorageUnitSnapshotModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// StorageUnitSnapshotModifyCollectionBodyStateUnknown captures enum value "unknown"
	StorageUnitSnapshotModifyCollectionBodyStateUnknown string = "unknown"
)

// prop value enum
func (o *StorageUnitSnapshotModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, storageUnitSnapshotModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnit) { // not required
		return nil
	}

	if o.StorageUnit != nil {
		if err := o.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateStorageUnitSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageUnitSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.StorageUnitSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.StorageUnitSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.StorageUnitSnapshotResponseInlineRecords[i] != nil {
			if err := o.StorageUnitSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot modify collection body based on the context it is used
func (o *StorageUnitSnapshotModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDelta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReclaimableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageUnitSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersionUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateDelta(ctx context.Context, formats strfmt.Registry) error {

	if o.Delta != nil {
		if err := o.Delta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "delta")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateLogicalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"logical_size", "body", o.LogicalSize); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateOwners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owners", "body", []*string(o.Owners)); err != nil {
		return err
	}

	for i := 0; i < len(o.Owners); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"owners"+"."+strconv.Itoa(i), "body", o.Owners[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateReclaimableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"reclaimable_space", "body", o.ReclaimableSpace); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if o.Snaplock != nil {
		if err := o.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snaplock")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageUnit != nil {
		if err := o.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateStorageUnitSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StorageUnitSnapshotResponseInlineRecords); i++ {

		if o.StorageUnitSnapshotResponseInlineRecords[i] != nil {
			if err := o.StorageUnitSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotModifyCollectionBody) contextValidateVersionUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"version_uuid", "body", o.VersionUUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitSnapshotInlineSnaplock storage unit snapshot inline snaplock
swagger:model storage_unit_snapshot_inline_snaplock
*/
type StorageUnitSnapshotInlineSnaplock struct {

	// Indicates whether a SnapLock snapshot has expired.
	//
	// Example: true
	// Read Only: true
	Expired *bool `json:"expired,omitempty"`

	// SnapLock expiry time for the snapshot, if the snapshot is taken on a SnapLock storage unit. A snapshot is not allowed to be deleted or renamed until the SnapLock ComplianceClock time goes beyond this retention time. This option can be set during snapshot POST and snapshot PATCH on snapshot locking enabled volumes. It can also be used to extend the expiry time of a locked snapshot on a SnapLock for SnapVault destination consistency-group.
	//
	// Example: 2019-02-04 19:00:00+00:00
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// Indicates the remaining SnapLock expiry time of a locked snapshot. This field is set only when the remaining time interval is less than 136 years.
	//
	// Example: PT3H27M45S
	// Read Only: true
	TimeUntilExpiry *string `json:"time_until_expiry,omitempty"`
}

// Validate validates this storage unit snapshot inline snaplock
func (o *StorageUnitSnapshotInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snaplock"+"."+"expiry_time", "body", "date-time", o.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline snaplock based on the context it is used
func (o *StorageUnitSnapshotInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateExpired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimeUntilExpiry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSnaplock) contextValidateExpired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"expired", "body", o.Expired); err != nil {
		return err
	}

	return nil
}

func (o *StorageUnitSnapshotInlineSnaplock) contextValidateTimeUntilExpiry(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snaplock"+"."+"time_until_expiry", "body", o.TimeUntilExpiry); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSnaplock) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitSnapshotInlineStorageUnit The storage unit in which the snapshot is located. Valid in POST.
//
swagger:model storage_unit_snapshot_inline_storage_unit
*/
type StorageUnitSnapshotInlineStorageUnit struct {

	// links
	Links *models.StorageUnitSnapshotInlineStorageUnitInlineLinks `json:"_links,omitempty"`

	// The name of the storage unit.
	//
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the storage unit.
	//
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit snapshot inline storage unit
func (o *StorageUnitSnapshotInlineStorageUnit) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineStorageUnit) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline storage unit based on the context it is used
func (o *StorageUnitSnapshotInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineStorageUnit) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitSnapshotInlineStorageUnitInlineLinks storage unit snapshot inline storage unit inline links
swagger:model storage_unit_snapshot_inline_storage_unit_inline__links
*/
type StorageUnitSnapshotInlineStorageUnitInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit snapshot inline storage unit inline links
func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline storage unit inline links based on the context it is used
func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage_unit" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineStorageUnitInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineStorageUnitInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitSnapshotInlineSvm The SVM in which the storage unit is located. Valid in POST.
//
swagger:model storage_unit_snapshot_inline_svm
*/
type StorageUnitSnapshotInlineSvm struct {

	// links
	Links *models.StorageUnitSnapshotInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this storage unit snapshot inline svm
func (o *StorageUnitSnapshotInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline svm based on the context it is used
func (o *StorageUnitSnapshotInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSvm) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
StorageUnitSnapshotInlineSvmInlineLinks storage unit snapshot inline svm inline links
swagger:model storage_unit_snapshot_inline_svm_inline__links
*/
type StorageUnitSnapshotInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this storage unit snapshot inline svm inline links
func (o *StorageUnitSnapshotInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this storage unit snapshot inline svm inline links based on the context it is used
func (o *StorageUnitSnapshotInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *StorageUnitSnapshotInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *StorageUnitSnapshotInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res StorageUnitSnapshotInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
