// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VvolBindingCollectionGetReader is a Reader for the VvolBindingCollectionGet structure.
type VvolBindingCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VvolBindingCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVvolBindingCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVvolBindingCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVvolBindingCollectionGetOK creates a VvolBindingCollectionGetOK with default headers values
func NewVvolBindingCollectionGetOK() *VvolBindingCollectionGetOK {
	return &VvolBindingCollectionGetOK{}
}

/*
VvolBindingCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type VvolBindingCollectionGetOK struct {
	Payload *models.VvolBindingResponse
}

// IsSuccess returns true when this vvol binding collection get o k response has a 2xx status code
func (o *VvolBindingCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vvol binding collection get o k response has a 3xx status code
func (o *VvolBindingCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vvol binding collection get o k response has a 4xx status code
func (o *VvolBindingCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vvol binding collection get o k response has a 5xx status code
func (o *VvolBindingCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vvol binding collection get o k response a status code equal to that given
func (o *VvolBindingCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vvol binding collection get o k response
func (o *VvolBindingCollectionGetOK) Code() int {
	return 200
}

func (o *VvolBindingCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings][%d] vvolBindingCollectionGetOK %s", 200, payload)
}

func (o *VvolBindingCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings][%d] vvolBindingCollectionGetOK %s", 200, payload)
}

func (o *VvolBindingCollectionGetOK) GetPayload() *models.VvolBindingResponse {
	return o.Payload
}

func (o *VvolBindingCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VvolBindingResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVvolBindingCollectionGetDefault creates a VvolBindingCollectionGetDefault with default headers values
func NewVvolBindingCollectionGetDefault(code int) *VvolBindingCollectionGetDefault {
	return &VvolBindingCollectionGetDefault{
		_statusCode: code,
	}
}

/*
VvolBindingCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type VvolBindingCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vvol binding collection get default response has a 2xx status code
func (o *VvolBindingCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vvol binding collection get default response has a 3xx status code
func (o *VvolBindingCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vvol binding collection get default response has a 4xx status code
func (o *VvolBindingCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vvol binding collection get default response has a 5xx status code
func (o *VvolBindingCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vvol binding collection get default response a status code equal to that given
func (o *VvolBindingCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vvol binding collection get default response
func (o *VvolBindingCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *VvolBindingCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings][%d] vvol_binding_collection_get default %s", o._statusCode, payload)
}

func (o *VvolBindingCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings][%d] vvol_binding_collection_get default %s", o._statusCode, payload)
}

func (o *VvolBindingCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VvolBindingCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
