// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewVvolBindingCreateParams creates a new VvolBindingCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVvolBindingCreateParams() *VvolBindingCreateParams {
	return &VvolBindingCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVvolBindingCreateParamsWithTimeout creates a new VvolBindingCreateParams object
// with the ability to set a timeout on a request.
func NewVvolBindingCreateParamsWithTimeout(timeout time.Duration) *VvolBindingCreateParams {
	return &VvolBindingCreateParams{
		timeout: timeout,
	}
}

// NewVvolBindingCreateParamsWithContext creates a new VvolBindingCreateParams object
// with the ability to set a context for a request.
func NewVvolBindingCreateParamsWithContext(ctx context.Context) *VvolBindingCreateParams {
	return &VvolBindingCreateParams{
		Context: ctx,
	}
}

// NewVvolBindingCreateParamsWithHTTPClient creates a new VvolBindingCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewVvolBindingCreateParamsWithHTTPClient(client *http.Client) *VvolBindingCreateParams {
	return &VvolBindingCreateParams{
		HTTPClient: client,
	}
}

/*
VvolBindingCreateParams contains all the parameters to send to the API endpoint

	for the vvol binding create operation.

	Typically these are written to a http.Request.
*/
type VvolBindingCreateParams struct {

	/* Info.

	   The property values for the new vVol binding.

	*/
	Info *models.VvolBinding

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vvol binding create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VvolBindingCreateParams) WithDefaults() *VvolBindingCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vvol binding create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VvolBindingCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := VvolBindingCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vvol binding create params
func (o *VvolBindingCreateParams) WithTimeout(timeout time.Duration) *VvolBindingCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vvol binding create params
func (o *VvolBindingCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vvol binding create params
func (o *VvolBindingCreateParams) WithContext(ctx context.Context) *VvolBindingCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vvol binding create params
func (o *VvolBindingCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vvol binding create params
func (o *VvolBindingCreateParams) WithHTTPClient(client *http.Client) *VvolBindingCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vvol binding create params
func (o *VvolBindingCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the vvol binding create params
func (o *VvolBindingCreateParams) WithInfo(info *models.VvolBinding) *VvolBindingCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the vvol binding create params
func (o *VvolBindingCreateParams) SetInfo(info *models.VvolBinding) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the vvol binding create params
func (o *VvolBindingCreateParams) WithReturnRecords(returnRecords *bool) *VvolBindingCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vvol binding create params
func (o *VvolBindingCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *VvolBindingCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
