// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVvolBindingDeleteParams creates a new VvolBindingDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVvolBindingDeleteParams() *VvolBindingDeleteParams {
	return &VvolBindingDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVvolBindingDeleteParamsWithTimeout creates a new VvolBindingDeleteParams object
// with the ability to set a timeout on a request.
func NewVvolBindingDeleteParamsWithTimeout(timeout time.Duration) *VvolBindingDeleteParams {
	return &VvolBindingDeleteParams{
		timeout: timeout,
	}
}

// NewVvolBindingDeleteParamsWithContext creates a new VvolBindingDeleteParams object
// with the ability to set a context for a request.
func NewVvolBindingDeleteParamsWithContext(ctx context.Context) *VvolBindingDeleteParams {
	return &VvolBindingDeleteParams{
		Context: ctx,
	}
}

// NewVvolBindingDeleteParamsWithHTTPClient creates a new VvolBindingDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewVvolBindingDeleteParamsWithHTTPClient(client *http.Client) *VvolBindingDeleteParams {
	return &VvolBindingDeleteParams{
		HTTPClient: client,
	}
}

/*
VvolBindingDeleteParams contains all the parameters to send to the API endpoint

	for the vvol binding delete operation.

	Typically these are written to a http.Request.
*/
type VvolBindingDeleteParams struct {

	/* DeleteAllReferences.

	   Forces deletion of the binding regardless of the reference count value.

	*/
	DeleteAllReferences *bool

	/* ProtocolEndpointUUID.

	   The unique identifier of the class `protocol_endpoint` LUN.

	*/
	ProtocolEndpointUUID string

	/* VvolUUID.

	   The unique identifier of the class `vvol` LUN.

	*/
	VvolUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vvol binding delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VvolBindingDeleteParams) WithDefaults() *VvolBindingDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vvol binding delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VvolBindingDeleteParams) SetDefaults() {
	var (
		deleteAllReferencesDefault = bool(false)
	)

	val := VvolBindingDeleteParams{
		DeleteAllReferences: &deleteAllReferencesDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithTimeout(timeout time.Duration) *VvolBindingDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithContext(ctx context.Context) *VvolBindingDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithHTTPClient(client *http.Client) *VvolBindingDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteAllReferences adds the deleteAllReferences to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithDeleteAllReferences(deleteAllReferences *bool) *VvolBindingDeleteParams {
	o.SetDeleteAllReferences(deleteAllReferences)
	return o
}

// SetDeleteAllReferences adds the deleteAllReferences to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetDeleteAllReferences(deleteAllReferences *bool) {
	o.DeleteAllReferences = deleteAllReferences
}

// WithProtocolEndpointUUID adds the protocolEndpointUUID to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithProtocolEndpointUUID(protocolEndpointUUID string) *VvolBindingDeleteParams {
	o.SetProtocolEndpointUUID(protocolEndpointUUID)
	return o
}

// SetProtocolEndpointUUID adds the protocolEndpointUuid to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetProtocolEndpointUUID(protocolEndpointUUID string) {
	o.ProtocolEndpointUUID = protocolEndpointUUID
}

// WithVvolUUID adds the vvolUUID to the vvol binding delete params
func (o *VvolBindingDeleteParams) WithVvolUUID(vvolUUID string) *VvolBindingDeleteParams {
	o.SetVvolUUID(vvolUUID)
	return o
}

// SetVvolUUID adds the vvolUuid to the vvol binding delete params
func (o *VvolBindingDeleteParams) SetVvolUUID(vvolUUID string) {
	o.VvolUUID = vvolUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VvolBindingDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteAllReferences != nil {

		// query param delete_all_references
		var qrDeleteAllReferences bool

		if o.DeleteAllReferences != nil {
			qrDeleteAllReferences = *o.DeleteAllReferences
		}
		qDeleteAllReferences := swag.FormatBool(qrDeleteAllReferences)
		if qDeleteAllReferences != "" {

			if err := r.SetQueryParam("delete_all_references", qDeleteAllReferences); err != nil {
				return err
			}
		}
	}

	// path param protocol_endpoint.uuid
	if err := r.SetPathParam("protocol_endpoint.uuid", o.ProtocolEndpointUUID); err != nil {
		return err
	}

	// path param vvol.uuid
	if err := r.SetPathParam("vvol.uuid", o.VvolUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
