// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VvolBindingGetReader is a Reader for the VvolBindingGet structure.
type VvolBindingGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VvolBindingGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVvolBindingGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVvolBindingGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVvolBindingGetOK creates a VvolBindingGetOK with default headers values
func NewVvolBindingGetOK() *VvolBindingGetOK {
	return &VvolBindingGetOK{}
}

/*
VvolBindingGetOK describes a response with status code 200, with default header values.

OK
*/
type VvolBindingGetOK struct {
	Payload *models.VvolBinding
}

// IsSuccess returns true when this vvol binding get o k response has a 2xx status code
func (o *VvolBindingGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vvol binding get o k response has a 3xx status code
func (o *VvolBindingGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vvol binding get o k response has a 4xx status code
func (o *VvolBindingGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vvol binding get o k response has a 5xx status code
func (o *VvolBindingGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vvol binding get o k response a status code equal to that given
func (o *VvolBindingGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vvol binding get o k response
func (o *VvolBindingGetOK) Code() int {
	return 200
}

func (o *VvolBindingGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}][%d] vvolBindingGetOK %s", 200, payload)
}

func (o *VvolBindingGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}][%d] vvolBindingGetOK %s", 200, payload)
}

func (o *VvolBindingGetOK) GetPayload() *models.VvolBinding {
	return o.Payload
}

func (o *VvolBindingGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VvolBinding)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVvolBindingGetDefault creates a VvolBindingGetDefault with default headers values
func NewVvolBindingGetDefault(code int) *VvolBindingGetDefault {
	return &VvolBindingGetDefault{
		_statusCode: code,
	}
}

/*
	VvolBindingGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The vVol binding was not found. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type VvolBindingGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vvol binding get default response has a 2xx status code
func (o *VvolBindingGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vvol binding get default response has a 3xx status code
func (o *VvolBindingGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vvol binding get default response has a 4xx status code
func (o *VvolBindingGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vvol binding get default response has a 5xx status code
func (o *VvolBindingGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vvol binding get default response a status code equal to that given
func (o *VvolBindingGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vvol binding get default response
func (o *VvolBindingGetDefault) Code() int {
	return o._statusCode
}

func (o *VvolBindingGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}][%d] vvol_binding_get default %s", o._statusCode, payload)
}

func (o *VvolBindingGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/vvol-bindings/{protocol_endpoint.uuid}/{vvol.uuid}][%d] vvol_binding_get default %s", o._statusCode, payload)
}

func (o *VvolBindingGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VvolBindingGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
