// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWwpnAliasCollectionGetParams creates a new WwpnAliasCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWwpnAliasCollectionGetParams() *WwpnAliasCollectionGetParams {
	return &WwpnAliasCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWwpnAliasCollectionGetParamsWithTimeout creates a new WwpnAliasCollectionGetParams object
// with the ability to set a timeout on a request.
func NewWwpnAliasCollectionGetParamsWithTimeout(timeout time.Duration) *WwpnAliasCollectionGetParams {
	return &WwpnAliasCollectionGetParams{
		timeout: timeout,
	}
}

// NewWwpnAliasCollectionGetParamsWithContext creates a new WwpnAliasCollectionGetParams object
// with the ability to set a context for a request.
func NewWwpnAliasCollectionGetParamsWithContext(ctx context.Context) *WwpnAliasCollectionGetParams {
	return &WwpnAliasCollectionGetParams{
		Context: ctx,
	}
}

// NewWwpnAliasCollectionGetParamsWithHTTPClient creates a new WwpnAliasCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWwpnAliasCollectionGetParamsWithHTTPClient(client *http.Client) *WwpnAliasCollectionGetParams {
	return &WwpnAliasCollectionGetParams{
		HTTPClient: client,
	}
}

/*
WwpnAliasCollectionGetParams contains all the parameters to send to the API endpoint

	for the wwpn alias collection get operation.

	Typically these are written to a http.Request.
*/
type WwpnAliasCollectionGetParams struct {

	/* Alias.

	   Filter by alias
	*/
	Alias *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the wwpn alias collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasCollectionGetParams) WithDefaults() *WwpnAliasCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the wwpn alias collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := WwpnAliasCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithTimeout(timeout time.Duration) *WwpnAliasCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithContext(ctx context.Context) *WwpnAliasCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithHTTPClient(client *http.Client) *WwpnAliasCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAlias adds the alias to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithAlias(alias *string) *WwpnAliasCollectionGetParams {
	o.SetAlias(alias)
	return o
}

// SetAlias adds the alias to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetAlias(alias *string) {
	o.Alias = alias
}

// WithFields adds the fields to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithFields(fields []string) *WwpnAliasCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithMaxRecords(maxRecords *int64) *WwpnAliasCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithOrderBy(orderBy []string) *WwpnAliasCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithReturnRecords(returnRecords *bool) *WwpnAliasCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *WwpnAliasCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithSvmName(svmName *string) *WwpnAliasCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithSvmUUID(svmUUID *string) *WwpnAliasCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithWwpn adds the wwpn to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) WithWwpn(wwpn *string) *WwpnAliasCollectionGetParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the wwpn alias collection get params
func (o *WwpnAliasCollectionGetParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *WwpnAliasCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Alias != nil {

		// query param alias
		var qrAlias string

		if o.Alias != nil {
			qrAlias = *o.Alias
		}
		qAlias := qrAlias
		if qAlias != "" {

			if err := r.SetQueryParam("alias", qAlias); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWwpnAliasCollectionGet binds the parameter fields
func (o *WwpnAliasCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamWwpnAliasCollectionGet binds the parameter order_by
func (o *WwpnAliasCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
