// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewWwpnAliasCreateParams creates a new WwpnAliasCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWwpnAliasCreateParams() *WwpnAliasCreateParams {
	return &WwpnAliasCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWwpnAliasCreateParamsWithTimeout creates a new WwpnAliasCreateParams object
// with the ability to set a timeout on a request.
func NewWwpnAliasCreateParamsWithTimeout(timeout time.Duration) *WwpnAliasCreateParams {
	return &WwpnAliasCreateParams{
		timeout: timeout,
	}
}

// NewWwpnAliasCreateParamsWithContext creates a new WwpnAliasCreateParams object
// with the ability to set a context for a request.
func NewWwpnAliasCreateParamsWithContext(ctx context.Context) *WwpnAliasCreateParams {
	return &WwpnAliasCreateParams{
		Context: ctx,
	}
}

// NewWwpnAliasCreateParamsWithHTTPClient creates a new WwpnAliasCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewWwpnAliasCreateParamsWithHTTPClient(client *http.Client) *WwpnAliasCreateParams {
	return &WwpnAliasCreateParams{
		HTTPClient: client,
	}
}

/*
WwpnAliasCreateParams contains all the parameters to send to the API endpoint

	for the wwpn alias create operation.

	Typically these are written to a http.Request.
*/
type WwpnAliasCreateParams struct {

	/* Info.

	   The property values for the new WWPN alias.

	*/
	Info *models.WwpnAlias

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the wwpn alias create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasCreateParams) WithDefaults() *WwpnAliasCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the wwpn alias create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := WwpnAliasCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the wwpn alias create params
func (o *WwpnAliasCreateParams) WithTimeout(timeout time.Duration) *WwpnAliasCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the wwpn alias create params
func (o *WwpnAliasCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the wwpn alias create params
func (o *WwpnAliasCreateParams) WithContext(ctx context.Context) *WwpnAliasCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the wwpn alias create params
func (o *WwpnAliasCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the wwpn alias create params
func (o *WwpnAliasCreateParams) WithHTTPClient(client *http.Client) *WwpnAliasCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the wwpn alias create params
func (o *WwpnAliasCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the wwpn alias create params
func (o *WwpnAliasCreateParams) WithInfo(info *models.WwpnAlias) *WwpnAliasCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the wwpn alias create params
func (o *WwpnAliasCreateParams) SetInfo(info *models.WwpnAlias) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the wwpn alias create params
func (o *WwpnAliasCreateParams) WithReturnRecords(returnRecords *bool) *WwpnAliasCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the wwpn alias create params
func (o *WwpnAliasCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *WwpnAliasCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
