// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWwpnAliasDeleteCollectionParams creates a new WwpnAliasDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWwpnAliasDeleteCollectionParams() *WwpnAliasDeleteCollectionParams {
	return &WwpnAliasDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWwpnAliasDeleteCollectionParamsWithTimeout creates a new WwpnAliasDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewWwpnAliasDeleteCollectionParamsWithTimeout(timeout time.Duration) *WwpnAliasDeleteCollectionParams {
	return &WwpnAliasDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewWwpnAliasDeleteCollectionParamsWithContext creates a new WwpnAliasDeleteCollectionParams object
// with the ability to set a context for a request.
func NewWwpnAliasDeleteCollectionParamsWithContext(ctx context.Context) *WwpnAliasDeleteCollectionParams {
	return &WwpnAliasDeleteCollectionParams{
		Context: ctx,
	}
}

// NewWwpnAliasDeleteCollectionParamsWithHTTPClient creates a new WwpnAliasDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWwpnAliasDeleteCollectionParamsWithHTTPClient(client *http.Client) *WwpnAliasDeleteCollectionParams {
	return &WwpnAliasDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
WwpnAliasDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the wwpn alias delete collection operation.

	Typically these are written to a http.Request.
*/
type WwpnAliasDeleteCollectionParams struct {

	/* Alias.

	   Filter by alias
	*/
	Alias *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info WwpnAliasDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Wwpn.

	   Filter by wwpn
	*/
	Wwpn *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the wwpn alias delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasDeleteCollectionParams) WithDefaults() *WwpnAliasDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the wwpn alias delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WwpnAliasDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := WwpnAliasDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithTimeout(timeout time.Duration) *WwpnAliasDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithContext(ctx context.Context) *WwpnAliasDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithHTTPClient(client *http.Client) *WwpnAliasDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAlias adds the alias to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithAlias(alias *string) *WwpnAliasDeleteCollectionParams {
	o.SetAlias(alias)
	return o
}

// SetAlias adds the alias to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetAlias(alias *string) {
	o.Alias = alias
}

// WithContinueOnFailure adds the continueOnFailure to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *WwpnAliasDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithInfo(info WwpnAliasDeleteCollectionBody) *WwpnAliasDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetInfo(info WwpnAliasDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *WwpnAliasDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *WwpnAliasDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *WwpnAliasDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithSvmName(svmName *string) *WwpnAliasDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithSvmUUID(svmUUID *string) *WwpnAliasDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithWwpn adds the wwpn to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) WithWwpn(wwpn *string) *WwpnAliasDeleteCollectionParams {
	o.SetWwpn(wwpn)
	return o
}

// SetWwpn adds the wwpn to the wwpn alias delete collection params
func (o *WwpnAliasDeleteCollectionParams) SetWwpn(wwpn *string) {
	o.Wwpn = wwpn
}

// WriteToRequest writes these params to a swagger request
func (o *WwpnAliasDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Alias != nil {

		// query param alias
		var qrAlias string

		if o.Alias != nil {
			qrAlias = *o.Alias
		}
		qAlias := qrAlias
		if qAlias != "" {

			if err := r.SetQueryParam("alias", qAlias); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Wwpn != nil {

		// query param wwpn
		var qrWwpn string

		if o.Wwpn != nil {
			qrWwpn = *o.Wwpn
		}
		qWwpn := qrWwpn
		if qWwpn != "" {

			if err := r.SetQueryParam("wwpn", qWwpn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
