// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WwpnAliasDeleteCollectionReader is a Reader for the WwpnAliasDeleteCollection structure.
type WwpnAliasDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WwpnAliasDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWwpnAliasDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWwpnAliasDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWwpnAliasDeleteCollectionOK creates a WwpnAliasDeleteCollectionOK with default headers values
func NewWwpnAliasDeleteCollectionOK() *WwpnAliasDeleteCollectionOK {
	return &WwpnAliasDeleteCollectionOK{}
}

/*
WwpnAliasDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WwpnAliasDeleteCollectionOK struct {
}

// IsSuccess returns true when this wwpn alias delete collection o k response has a 2xx status code
func (o *WwpnAliasDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this wwpn alias delete collection o k response has a 3xx status code
func (o *WwpnAliasDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this wwpn alias delete collection o k response has a 4xx status code
func (o *WwpnAliasDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this wwpn alias delete collection o k response has a 5xx status code
func (o *WwpnAliasDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this wwpn alias delete collection o k response a status code equal to that given
func (o *WwpnAliasDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the wwpn alias delete collection o k response
func (o *WwpnAliasDeleteCollectionOK) Code() int {
	return 200
}

func (o *WwpnAliasDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /network/fc/wwpn-aliases][%d] wwpnAliasDeleteCollectionOK", 200)
}

func (o *WwpnAliasDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /network/fc/wwpn-aliases][%d] wwpnAliasDeleteCollectionOK", 200)
}

func (o *WwpnAliasDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWwpnAliasDeleteCollectionDefault creates a WwpnAliasDeleteCollectionDefault with default headers values
func NewWwpnAliasDeleteCollectionDefault(code int) *WwpnAliasDeleteCollectionDefault {
	return &WwpnAliasDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	WwpnAliasDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | The specified SVM does not exist or cannot be accessed by this user. |
| 5374046 | The alias could not be found. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type WwpnAliasDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this wwpn alias delete collection default response has a 2xx status code
func (o *WwpnAliasDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this wwpn alias delete collection default response has a 3xx status code
func (o *WwpnAliasDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this wwpn alias delete collection default response has a 4xx status code
func (o *WwpnAliasDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this wwpn alias delete collection default response has a 5xx status code
func (o *WwpnAliasDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this wwpn alias delete collection default response a status code equal to that given
func (o *WwpnAliasDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the wwpn alias delete collection default response
func (o *WwpnAliasDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WwpnAliasDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/fc/wwpn-aliases][%d] wwpn_alias_delete_collection default %s", o._statusCode, payload)
}

func (o *WwpnAliasDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/fc/wwpn-aliases][%d] wwpn_alias_delete_collection default %s", o._statusCode, payload)
}

func (o *WwpnAliasDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WwpnAliasDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WwpnAliasDeleteCollectionBody wwpn alias delete collection body
swagger:model WwpnAliasDeleteCollectionBody
*/
type WwpnAliasDeleteCollectionBody struct {

	// wwpn alias response inline records
	WwpnAliasResponseInlineRecords []*models.WwpnAlias `json:"records,omitempty"`
}

// Validate validates this wwpn alias delete collection body
func (o *WwpnAliasDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateWwpnAliasResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WwpnAliasDeleteCollectionBody) validateWwpnAliasResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WwpnAliasResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WwpnAliasResponseInlineRecords); i++ {
		if swag.IsZero(o.WwpnAliasResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WwpnAliasResponseInlineRecords[i] != nil {
			if err := o.WwpnAliasResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this wwpn alias delete collection body based on the context it is used
func (o *WwpnAliasDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateWwpnAliasResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WwpnAliasDeleteCollectionBody) contextValidateWwpnAliasResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WwpnAliasResponseInlineRecords); i++ {

		if o.WwpnAliasResponseInlineRecords[i] != nil {
			if err := o.WwpnAliasResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WwpnAliasDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WwpnAliasDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res WwpnAliasDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
