// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WwpnAliasGetReader is a Reader for the WwpnAliasGet structure.
type WwpnAliasGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WwpnAliasGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWwpnAliasGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWwpnAliasGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWwpnAliasGetOK creates a WwpnAliasGetOK with default headers values
func NewWwpnAliasGetOK() *WwpnAliasGetOK {
	return &WwpnAliasGetOK{}
}

/*
WwpnAliasGetOK describes a response with status code 200, with default header values.

OK
*/
type WwpnAliasGetOK struct {
	Payload *models.WwpnAlias
}

// IsSuccess returns true when this wwpn alias get o k response has a 2xx status code
func (o *WwpnAliasGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this wwpn alias get o k response has a 3xx status code
func (o *WwpnAliasGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this wwpn alias get o k response has a 4xx status code
func (o *WwpnAliasGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this wwpn alias get o k response has a 5xx status code
func (o *WwpnAliasGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this wwpn alias get o k response a status code equal to that given
func (o *WwpnAliasGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the wwpn alias get o k response
func (o *WwpnAliasGetOK) Code() int {
	return 200
}

func (o *WwpnAliasGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/wwpn-aliases/{svm.uuid}/{alias}][%d] wwpnAliasGetOK %s", 200, payload)
}

func (o *WwpnAliasGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/wwpn-aliases/{svm.uuid}/{alias}][%d] wwpnAliasGetOK %s", 200, payload)
}

func (o *WwpnAliasGetOK) GetPayload() *models.WwpnAlias {
	return o.Payload
}

func (o *WwpnAliasGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WwpnAlias)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWwpnAliasGetDefault creates a WwpnAliasGetDefault with default headers values
func NewWwpnAliasGetDefault(code int) *WwpnAliasGetDefault {
	return &WwpnAliasGetDefault{
		_statusCode: code,
	}
}

/*
	WwpnAliasGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | The specified SVM does not exist or cannot be accessed by this user. |
| 5374046 | The alias could not be found. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type WwpnAliasGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this wwpn alias get default response has a 2xx status code
func (o *WwpnAliasGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this wwpn alias get default response has a 3xx status code
func (o *WwpnAliasGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this wwpn alias get default response has a 4xx status code
func (o *WwpnAliasGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this wwpn alias get default response has a 5xx status code
func (o *WwpnAliasGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this wwpn alias get default response a status code equal to that given
func (o *WwpnAliasGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the wwpn alias get default response
func (o *WwpnAliasGetDefault) Code() int {
	return o._statusCode
}

func (o *WwpnAliasGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/wwpn-aliases/{svm.uuid}/{alias}][%d] wwpn_alias_get default %s", o._statusCode, payload)
}

func (o *WwpnAliasGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/wwpn-aliases/{svm.uuid}/{alias}][%d] wwpn_alias_get default %s", o._statusCode, payload)
}

func (o *WwpnAliasGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WwpnAliasGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
