// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountDeleteCollectionReader is a Reader for the AccountDeleteCollection structure.
type AccountDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountDeleteCollectionOK creates a AccountDeleteCollectionOK with default headers values
func NewAccountDeleteCollectionOK() *AccountDeleteCollectionOK {
	return &AccountDeleteCollectionOK{}
}

/*
AccountDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AccountDeleteCollectionOK struct {
}

// IsSuccess returns true when this account delete collection o k response has a 2xx status code
func (o *AccountDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account delete collection o k response has a 3xx status code
func (o *AccountDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account delete collection o k response has a 4xx status code
func (o *AccountDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account delete collection o k response has a 5xx status code
func (o *AccountDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account delete collection o k response a status code equal to that given
func (o *AccountDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account delete collection o k response
func (o *AccountDeleteCollectionOK) Code() int {
	return 200
}

func (o *AccountDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/accounts][%d] accountDeleteCollectionOK", 200)
}

func (o *AccountDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/accounts][%d] accountDeleteCollectionOK", 200)
}

func (o *AccountDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAccountDeleteCollectionDefault creates a AccountDeleteCollectionDefault with default headers values
func NewAccountDeleteCollectionDefault(code int) *AccountDeleteCollectionDefault {
	return &AccountDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	AccountDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636098 | Last unlocked account that has an admin role cannot be deleted. |
| 5636125 | The operation is not supported on system accounts. |
| 5636146 | Cannot delete the last console account with admin role. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AccountDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account delete collection default response has a 2xx status code
func (o *AccountDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account delete collection default response has a 3xx status code
func (o *AccountDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account delete collection default response has a 4xx status code
func (o *AccountDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account delete collection default response has a 5xx status code
func (o *AccountDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account delete collection default response a status code equal to that given
func (o *AccountDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account delete collection default response
func (o *AccountDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AccountDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/accounts][%d] account_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/accounts][%d] account_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AccountDeleteCollectionBody account delete collection body
swagger:model AccountDeleteCollectionBody
*/
type AccountDeleteCollectionBody struct {

	// account response inline records
	AccountResponseInlineRecords []*models.Account `json:"records,omitempty"`
}

// Validate validates this account delete collection body
func (o *AccountDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccountResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDeleteCollectionBody) validateAccountResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AccountResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AccountResponseInlineRecords); i++ {
		if swag.IsZero(o.AccountResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AccountResponseInlineRecords[i] != nil {
			if err := o.AccountResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this account delete collection body based on the context it is used
func (o *AccountDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAccountResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDeleteCollectionBody) contextValidateAccountResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AccountResponseInlineRecords); i++ {

		if o.AccountResponseInlineRecords[i] != nil {
			if err := o.AccountResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AccountDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AccountDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res AccountDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
