// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountDuoDeleteCollectionReader is a Reader for the AccountDuoDeleteCollection structure.
type AccountDuoDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountDuoDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountDuoDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountDuoDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountDuoDeleteCollectionOK creates a AccountDuoDeleteCollectionOK with default headers values
func NewAccountDuoDeleteCollectionOK() *AccountDuoDeleteCollectionOK {
	return &AccountDuoDeleteCollectionOK{}
}

/*
AccountDuoDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AccountDuoDeleteCollectionOK struct {
}

// IsSuccess returns true when this account duo delete collection o k response has a 2xx status code
func (o *AccountDuoDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account duo delete collection o k response has a 3xx status code
func (o *AccountDuoDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account duo delete collection o k response has a 4xx status code
func (o *AccountDuoDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account duo delete collection o k response has a 5xx status code
func (o *AccountDuoDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account duo delete collection o k response a status code equal to that given
func (o *AccountDuoDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account duo delete collection o k response
func (o *AccountDuoDeleteCollectionOK) Code() int {
	return 200
}

func (o *AccountDuoDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/profiles][%d] accountDuoDeleteCollectionOK", 200)
}

func (o *AccountDuoDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/profiles][%d] accountDuoDeleteCollectionOK", 200)
}

func (o *AccountDuoDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAccountDuoDeleteCollectionDefault creates a AccountDuoDeleteCollectionDefault with default headers values
func NewAccountDuoDeleteCollectionDefault(code int) *AccountDuoDeleteCollectionDefault {
	return &AccountDuoDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
AccountDuoDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type AccountDuoDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account duo delete collection default response has a 2xx status code
func (o *AccountDuoDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account duo delete collection default response has a 3xx status code
func (o *AccountDuoDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account duo delete collection default response has a 4xx status code
func (o *AccountDuoDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account duo delete collection default response has a 5xx status code
func (o *AccountDuoDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account duo delete collection default response a status code equal to that given
func (o *AccountDuoDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account duo delete collection default response
func (o *AccountDuoDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AccountDuoDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/profiles][%d] account_duo_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDuoDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/profiles][%d] account_duo_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDuoDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountDuoDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AccountDuoDeleteCollectionBody account duo delete collection body
swagger:model AccountDuoDeleteCollectionBody
*/
type AccountDuoDeleteCollectionBody struct {

	// duo response inline records
	DuoResponseInlineRecords []*models.Duo `json:"records,omitempty"`
}

// Validate validates this account duo delete collection body
func (o *AccountDuoDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDuoResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDuoDeleteCollectionBody) validateDuoResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DuoResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DuoResponseInlineRecords); i++ {
		if swag.IsZero(o.DuoResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DuoResponseInlineRecords[i] != nil {
			if err := o.DuoResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this account duo delete collection body based on the context it is used
func (o *AccountDuoDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDuoResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDuoDeleteCollectionBody) contextValidateDuoResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DuoResponseInlineRecords); i++ {

		if o.DuoResponseInlineRecords[i] != nil {
			if err := o.DuoResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AccountDuoDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AccountDuoDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res AccountDuoDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
