// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAccountDuogroupDeleteCollectionParams creates a new AccountDuogroupDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAccountDuogroupDeleteCollectionParams() *AccountDuogroupDeleteCollectionParams {
	return &AccountDuogroupDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAccountDuogroupDeleteCollectionParamsWithTimeout creates a new AccountDuogroupDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewAccountDuogroupDeleteCollectionParamsWithTimeout(timeout time.Duration) *AccountDuogroupDeleteCollectionParams {
	return &AccountDuogroupDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewAccountDuogroupDeleteCollectionParamsWithContext creates a new AccountDuogroupDeleteCollectionParams object
// with the ability to set a context for a request.
func NewAccountDuogroupDeleteCollectionParamsWithContext(ctx context.Context) *AccountDuogroupDeleteCollectionParams {
	return &AccountDuogroupDeleteCollectionParams{
		Context: ctx,
	}
}

// NewAccountDuogroupDeleteCollectionParamsWithHTTPClient creates a new AccountDuogroupDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAccountDuogroupDeleteCollectionParamsWithHTTPClient(client *http.Client) *AccountDuogroupDeleteCollectionParams {
	return &AccountDuogroupDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
AccountDuogroupDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the account duogroup delete collection operation.

	Typically these are written to a http.Request.
*/
type AccountDuogroupDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ExcludedUsers.

	   Filter by excluded_users
	*/
	ExcludedUsers *string

	/* Info.

	   Info specification
	*/
	Info AccountDuogroupDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the account duogroup delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountDuogroupDeleteCollectionParams) WithDefaults() *AccountDuogroupDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the account duogroup delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountDuogroupDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := AccountDuogroupDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithTimeout(timeout time.Duration) *AccountDuogroupDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithContext(ctx context.Context) *AccountDuogroupDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithHTTPClient(client *http.Client) *AccountDuogroupDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithComment(comment *string) *AccountDuogroupDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *AccountDuogroupDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithExcludedUsers adds the excludedUsers to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithExcludedUsers(excludedUsers *string) *AccountDuogroupDeleteCollectionParams {
	o.SetExcludedUsers(excludedUsers)
	return o
}

// SetExcludedUsers adds the excludedUsers to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetExcludedUsers(excludedUsers *string) {
	o.ExcludedUsers = excludedUsers
}

// WithInfo adds the info to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithInfo(info AccountDuogroupDeleteCollectionBody) *AccountDuogroupDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetInfo(info AccountDuogroupDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithName(name *string) *AccountDuogroupDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwnerName adds the ownerName to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithOwnerName(ownerName *string) *AccountDuogroupDeleteCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithOwnerUUID(ownerUUID *string) *AccountDuogroupDeleteCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *AccountDuogroupDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *AccountDuogroupDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *AccountDuogroupDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the account duogroup delete collection params
func (o *AccountDuogroupDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *AccountDuogroupDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ExcludedUsers != nil {

		// query param excluded_users
		var qrExcludedUsers string

		if o.ExcludedUsers != nil {
			qrExcludedUsers = *o.ExcludedUsers
		}
		qExcludedUsers := qrExcludedUsers
		if qExcludedUsers != "" {

			if err := r.SetQueryParam("excluded_users", qExcludedUsers); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
